/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.clipper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.CopyUtils;
import razgriz.news.NewsException;
import razgriz.news.clipper.NewsClipper;
import razgriz.news.model.News;

public class NewsClipperService {
    private List idToClipperList = new ArrayList();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public News clip(InputStream in) {
        try {
            News news;
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            try {
                CopyUtils.copy((InputStream)in, (OutputStream)baout);
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                baout.close();
                throw throwable;
            }
            {
                Object var3_7 = null;
            }
            baout.close();
            ByteArrayInputStream bain = new ByteArrayInputStream(baout.toByteArray());
            try {
                NewsClipper clipper = this.getSuitableClipper(bain);
                bain.reset();
                NewsClipper newsClipper = clipper;
                synchronized (newsClipper) {
                    news = clipper.clip(bain);
                }
                Object var6_10 = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                bain.close();
                throw throwable;
            }
            bain.close();
            return news;
        }
        catch (IOException e) {
            throw new NewsException(e);
        }
    }

    public synchronized void registerClipper(String id, NewsClipper clipper) {
        this.idToClipperList.add(new IdToClipperListEntry(id, clipper));
    }

    public synchronized NewsClipper getClipper(String clipperId) {
        IdToClipperListEntry entry = null;
        int i = 0;
        int len = this.idToClipperList.size();
        while (i < len) {
            entry = (IdToClipperListEntry)this.idToClipperList.get(i);
            if (entry.getId().equals(clipperId)) {
                return entry.getClipper();
            }
            ++i;
        }
        throw new NewsException("Unknown clipperId: clipperId=" + clipperId);
    }

    protected synchronized NewsClipper getSuitableClipper(InputStream in) {
        try {
            IdToClipperListEntry entry = null;
            NewsClipper clipper = null;
            int i = 0;
            int len = this.idToClipperList.size();
            while (i < len) {
                in.reset();
                entry = (IdToClipperListEntry)this.idToClipperList.get(i);
                clipper = entry.getClipper();
                if (clipper.canClip(in)) {
                    return clipper;
                }
                ++i;
            }
            throw new NewsException("Unsupported input");
        }
        catch (IOException e) {
            throw new NewsException(e);
        }
    }

    private static class IdToClipperListEntry {
        private String id;
        private NewsClipper clipper;

        public IdToClipperListEntry(String id, NewsClipper clipper) {
            this.id = id;
            this.clipper = clipper;
        }

        public String getId() {
            return this.id;
        }

        public NewsClipper getClipper() {
            return this.clipper;
        }
    }
}

