/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.model.rss10.clipper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import razgriz.common.text.XMLFirstElementPicker;
import razgriz.news.clipper.NewsClipper;
import razgriz.news.model.Article;
import razgriz.news.model.News;
import razgriz.news.model.NewsFactory;
import razgriz.news.model.rss10.Channel;
import razgriz.news.model.rss10.Item;
import razgriz.news.model.rss10.RDF;
import razgriz.news.model.rss10.util.DefaultRSS10ResourceFactoryImpl;

public class RSS10NewsClipper
implements NewsClipper {
    public boolean canClip(InputStream in) {
        XMLFirstElementPicker picker = new XMLFirstElementPicker();
        XMLFirstElementPicker.XMLElement elem = picker.pick(in);
        return "rdf:RDF".equals(elem.getQName());
    }

    public News clip(InputStream in) {
        URI uri = URI.createURI((String)"razgriz://stream");
        try {
            Resource res = new DefaultRSS10ResourceFactoryImpl().createResource(uri);
            res.load(in, null);
            if (res.getContents().isEmpty()) {
                throw new IllegalArgumentException("Document root element not found");
            }
            RDF rdf = (RDF)res.getContents().get(0);
            return this.convert(rdf);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public News convert(RDF rdf) {
        NewsFactory fact = NewsFactory.eINSTANCE;
        new ArrayList();
        Channel ch = rdf.getChannel();
        News news = fact.createNews();
        news.setDate(ch.getDcDate());
        news.setDescription(ch.getDescription());
        news.setLink(ch.getLink());
        news.setTitle(ch.getTitle());
        List items = rdf.getItem();
        int i = 0;
        int len = items.size();
        while (i < len) {
            Item item = (Item)items.get(i);
            Article article = fact.createArticle();
            article.setAuthor(item.getDcCreator());
            article.setDescription(item.getDescription());
            article.setLink(item.getLink());
            Date date = item.getDcDate();
            date = date == null ? new Date() : date;
            article.setDate(date);
            article.setTitle(item.getTitle());
            article.setRead(false);
            news.getArticles().add(article);
            ++i;
        }
        return news;
    }
}

