/*
 * Decompiled with CFR 0.152.
 */
package razgriz.app;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import razgriz.app.actions.CloseActiveEditorAction;
import razgriz.news.ui.perspectives.NewsPerspective;

public class RazgrizWorkbenchAdvisor
extends WorkbenchAdvisor {
    public String getInitialWindowPerspectiveId() {
        return NewsPerspective.ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
        super.preWindowOpen(configurer);
        configurer.setTitle("Razgriz");
        configurer.setShowCoolBar(true);
        configurer.setShowFastViewBars(true);
        configurer.setShowMenuBar(true);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowProgressIndicator(true);
        configurer.setShowStatusLine(true);
    }

    public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags) {
        super.fillActionBars(window, configurer, flags);
        if ((flags & 2) != 0) {
            this.fillMenuBar(window, configurer);
        }
    }

    private void fillMenuBar(IWorkbenchWindow window, IActionBarConfigurer configurer) {
        IMenuManager menuBar = configurer.getMenuManager();
        menuBar.add((IContributionItem)this.createFileMenu(window));
        menuBar.add((IContributionItem)this.createWindowMenu(window));
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createHelpMenu(window));
    }

    private MenuManager createFileMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager("\u30d5\u30a1\u30a4\u30eb(&F)", "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IAction)ActionFactory.QUIT.create(window));
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createWindowMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager("\u30a6\u30a3\u30f3\u30c9\u30a6(&W)", "window");
        menu.add((IAction)new CloseActiveEditorAction(window));
        menu.add((IContributionItem)new Separator());
        MenuManager viewMenu = new MenuManager("\u30d3\u30e5\u30fc\u306e\u8868\u793a(&V)");
        IContributionItem viewList = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        viewMenu.add(viewList);
        menu.add((IContributionItem)viewMenu);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IAction)ActionFactory.PREFERENCES.create(window));
        return menu;
    }

    private MenuManager createHelpMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager("\u30d8\u30eb\u30d7(&H)", "help");
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IAction)ActionFactory.ABOUT.create(window));
        return menu;
    }
}

