/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Util {
    public static final SortedMap EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    public static final SortedSet EMPTY_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet());
    public static final String ZERO_LENGTH_STRING = "";

    public static String safeString(String input) {
        if (input != null) {
            return input;
        }
        return ZERO_LENGTH_STRING;
    }

    public static void assertInstance(Object object, Class c) {
        Util.assertInstance(object, c, false);
    }

    public static void assertInstance(Object object, Class c, boolean allowNull) {
        if (object == null && allowNull) {
            return;
        }
        if (object == null || c == null) {
            throw new NullPointerException();
        }
        if (!c.isInstance(object)) {
            throw new IllegalArgumentException();
        }
    }

    public static int compare(boolean left, boolean right) {
        return !left ? (right ? -1 : 0) : 1;
    }

    public static int compare(Comparable left, Comparable right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.compareTo(right);
    }

    public static int compare(Comparable[] left, Comparable[] right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int l = left.length;
        int r = right.length;
        if (l != r) {
            return l - r;
        }
        int i = 0;
        while (i < l) {
            int compareTo = Util.compare(left[i], right[i]);
            if (compareTo != 0) {
                return compareTo;
            }
            ++i;
        }
        return 0;
    }

    public static int compare(int left, int right) {
        return left - right;
    }

    public static int compare(List left, List right) {
        int r;
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int l = left.size();
        if (l != (r = right.size())) {
            return l - r;
        }
        int i = 0;
        while (i < l) {
            int compareTo = Util.compare((Comparable)left.get(i), (Comparable)right.get(i));
            if (compareTo != 0) {
                return compareTo;
            }
            ++i;
        }
        return 0;
    }

    public static int compare(Object left, Object right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return left.toString().compareTo(right.toString());
    }

    public static final int compareIdentity(Object left, Object right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        return System.identityHashCode(left) - System.identityHashCode(right);
    }

    public static void diff(Map left, Map right, Set leftOnly, Set different, Set rightOnly) {
        Object key;
        if (left == null || right == null || leftOnly == null || different == null || rightOnly == null) {
            throw new NullPointerException();
        }
        Iterator iterator = left.keySet().iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            if (!right.containsKey(key)) {
                leftOnly.add(key);
                continue;
            }
            if (Util.equals(left.get(key), right.get(key))) continue;
            different.add(key);
        }
        iterator = right.keySet().iterator();
        while (iterator.hasNext()) {
            key = iterator.next();
            if (left.containsKey(key)) continue;
            rightOnly.add(key);
        }
    }

    public static void diff(Set left, Set right, Set leftOnly, Set rightOnly) {
        Object object;
        if (left == null || right == null || leftOnly == null || rightOnly == null) {
            throw new NullPointerException();
        }
        Iterator iterator = left.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (right.contains(object)) continue;
            leftOnly.add(object);
        }
        iterator = right.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (left.contains(object)) continue;
            rightOnly.add(object);
        }
    }

    public static boolean endsWith(List left, List right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int l = left.size();
        int r = right.size();
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Util.equals(left.get(l - i - 1), right.get(r - i - 1))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWith(Object[] left, Object[] right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int r = right.length;
        int l = left.length;
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Util.equals(left[l - i - 1], right[r - i - 1])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(boolean left, boolean right) {
        return left == right;
    }

    public static boolean equals(int left, int right) {
        return left == right;
    }

    public static boolean equals(Object left, Object right) {
        return left == null ? right == null : right != null && left.equals(right);
    }

    public static int hashCode(boolean b) {
        return b ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public static int hashCode(int i) {
        return i;
    }

    public static int hashCode(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public static Collection safeCopy(Collection collection, Class c) {
        return Util.safeCopy(collection, c, false);
    }

    public static Collection safeCopy(Collection collection, Class c, boolean allowNullElements) {
        if (collection == null || c == null) {
            throw new NullPointerException();
        }
        collection = Collections.unmodifiableCollection(new ArrayList(collection));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), c, allowNullElements);
        }
        return collection;
    }

    public static List safeCopy(List list, Class c) {
        return Util.safeCopy(list, c, false);
    }

    public static List safeCopy(List list, Class c, boolean allowNullElements) {
        if (list == null || c == null) {
            throw new NullPointerException();
        }
        list = Collections.unmodifiableList(new ArrayList(list));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), c, allowNullElements);
        }
        return list;
    }

    public static Map safeCopy(Map map, Class keyClass, Class valueClass) {
        return Util.safeCopy(map, keyClass, valueClass, false, false);
    }

    public static Map safeCopy(Map map, Class keyClass, Class valueClass, boolean allowNullKeys, boolean allowNullValues) {
        if (map == null || keyClass == null || valueClass == null) {
            throw new NullPointerException();
        }
        map = Collections.unmodifiableMap(new HashMap(map));
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Util.assertInstance(entry.getKey(), keyClass, allowNullKeys);
            Util.assertInstance(entry.getValue(), valueClass, allowNullValues);
        }
        return map;
    }

    public static Set safeCopy(Set set, Class c) {
        return Util.safeCopy(set, c, false);
    }

    public static Set safeCopy(Set set, Class c, boolean allowNullElements) {
        if (set == null || c == null) {
            throw new NullPointerException();
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), c, allowNullElements);
        }
        return set;
    }

    public static SortedMap safeCopy(SortedMap sortedMap, Class keyClass, Class valueClass) {
        return Util.safeCopy(sortedMap, keyClass, valueClass, false, false);
    }

    public static SortedMap safeCopy(SortedMap sortedMap, Class keyClass, Class valueClass, boolean allowNullKeys, boolean allowNullValues) {
        if (sortedMap == null || keyClass == null || valueClass == null) {
            throw new NullPointerException();
        }
        sortedMap = Collections.unmodifiableSortedMap(new TreeMap(sortedMap));
        Iterator iterator = sortedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Util.assertInstance(entry.getKey(), keyClass, allowNullKeys);
            Util.assertInstance(entry.getValue(), valueClass, allowNullValues);
        }
        return sortedMap;
    }

    public static SortedSet safeCopy(SortedSet sortedSet, Class c) {
        return Util.safeCopy(sortedSet, c, false);
    }

    public static SortedSet safeCopy(SortedSet sortedSet, Class c, boolean allowNullElements) {
        if (sortedSet == null || c == null) {
            throw new NullPointerException();
        }
        sortedSet = Collections.unmodifiableSortedSet(new TreeSet(sortedSet));
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), c, allowNullElements);
        }
        return sortedSet;
    }

    public static boolean startsWith(List left, List right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int l = left.size();
        int r = right.size();
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Util.equals(left.get(i), right.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWith(Object[] left, Object[] right, boolean equals) {
        if (left == null || right == null) {
            return false;
        }
        int r = right.length;
        int l = left.length;
        if (r > l || !equals && r == l) {
            return false;
        }
        int i = 0;
        while (i < r) {
            if (!Util.equals(left[i], right[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String translateString(ResourceBundle resourceBundle, String key) {
        return Util.translateString(resourceBundle, key, key, true, true);
    }

    public static String translateString(ResourceBundle resourceBundle, String key, String string, boolean signal, boolean trim) {
        block4: {
            if (resourceBundle != null && key != null) {
                try {
                    String translatedString = resourceBundle.getString(key);
                    if (translatedString != null) {
                        return trim ? translatedString.trim() : translatedString;
                    }
                }
                catch (MissingResourceException eMissingResource) {
                    if (!signal) break block4;
                    System.err.println(eMissingResource);
                }
            }
        }
        return trim ? string.trim() : string;
    }

    private Util() {
    }
}

