/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ThemeDescriptor;
import org.eclipse.ui.internal.themes.ThemeElementCategory;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.themes.IColorFactory;

public class ThemeRegistryReader
extends RegistryReader {
    public static final String ATT_CATEGORYID = "categoryId";
    public static final String ATT_PRESENTATIONID = "presentationId";
    public static final String ATT_CLASS = "class";
    public static final String ATT_DEFAULTS_TO = "defaultsTo";
    public static final String ATT_ID = "id";
    public static final String ATT_PARENT_ID = "parentId";
    public static final String ATT_IS_EDITABLE = "isEditable";
    public static final String ATT_LABEL = "label";
    public static final String ATT_VALUE = "value";
    public static final String ATT_NAME = "name";
    public static final String ATT_OS = "os";
    public static final String ATT_WS = "ws";
    public static final String ATT_COLORFACTORY = "colorFactory";
    private static final ResourceBundle RESOURCE_BUNDLE;
    public static final String TAG_CATEGORYPRESENTATIONBINDING = "categoryPresentationBinding";
    public static final String TAG_CATEGORYDEFINITION = "themeElementCategory";
    public static final String TAG_COLORDEFINITION = "colorDefinition";
    public static final String TAG_COLOROVERRIDE = "colorOverride";
    public static final String TAG_COLORVALUE = "colorValue";
    public static final String TAG_FONTDEFINITION = "fontDefinition";
    public static final String TAG_FONTOVERRIDE = "fontOverride";
    public static final String TAG_FONTVALUE = "fontValue";
    public static final String TAG_DATA = "data";
    public static final String TAG_THEME = "theme";
    private Collection categoryDefinitions = new ArrayList();
    private Collection colorDefinitions = new ArrayList();
    private Collection fontDefinitions = new ArrayList();
    private ThemeDescriptor themeDescriptor = null;
    private ThemeRegistry themeRegistry;
    private Map dataMap = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.themes.ThemeRegistryReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
    }

    public Collection getCategoryDefinitions() {
        return this.categoryDefinitions;
    }

    public Collection getColorDefinitions() {
        return this.colorDefinitions;
    }

    public Map getData() {
        return this.dataMap;
    }

    public Collection getFontDefinitions() {
        return this.fontDefinitions;
    }

    private ThemeElementCategory readCategory(IConfigurationElement element) {
        String name = element.getAttribute(ATT_LABEL);
        String id = element.getAttribute(ATT_ID);
        String parentId = element.getAttribute(ATT_PARENT_ID);
        String description = null;
        IConfigurationElement[] descriptions = element.getChildren("description");
        if (descriptions.length > 0) {
            description = descriptions[0].getValue();
        }
        return new ThemeElementCategory(name, id, parentId, description, element.getDeclaringExtension().getNamespace(), element);
    }

    private ColorDefinition readColor(IConfigurationElement element) {
        IConfigurationElement[] descriptions;
        String name = element.getAttribute(ATT_LABEL);
        String id = element.getAttribute(ATT_ID);
        String defaultMapping = element.getAttribute(ATT_DEFAULTS_TO);
        String value = this.getPlatformSpecificColorValue(element.getChildren(TAG_COLORVALUE));
        if (value == null) {
            value = this.getColorValue(element);
        }
        if (value == null && defaultMapping == null || value != null && defaultMapping != null) {
            RegistryReader.logError(element, RESOURCE_BUNDLE.getString("Colors.badDefault"));
            return null;
        }
        String categoryId = element.getAttribute(ATT_CATEGORYID);
        String description = null;
        boolean isEditable = true;
        String isEditableString = element.getAttribute(ATT_IS_EDITABLE);
        if (isEditableString != null) {
            isEditable = Boolean.valueOf(isEditableString);
        }
        if ((descriptions = element.getChildren("description")).length > 0) {
            description = descriptions[0].getValue();
        }
        return new ColorDefinition(name, id, defaultMapping, value, categoryId, isEditable, description, element.getDeclaringExtension().getNamespace());
    }

    private String getColorValue(IConfigurationElement element) {
        if (element == null) {
            return null;
        }
        String value = element.getAttribute(ATT_VALUE);
        if (value == null) {
            value = this.checkColorFactory(element);
        }
        return value;
    }

    private String getPlatformSpecificColorValue(IConfigurationElement[] elements) {
        return this.getColorValue(this.getBestPlatformMatch(elements));
    }

    private IConfigurationElement getBestPlatformMatch(IConfigurationElement[] elements) {
        IConfigurationElement match = null;
        String osname = Platform.getOS();
        String wsname = Platform.getWS();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String elementOs = element.getAttribute(ATT_OS);
            String elementWs = element.getAttribute(ATT_WS);
            if (osname.equalsIgnoreCase(elementOs)) {
                if (wsname.equalsIgnoreCase(elementWs)) {
                    return element;
                }
                match = element;
            } else if (wsname.equalsIgnoreCase(elementWs)) {
                match = element;
            }
            ++i;
        }
        return match;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean readElement(IConfigurationElement element) {
        String elementName = element.getName();
        if (this.themeDescriptor == null && elementName.equals(TAG_COLORDEFINITION)) {
            ColorDefinition definition = this.readColor(element);
            if (definition == null) return true;
            this.colorDefinitions.add(definition);
            this.themeRegistry.add(definition);
            return true;
        }
        if (this.themeDescriptor != null && elementName.equals(TAG_COLOROVERRIDE)) {
            ColorDefinition definition = this.readColor(element);
            if (definition == null) return true;
            this.themeDescriptor.add(definition);
            return true;
        }
        if (this.themeDescriptor == null && elementName.equals(TAG_FONTDEFINITION)) {
            FontDefinition definition = this.readFont(element);
            if (definition == null) return true;
            this.fontDefinitions.add(definition);
            this.themeRegistry.add(definition);
            return true;
        }
        if (this.themeDescriptor != null && elementName.equals(TAG_FONTOVERRIDE)) {
            FontDefinition definition = this.readFont(element);
            if (definition == null) return true;
            this.themeDescriptor.add(definition);
            return true;
        }
        if (this.themeDescriptor == null && elementName.equals(TAG_CATEGORYDEFINITION)) {
            ThemeElementCategory definition = this.readCategory(element);
            if (definition == null) return true;
            this.categoryDefinitions.add(definition);
            this.themeRegistry.add(definition);
            return true;
        }
        if (element.getName().equals(TAG_THEME)) {
            if (this.themeDescriptor != null) {
                RegistryReader.logError(element, RESOURCE_BUNDLE.getString("Themes.badNesting"));
                return false;
            }
            this.themeDescriptor = this.readTheme(element);
            if (this.themeDescriptor == null) return true;
            this.readElementChildren(element);
            this.themeDescriptor = null;
            return true;
        }
        if (this.themeDescriptor != null && elementName.equals("description")) {
            this.themeDescriptor.setDescription(element.getValue());
            return true;
        }
        if (!elementName.equals(TAG_DATA)) {
            if (!elementName.equals(TAG_CATEGORYPRESENTATIONBINDING)) return false;
            String categoryId = element.getAttribute(ATT_CATEGORYID);
            String presentationId = element.getAttribute(ATT_PRESENTATIONID);
            this.themeRegistry.addCategoryPresentationBinding(categoryId, presentationId);
            return true;
        }
        String name = element.getAttribute(ATT_NAME);
        String value = element.getAttribute(ATT_VALUE);
        if (name == null || value == null) {
            RegistryReader.logError(element, RESOURCE_BUNDLE.getString("Data.badData"));
            return true;
        }
        if (this.themeDescriptor != null) {
            this.themeDescriptor.setData(name, value);
            return true;
        }
        this.themeRegistry.setData(name, value);
        this.dataMap.put(name, value);
        return true;
    }

    private FontDefinition readFont(IConfigurationElement element) {
        String name = element.getAttribute(ATT_LABEL);
        String id = element.getAttribute(ATT_ID);
        String defaultMapping = element.getAttribute(ATT_DEFAULTS_TO);
        String value = this.getPlatformSpecificFontValue(element.getChildren(TAG_FONTVALUE));
        if (value == null) {
            value = element.getAttribute(ATT_VALUE);
        }
        if (value != null && defaultMapping != null) {
            RegistryReader.logError(element, RESOURCE_BUNDLE.getString("Fonts.badDefault"));
            return null;
        }
        String categoryId = element.getAttribute(ATT_CATEGORYID);
        boolean isEditable = true;
        String isEditableString = element.getAttribute(ATT_IS_EDITABLE);
        if (isEditableString != null) {
            isEditable = Boolean.valueOf(isEditableString);
        }
        String description = null;
        IConfigurationElement[] descriptions = element.getChildren("description");
        if (descriptions.length > 0) {
            description = descriptions[0].getValue();
        }
        return new FontDefinition(name, id, defaultMapping, value, categoryId, isEditable, description);
    }

    private String getPlatformSpecificFontValue(IConfigurationElement[] elements) {
        return this.getFontValue(this.getBestPlatformMatch(elements));
    }

    private String getFontValue(IConfigurationElement element) {
        if (element == null) {
            return null;
        }
        return element.getAttribute(ATT_VALUE);
    }

    private String checkColorFactory(IConfigurationElement element) {
        String value = null;
        if (element.getAttribute(ATT_COLORFACTORY) != null || element.getChildren(ATT_COLORFACTORY).length > 0) {
            try {
                IColorFactory factory = (IColorFactory)element.createExecutableExtension(ATT_COLORFACTORY);
                value = StringConverter.asString((RGB)factory.createColor());
            }
            catch (Exception e) {
                WorkbenchPlugin.log(RESOURCE_BUNDLE.getString("Colors.badFactory"), StatusUtil.newStatus(4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            }
        }
        return value;
    }

    protected ThemeDescriptor readTheme(IConfigurationElement element) {
        ThemeDescriptor desc = null;
        try {
            desc = new ThemeDescriptor(element);
            this.themeRegistry.add(desc);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Unable to create theme descriptor.", e.getStatus());
        }
        return desc;
    }

    public void readThemes(IExtensionRegistry in, ThemeRegistry out) throws CoreException {
        this.setRegistry(out);
        this.readRegistry(in, "org.eclipse.ui", "themes");
        this.readRegistry(in, "org.eclipse.ui", "fontDefinitions");
    }

    public void setRegistry(ThemeRegistry out) {
        this.themeRegistry = out;
    }
}

