/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.Comparator;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.ui.internal.keys.AbstractKeyFormatter;
import org.eclipse.ui.internal.keys.AbstractModifierKeyComparator;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.CharacterKey;
import org.eclipse.ui.keys.Key;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.ModifierKey;
import org.eclipse.ui.keys.SpecialKey;

public final class MacKeyFormatter
extends AbstractKeyFormatter {
    private static final HashMap KEY_LOOKUP = new HashMap();
    private static final Comparator MODIFIER_KEY_COMPARATOR = new MacModifierKeyComparator();
    private static final ResourceBundle RESOURCE_BUNDLE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.keys.MacKeyFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(clazz.getName());
        KEY_LOOKUP.put(CharacterKey.BS.toString(), Character.toString('\u232b'));
        KEY_LOOKUP.put(CharacterKey.CR.toString(), Character.toString('\u21a9'));
        KEY_LOOKUP.put(CharacterKey.DEL.toString(), Character.toString('\u2326'));
        KEY_LOOKUP.put(CharacterKey.SPACE.toString(), Character.toString('\u2423'));
        KEY_LOOKUP.put(ModifierKey.ALT.toString(), Character.toString('\u2325'));
        KEY_LOOKUP.put(ModifierKey.COMMAND.toString(), Character.toString('\u2318'));
        KEY_LOOKUP.put(ModifierKey.CTRL.toString(), Character.toString('\u2303'));
        KEY_LOOKUP.put(ModifierKey.SHIFT.toString(), Character.toString('\u21e7'));
        KEY_LOOKUP.put(SpecialKey.ARROW_DOWN.toString(), Character.toString('\u2193'));
        KEY_LOOKUP.put(SpecialKey.ARROW_LEFT.toString(), Character.toString('\u2190'));
        KEY_LOOKUP.put(SpecialKey.ARROW_RIGHT.toString(), Character.toString('\u2192'));
        KEY_LOOKUP.put(SpecialKey.ARROW_UP.toString(), Character.toString('\u2191'));
        KEY_LOOKUP.put(SpecialKey.END.toString(), Character.toString('\u2198'));
        KEY_LOOKUP.put(SpecialKey.NUMPAD_ENTER.toString(), Character.toString('\u2324'));
        KEY_LOOKUP.put(SpecialKey.HOME.toString(), Character.toString('\u2196'));
        KEY_LOOKUP.put(SpecialKey.PAGE_DOWN.toString(), Character.toString('\u21df'));
        KEY_LOOKUP.put(SpecialKey.PAGE_UP.toString(), Character.toString('\u21de'));
    }

    public String format(Key key) {
        String string = (String)KEY_LOOKUP.get(key.toString());
        return string != null ? string : super.format(key);
    }

    protected String getKeyDelimiter() {
        return Util.translateString(RESOURCE_BUNDLE, "KEY_DELIMITER", "", false, false);
    }

    protected String getKeyStrokeDelimiter() {
        return Util.translateString(RESOURCE_BUNDLE, "KEY_STROKE_DELIMITER", KeySequence.KEY_STROKE_DELIMITER, false, false);
    }

    protected Comparator getModifierKeyComparator() {
        return MODIFIER_KEY_COMPARATOR;
    }

    private static final class MacModifierKeyComparator
    extends AbstractModifierKeyComparator {
        MacModifierKeyComparator() {
        }

        protected int rank(ModifierKey modifierKey) {
            if (ModifierKey.SHIFT.equals(modifierKey)) {
                return 0;
            }
            if (ModifierKey.CTRL.equals(modifierKey)) {
                return 1;
            }
            if (ModifierKey.ALT.equals(modifierKey)) {
                return 2;
            }
            if (ModifierKey.COMMAND.equals(modifierKey)) {
                return 3;
            }
            return Integer.MAX_VALUE;
        }
    }
}

