/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui.views;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import razgriz.news.NewsException;
import razgriz.news.model.Favorite;
import razgriz.news.model.FavoriteList;
import razgriz.news.model.Group;
import razgriz.news.model.News;
import razgriz.news.model.util.ModelVisitor;
import razgriz.news.model.util.NewsSwitch;
import razgriz.news.ui.NewsUIPlugin;
import razgriz.news.ui.actions.AddGroupAction;
import razgriz.news.ui.actions.AddNewsAction;
import razgriz.news.ui.actions.AddRootGroupAction;
import razgriz.news.ui.actions.EditGroupAction;
import razgriz.news.ui.actions.EditNewsAction;
import razgriz.news.ui.actions.ExportOPMLAction;
import razgriz.news.ui.actions.ImportOPMLAction;
import razgriz.news.ui.actions.MarkAsReadAllAction;
import razgriz.news.ui.actions.RemoveFavoriteAction;
import razgriz.news.ui.dnd.FavoriteTransfer;
import razgriz.news.ui.views.ArticleListView;
import razgriz.news.ui.views.FavoriteListTreeContentProvider;
import razgriz.news.visitor.NewsClippingVisitor;

public class FavoriteListView
extends ViewPart {
    public static final String ID;
    private Composite parent;
    private TreeViewer viewer;
    private FavoriteListTreeContentProvider provider;
    private Action addGroupAction;
    private Action addRootGroupAction;
    private Action addNewsAction;
    private Action editGroupAction;
    private Action editNewsAction;
    private Action removeFavoriteAction;
    private Action markAsReadAllAction;
    private Action importOPMLAction;
    private Action exportOPMLAction;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("razgriz.news.ui.views.FavoriteListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.viewer = new TreeViewer(parent, 770);
        FavoriteListTreeContentProvider provider = new FavoriteListTreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.viewer.setInput((Object)NewsUIPlugin.getFavoriteList());
        this.supportDND();
        this.makeActions();
        this.contributeToActionBars();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    private ImageDescriptor getSharedImageDescriptor(String descstr) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(descstr);
    }

    private void makeActions() {
        this.addGroupAction = new AddGroupAction((IWorkbenchSite)this.getSite(), (Viewer)this.viewer);
        this.addRootGroupAction = new AddRootGroupAction((IWorkbenchSite)this.getSite(), (Viewer)this.viewer);
        this.addNewsAction = new AddNewsAction((IWorkbenchSite)this.getSite(), (Viewer)this.viewer);
        this.editGroupAction = new EditGroupAction((IWorkbenchSite)this.getSite(), (Viewer)this.viewer);
        this.editNewsAction = new EditNewsAction((IWorkbenchSite)this.getSite(), (Viewer)this.viewer);
        this.removeFavoriteAction = new RemoveFavoriteAction((IWorkbenchSite)this.getSite(), (Viewer)this.viewer);
        this.markAsReadAllAction = new MarkAsReadAllAction((IWorkbenchSite)this.getSite(), (Viewer)this.viewer);
        this.importOPMLAction = new ImportOPMLAction((IWorkbenchSite)this.getSite(), (Viewer)this.viewer);
        this.exportOPMLAction = new ExportOPMLAction((IWorkbenchSite)this.getSite(), (Viewer)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FavoriteListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Iterator ite = sel.iterator();
                while (ite.hasNext()) {
                    Object obj = ite.next();
                    if (obj instanceof Group) {
                        FavoriteListView.this.viewer.setExpandedState(obj, !FavoriteListView.this.viewer.getExpandedState(obj));
                        continue;
                    }
                    if (!(obj instanceof News)) continue;
                    News news = (News)obj;
                    try {
                        news.accept((ModelVisitor)new NewsClippingVisitor());
                        IPreferenceStore store = NewsUIPlugin.getDefault().getPreferenceStore();
                        IWorkbenchPage wpage = FavoriteListView.this.getSite().getPage();
                        ArticleListView view = store.getBoolean("reuseArticleListView") ? (ArticleListView)wpage.showView(ArticleListView.ID) : (ArticleListView)wpage.showView(ArticleListView.ID, ArticleListView.createSecondaryId(news), 1);
                        view.setInput(news);
                    }
                    catch (NewsException e) {
                        MessageDialog.openError((Shell)FavoriteListView.this.getSite().getShell(), (String)"\u8a18\u4e8b\u306e\u66f4\u65b0\u30a8\u30e9\u30fc", (String)("\u8a18\u4e8b\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + e.getMessage()));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e.getMessage());
                    }
                }
            }
        });
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.addRootGroupAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addRootGroupAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addNewsAction);
        manager.add((IAction)this.addRootGroupAction);
        manager.add((IAction)this.addGroupAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.editNewsAction);
        manager.add((IAction)this.editGroupAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.removeFavoriteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.markAsReadAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importOPMLAction);
        manager.add((IAction)this.exportOPMLAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additionsend"));
    }

    private void supportDND() {
        DragSource source = new DragSource((Control)this.viewer.getTree(), 3);
        FavoriteTransfer trans = FavoriteTransfer.getInstance();
        Transfer[] types = new Transfer[]{trans};
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent e) {
                IStructuredSelection sel = (IStructuredSelection)FavoriteListView.this.viewer.getSelection();
                e.data = sel.toArray();
            }
        });
        DropTarget target = new DropTarget((Control)this.viewer.getTree(), 23);
        Transfer[] types2 = new Transfer[]{FavoriteTransfer.getInstance()};
        target.setTransfer(types2);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent e) {
                e.feedback = 25;
            }

            public void drop(DropTargetEvent e) {
                TreeItem item = (TreeItem)e.item;
                Object itemdata = item.getData();
                if (itemdata instanceof Group) {
                    Group targetGrp = (Group)itemdata;
                    Object[] objs = (Object[])e.data;
                    targetGrp.getMembers().addAll(Arrays.asList(objs));
                } else if (itemdata instanceof News) {
                    News news = (News)itemdata;
                    Group targetGrp = news.getGroup();
                    int index = targetGrp.getMembers().indexOf(news);
                    Object[] objs = (Object[])e.data;
                    int i = 0;
                    while (i < objs.length) {
                        Favorite fav = (Favorite)objs[i];
                        new RemoveFromContainerSwitch(fav).doSwitch(fav.eContainer());
                        ++i;
                    }
                    if (index > targetGrp.getMembers().size()) {
                        targetGrp.getMembers().addAll(Arrays.asList(objs));
                    } else {
                        targetGrp.getMembers().addAll(index, Arrays.asList(objs));
                    }
                }
            }
        });
    }

    private class RemoveFromContainerSwitch
    extends NewsSwitch {
        private Favorite removed;

        public RemoveFromContainerSwitch(Favorite removed) {
            this.removed = removed;
        }

        public Object caseFavoriteList(FavoriteList favlist) {
            favlist.getFavorites().remove(this.removed);
            return favlist;
        }

        public Object caseGroup(Group group) {
            group.getMembers().remove(this.removed);
            return group;
        }
    }
}

