/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui.browser;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import razgriz.news.ui.NewsUIPlugin;
import razgriz.news.ui.browser.NewsBrowser;
import razgriz.news.ui.browser.NewsBrowserInput;
import razgriz.news.ui.browser.NewsEditorInput;

public class NewsEditor
extends MultiPageEditorPart
implements IReusableEditor {
    public static final String ID;
    private NewsBrowser browser;
    private Label titleLabel;
    private Label linkLabel;
    private Label descLabel;
    private int overviewPageIndex;
    private int browserPageIndex;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("razgriz.news.ui.browser.NewsEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
    }

    public NewsBrowser getNewsBrowser() {
        return this.browser;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.titleLabel != null && this.linkLabel != null && this.descLabel != null && this.browser != null) {
            NewsEditorInput ninput = (NewsEditorInput)input;
            this.titleLabel.setText("\u30bf\u30a4\u30c8\u30eb: " + ninput.getArticle().getTitle());
            this.linkLabel.setText("\u30ea\u30f3\u30af: " + ninput.getArticle().getLink());
            this.descLabel.setText("\u8aac\u660e: " + ninput.getArticle().getDescription());
            this.browser.setInput(new NewsBrowserInput(ninput.getArticle().getLink()));
        }
    }

    private void createOverviewPage() {
        NewsEditorInput input = (NewsEditorInput)this.getEditorInput();
        Composite composite = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.titleLabel = new Label(composite, 0);
        this.titleLabel.setLayoutData((Object)new GridData(768));
        this.titleLabel.setText("\u30bf\u30a4\u30c8\u30eb: " + input.getArticle().getTitle());
        this.linkLabel = new Label(composite, 0);
        this.linkLabel.setLayoutData((Object)new GridData(768));
        this.linkLabel.setText("\u30ea\u30f3\u30af: " + input.getArticle().getLink());
        this.descLabel = new Label(composite, 0);
        this.descLabel.setLayoutData((Object)new GridData(768));
        this.descLabel.setText("\u8aac\u660e: " + input.getArticle().getDescription());
        this.overviewPageIndex = this.addPage((Control)composite);
        this.setPageText(this.overviewPageIndex, "\u6982\u8981");
    }

    private void createBrowserPage() {
        NewsEditorInput input = (NewsEditorInput)this.getEditorInput();
        try {
            this.browser = new NewsBrowser();
            this.browserPageIndex = this.addPage((IEditorPart)this.browser, new NewsBrowserInput(input.getArticle().getLink()));
            this.browser.getBrowser().addTitleListener(new TitleListener(){

                public void changed(TitleEvent event) {
                    String str;
                    IPreferenceStore store = NewsUIPlugin.getDefault().getPreferenceStore();
                    int length = store.getInt("newsEditorMaxTabLength");
                    length = length < (str = event.title).length() ? length : str.length();
                    NewsEditor.this.setPartName(str.substring(0, length));
                }
            });
            this.setPageText(this.browserPageIndex, "\u30b3\u30f3\u30c6\u30f3\u30c4");
        }
        catch (PartInitException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    protected void createPages() {
        this.createOverviewPage();
        this.createBrowserPage();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void activateOverviewPage() {
        this.setActivePage(this.overviewPageIndex);
    }

    public void activateBrowserPage() {
        this.setActivePage(this.browserPageIndex);
    }
}

