/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchSite;
import razgriz.news.model.Favorite;
import razgriz.news.model.Group;
import razgriz.news.model.News;
import razgriz.news.model.NewsFactory;
import razgriz.news.model.opml.OPML;
import razgriz.news.model.opml.Outline;
import razgriz.news.ui.NewsUIPlugin;

public class ImportOPMLAction
extends Action {
    public static final String ID;
    IWorkbenchSite site;
    Viewer viewer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("razgriz.news.ui.actions.ImportOPMLAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
    }

    public ImportOPMLAction(IWorkbenchSite site, Viewer viewer) {
        this.site = site;
        this.viewer = viewer;
        this.setId(ID);
        this.setText("OPML\u30a4\u30f3\u30dd\u30fc\u30c8");
        this.setToolTipText("OPML\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u307e\u3059");
        this.setImageDescriptor(null);
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.site.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.opml"});
        String result = dialog.open();
        if (result != null) {
            URI uri = URI.createFileURI((String)result);
            Resource res = new ResourceSetImpl().createResource(uri);
            try {
                res.load(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            OPML opml = (OPML)res.getContents().get(0);
            List ollist = opml.getBody().getOutline();
            ArrayList<Favorite> favlist = new ArrayList<Favorite>();
            int i = 0;
            while (i < ollist.size()) {
                favlist.add(this.convert((Outline)ollist.get(i)));
                ++i;
            }
            NewsUIPlugin.getFavoriteList().getFavorites().addAll(favlist);
        }
    }

    public Favorite convert(Outline outline) {
        NewsFactory fact = NewsFactory.eINSTANCE;
        News ret = null;
        List children = outline.getOutline();
        if (children.isEmpty()) {
            News news = fact.createNews();
            String title = outline.getText();
            title = StringUtils.isEmpty((String)title) ? outline.getTitle() : title;
            news.setTitle(StringUtils.defaultString((String)title));
            news.setLink(StringUtils.defaultString((String)outline.getXmlUrl()));
            news.setDescription(StringUtils.defaultString((String)outline.getDescription()));
            ret = news;
        } else {
            Group grp = fact.createGroup();
            String title = outline.getText();
            title = StringUtils.isEmpty((String)title) ? outline.getTitle() : title;
            grp.setTitle(StringUtils.defaultString((String)title));
            grp.setDescription(StringUtils.defaultString((String)outline.getDescription()));
            List members = grp.getMembers();
            int i = 0;
            while (i < children.size()) {
                Outline child = (Outline)children.get(i);
                members.add(this.convert(child));
                ++i;
            }
            ret = grp;
        }
        return ret;
    }
}

