/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

class AutoBuildJob
extends Job
implements Preferences.IPropertyChangeListener {
    private boolean avoidBuild = false;
    private boolean buildNeeded = false;
    private boolean forceBuild = false;
    private boolean isAutoBuilding = false;
    private boolean interrupted = false;
    private long lastBuild = 0L;
    private Workspace workspace;
    private final IJobManager jobManager = Platform.getJobManager();
    private final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");

    AutoBuildJob(Workspace workspace) {
        super(ICoreConstants.MSG_EVENTS_BUILDING_0);
        this.setRule(workspace.getRoot());
        this.isAutoBuilding = workspace.isAutoBuilding();
        this.workspace = workspace;
        ResourcesPlugin.getPlugin().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    private void autoBuildChanged(boolean wasAutoBuilding, boolean isAutoBuilding) {
        this.isAutoBuilding = isAutoBuilding;
        if (!this.forceBuild && !wasAutoBuilding && isAutoBuilding) {
            this.forceBuild = true;
            this.build(false);
        }
    }

    synchronized void avoidBuild() {
        this.avoidBuild = true;
    }

    public boolean belongsTo(Object family) {
        return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
    }

    private void broadcastChanges(int type) throws CoreException {
        this.workspace.getNotificationManager().broadcastChanges(this.workspace.getElementTree(), type, false);
    }

    synchronized void build(boolean needsBuild) {
        this.buildNeeded |= needsBuild;
        this.interrupted = false;
        long delay = Math.max(100L, 1000L + this.lastBuild - System.currentTimeMillis());
        int state = this.getState();
        if (Policy.DEBUG_NEEDS_BUILD) {
            Policy.debug("Build requested, needsBuild: " + needsBuild + " state: " + JobManager.printState((int)state) + " delay: " + delay);
        }
        switch (state) {
            case 1: {
                this.wakeUp(delay);
                break;
            }
            case 0: {
                this.setSystem(!this.isAutoBuilding);
                this.schedule(delay);
            }
        }
    }

    private synchronized IStatus canceled() {
        this.buildNeeded = true;
        return Status.CANCEL_STATUS;
    }

    synchronized void interrupt() {
        if (this.interrupted) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                return;
            }
            case 2: {
                this.interrupted = !this.sleep();
                break;
            }
            case 4: {
                boolean bl = this.interrupted = this.jobManager.currentJob() != this;
            }
        }
        if (this.interrupted) {
            this.avoidBuild = false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doBuild(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, Policy.opWork);
            ISchedulingRule rule = this.workspace.getRuleFactory().buildRule();
            try {
                this.workspace.prepareOperation(rule, monitor);
                this.workspace.beginOperation(true);
                this.broadcastChanges(8);
                if (this.shouldBuild()) {
                    this.workspace.getBuildManager().build(9, Policy.subMonitorFor(monitor, Policy.opWork));
                }
                this.broadcastChanges(16);
                this.buildNeeded = false;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (this.workspace.getElementTree().isImmutable()) {
                    this.workspace.newWorkingTree();
                }
                this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (this.workspace.getElementTree().isImmutable()) {
                    this.workspace.newWorkingTree();
                }
                this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.buildWork));
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        monitor.done();
    }

    public void forceBuild() {
        this.forceBuild = true;
    }

    synchronized boolean isInterrupted() {
        if (this.interrupted) {
            return true;
        }
        if (this.isBlocking()) {
            this.interrupted = true;
        }
        return this.interrupted;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (!event.getProperty().equals("description.autobuilding")) {
            return;
        }
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (oldValue instanceof Boolean && newValue instanceof Boolean) {
            this.autoBuildChanged((Boolean)oldValue, (Boolean)newValue);
        }
    }

    public IStatus run(IProgressMonitor monitor) {
        AutoBuildJob autoBuildJob = this;
        synchronized (autoBuildJob) {
            if (monitor.isCanceled()) {
                return this.canceled();
            }
        }
        if (this.systemBundle.getState() == 16) {
            return Status.OK_STATUS;
        }
        try {
            this.doBuild(monitor);
            this.lastBuild = System.currentTimeMillis();
            this.interrupted = false;
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            return this.canceled();
        }
        catch (CoreException sig) {
            return sig.getStatus();
        }
    }

    private synchronized boolean shouldBuild() {
        block7: {
            block6: {
                block5: {
                    try {
                        if (this.workspace.isAutoBuilding()) break block5;
                        Object var1_1 = null;
                        this.buildNeeded = false;
                        this.avoidBuild = false;
                        this.forceBuild = false;
                        return false;
                    }
                    catch (Throwable throwable) {
                        Object var1_5 = null;
                        this.buildNeeded = false;
                        this.avoidBuild = false;
                        this.forceBuild = false;
                        throw throwable;
                    }
                }
                if (!this.forceBuild) break block6;
                Object var1_2 = null;
                this.buildNeeded = false;
                this.avoidBuild = false;
                this.forceBuild = false;
                return true;
            }
            if (!this.avoidBuild) break block7;
            Object var1_3 = null;
            this.buildNeeded = false;
            this.avoidBuild = false;
            this.forceBuild = false;
            return false;
        }
        boolean bl = this.buildNeeded;
        Object var1_4 = null;
        this.buildNeeded = false;
        this.avoidBuild = false;
        this.forceBuild = false;
        return bl;
    }
}

