/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui.views;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import razgriz.news.model.Article;
import razgriz.news.model.Favorite;
import razgriz.news.model.FavoriteList;
import razgriz.news.model.Group;
import razgriz.news.model.ModelElement;
import razgriz.news.model.News;
import razgriz.news.model.util.ModelVisitor;
import razgriz.news.model.util.NewsSwitch;
import razgriz.news.visitor.UnreadArticleCountingVisitor;

public class FavoriteListTreeContentProvider
extends LabelProvider
implements ITreeContentProvider,
Adapter {
    TreeViewer viewer;
    FavoriteList favoriteList;
    Set adaptedSet = new HashSet();

    public void addAdaption(EObject adapted) {
        adapted.eAdapters().add((Object)this);
        this.adaptedSet.add(adapted);
    }

    public void removeAdaption(EObject adapted) {
        this.adaptedSet.remove(adapted);
        adapted.eAdapters().remove((Object)this);
    }

    public void clearAdaption() {
        Iterator ite = this.adaptedSet.iterator();
        while (ite.hasNext()) {
            EObject adapted = (EObject)ite.next();
            adapted.eAdapters().remove((Object)this);
            ite.remove();
        }
    }

    public Object[] getChildren(Object element) {
        if (element instanceof News) {
            return new Object[0];
        }
        EObject eobj = (EObject)element;
        EList contents = eobj.eContents();
        return contents.toArray(new Object[contents.size()]);
    }

    public Object getParent(Object element) {
        EObject eobj = (EObject)element;
        return eobj.eContainer();
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        FavoriteList newFavlist = (FavoriteList)newInput;
        this.clearAdaption();
        if (newFavlist != null) {
            newFavlist.accept((ModelVisitor)new AdapterAddingVisitor(this));
        }
        this.favoriteList = newFavlist;
    }

    public void notifyChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        final Object obj = notification.getNotifier();
        final ViewerUpdateSwitch sw = new ViewerUpdateSwitch(this, notification);
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                sw.doSwitch((EObject)obj);
            }
        });
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public String getText(Object element) {
        EObject eobj = (EObject)element;
        NewsTreeLabelSwitch sw = new NewsTreeLabelSwitch();
        return (String)sw.doSwitch(eobj);
    }

    public Image getImage(Object obj) {
        EObject eobj = (EObject)obj;
        NewsTreeImageSwitch sw = new NewsTreeImageSwitch();
        return (Image)sw.doSwitch(eobj);
    }

    private class AdapterAddingVisitor
    extends ModelVisitor {
        private FavoriteListTreeContentProvider provider;

        public AdapterAddingVisitor(FavoriteListTreeContentProvider provider) {
            this.provider = provider;
        }

        public Object caseFavoriteList(FavoriteList favlist) {
            this.provider.addAdaption((EObject)favlist);
            return favlist;
        }

        public Object caseGroup(Group group) {
            this.provider.addAdaption((EObject)group);
            return group;
        }

        public Object caseNews(News news) {
            this.provider.addAdaption((EObject)news);
            return news;
        }

        public Object caseArticle(Article article) {
            this.provider.addAdaption((EObject)article);
            return article;
        }

        public boolean prune(ModelElement elem) {
            return false;
        }
    }

    private class ViewerUpdateSwitch
    extends NewsSwitch {
        private FavoriteListTreeContentProvider provider;
        private Notification notification;

        public ViewerUpdateSwitch(FavoriteListTreeContentProvider provider, Notification notification) {
            this.provider = provider;
            this.notification = notification;
        }

        private void updateAdapter() {
            switch (this.notification.getEventType()) {
                case 3: {
                    EObject eobj = (EObject)this.notification.getNewValue();
                    this.provider.addAdaption(eobj);
                    FavoriteListTreeContentProvider.this.viewer.refresh();
                    break;
                }
                case 5: {
                    List eobjlist = (List)this.notification.getNewValue();
                    int i = 0;
                    while (i < eobjlist.size()) {
                        EObject eobj = (EObject)eobjlist.get(i);
                        this.provider.addAdaption(eobj);
                        ++i;
                    }
                    FavoriteListTreeContentProvider.this.viewer.refresh();
                    break;
                }
                case 4: {
                    EObject eobj = (EObject)this.notification.getOldValue();
                    this.provider.removeAdaption(eobj);
                    FavoriteListTreeContentProvider.this.viewer.refresh();
                    break;
                }
                case 6: {
                    List eobjlist = (List)this.notification.getOldValue();
                    int i = 0;
                    while (i < eobjlist.size()) {
                        EObject eobj = (EObject)eobjlist.get(i);
                        this.provider.removeAdaption(eobj);
                        ++i;
                    }
                    FavoriteListTreeContentProvider.this.viewer.refresh();
                    break;
                }
                case 1: {
                    FavoriteListTreeContentProvider.this.viewer.refresh();
                }
            }
        }

        public Object caseFavoriteList(FavoriteList favlist) {
            this.updateAdapter();
            return favlist;
        }

        public Object caseFavorite(Favorite fav) {
            this.updateAdapter();
            return fav;
        }

        public Object caseArticle(Article article) {
            if (this.notification.getEventType() == 1) {
                FavoriteListTreeContentProvider.this.viewer.refresh();
            }
            return article;
        }
    }

    private class NewsTreeLabelSwitch
    extends NewsSwitch {
        NewsTreeLabelSwitch() {
        }

        public Object caseFavorite(Favorite favorite) {
            UnreadArticleCountingVisitor visitor = new UnreadArticleCountingVisitor();
            favorite.accept((ModelVisitor)visitor);
            String countstr = visitor.getResult() > 0 ? " (" + visitor.getResult() + ")" : "";
            return String.valueOf(favorite.getTitle()) + countstr;
        }
    }

    private class NewsTreeImageSwitch
    extends NewsSwitch {
        NewsTreeImageSwitch() {
        }

        private Image getImage(String str) {
            return PlatformUI.getWorkbench().getSharedImages().getImage(str);
        }

        public Object caseNews(News news) {
            return this.getImage("IMG_OBJ_FILE");
        }

        public Object caseGroup(Group group) {
            return this.getImage("IMG_OBJ_FOLDER");
        }
    }
}

