/**
 * <copyright>
 * </copyright>
 *
 * $Id: NewsImpl.java,v 1.2 2005/03/02 16:06:51 mkamo Exp $
 */
package razgriz.news.model.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import razgriz.news.model.Article;
import razgriz.news.model.FavoriteList;
import razgriz.news.model.Group;
import razgriz.news.model.News;
import razgriz.news.model.NewsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>News</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link razgriz.news.model.impl.NewsImpl#getTitle <em>Title</em>}</li>
 *   <li>{@link razgriz.news.model.impl.NewsImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link razgriz.news.model.impl.NewsImpl#getFavoriteList <em>Favorite List</em>}</li>
 *   <li>{@link razgriz.news.model.impl.NewsImpl#getGroup <em>Group</em>}</li>
 *   <li>{@link razgriz.news.model.impl.NewsImpl#getLink <em>Link</em>}</li>
 *   <li>{@link razgriz.news.model.impl.NewsImpl#getDate <em>Date</em>}</li>
 *   <li>{@link razgriz.news.model.impl.NewsImpl#getArticles <em>Articles</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class NewsImpl extends ModelElementImpl implements News {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "KAMO Masahiko";

    /**
     * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTitle()
     * @generated
     * @ordered
     */
    protected static final String TITLE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getTitle() <em>Title</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTitle()
     * @generated
     * @ordered
     */
    protected String title = TITLE_EDEFAULT;

    /**
     * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDescription()
     * @generated
     * @ordered
     */
    protected static final String DESCRIPTION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDescription()
     * @generated
     * @ordered
     */
    protected String description = DESCRIPTION_EDEFAULT;

    /**
     * The default value of the '{@link #getLink() <em>Link</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLink()
     * @generated
     * @ordered
     */
    protected static final String LINK_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLink() <em>Link</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLink()
     * @generated
     * @ordered
     */
    protected String link = LINK_EDEFAULT;

    /**
     * The default value of the '{@link #getDate() <em>Date</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDate()
     * @generated
     * @ordered
     */
    protected static final Date DATE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDate() <em>Date</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDate()
     * @generated
     * @ordered
     */
    protected Date date = DATE_EDEFAULT;

    /**
     * The cached value of the '{@link #getArticles() <em>Articles</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getArticles()
     * @generated
     * @ordered
     */
    protected EList articles = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected NewsImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return NewsPackage.eINSTANCE.getNews();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getTitle() {
        return title;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setTitle(String newTitle) {
        String oldTitle = title;
        title = newTitle;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.NEWS__TITLE, oldTitle, title));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getLink() {
        return link;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLink(String newLink) {
        String oldLink = link;
        link = newLink;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.NEWS__LINK, oldLink, link));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getDescription() {
        return description;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDescription(String newDescription) {
        String oldDescription = description;
        description = newDescription;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.NEWS__DESCRIPTION, oldDescription, description));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public FavoriteList getFavoriteList() {
        if (eContainerFeatureID != NewsPackage.NEWS__FAVORITE_LIST) return null;
        return (FavoriteList)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setFavoriteList(FavoriteList newFavoriteList) {
        if (newFavoriteList != eContainer || (eContainerFeatureID != NewsPackage.NEWS__FAVORITE_LIST && newFavoriteList != null)) {
            if (EcoreUtil.isAncestor(this, (EObject)newFavoriteList))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newFavoriteList != null)
                msgs = ((InternalEObject)newFavoriteList).eInverseAdd(this, NewsPackage.FAVORITE_LIST__FAVORITES, FavoriteList.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newFavoriteList, NewsPackage.NEWS__FAVORITE_LIST, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.NEWS__FAVORITE_LIST, newFavoriteList, newFavoriteList));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Group getGroup() {
        if (eContainerFeatureID != NewsPackage.NEWS__GROUP) return null;
        return (Group)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setGroup(Group newGroup) {
        if (newGroup != eContainer || (eContainerFeatureID != NewsPackage.NEWS__GROUP && newGroup != null)) {
            if (EcoreUtil.isAncestor(this, (EObject)newGroup))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newGroup != null)
                msgs = ((InternalEObject)newGroup).eInverseAdd(this, NewsPackage.GROUP__MEMBERS, Group.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newGroup, NewsPackage.NEWS__GROUP, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.NEWS__GROUP, newGroup, newGroup));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Date getDate() {
        return date;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDate(Date newDate) {
        Date oldDate = date;
        date = newDate;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.NEWS__DATE, oldDate, date));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public List getArticles() {
        if (articles == null) {
            articles = new EObjectContainmentWithInverseEList(Article.class, this, NewsPackage.NEWS__ARTICLES, NewsPackage.ARTICLE__NEWS);
        }
        return articles;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case NewsPackage.NEWS__FAVORITE_LIST:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, NewsPackage.NEWS__FAVORITE_LIST, msgs);
                case NewsPackage.NEWS__GROUP:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, NewsPackage.NEWS__GROUP, msgs);
                case NewsPackage.NEWS__ARTICLES:
                    return ((InternalEList)getArticles()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case NewsPackage.NEWS__FAVORITE_LIST:
                    return eBasicSetContainer(null, NewsPackage.NEWS__FAVORITE_LIST, msgs);
                case NewsPackage.NEWS__GROUP:
                    return eBasicSetContainer(null, NewsPackage.NEWS__GROUP, msgs);
                case NewsPackage.NEWS__ARTICLES:
                    return ((InternalEList)getArticles()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case NewsPackage.NEWS__FAVORITE_LIST:
                    return ((InternalEObject)eContainer).eInverseRemove(this, NewsPackage.FAVORITE_LIST__FAVORITES, FavoriteList.class, msgs);
                case NewsPackage.NEWS__GROUP:
                    return ((InternalEObject)eContainer).eInverseRemove(this, NewsPackage.GROUP__MEMBERS, Group.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.NEWS__TITLE:
                return getTitle();
            case NewsPackage.NEWS__DESCRIPTION:
                return getDescription();
            case NewsPackage.NEWS__FAVORITE_LIST:
                return getFavoriteList();
            case NewsPackage.NEWS__GROUP:
                return getGroup();
            case NewsPackage.NEWS__LINK:
                return getLink();
            case NewsPackage.NEWS__DATE:
                return getDate();
            case NewsPackage.NEWS__ARTICLES:
                return getArticles();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.NEWS__TITLE:
                setTitle((String)newValue);
                return;
            case NewsPackage.NEWS__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case NewsPackage.NEWS__FAVORITE_LIST:
                setFavoriteList((FavoriteList)newValue);
                return;
            case NewsPackage.NEWS__GROUP:
                setGroup((Group)newValue);
                return;
            case NewsPackage.NEWS__LINK:
                setLink((String)newValue);
                return;
            case NewsPackage.NEWS__DATE:
                setDate((Date)newValue);
                return;
            case NewsPackage.NEWS__ARTICLES:
                getArticles().clear();
                getArticles().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.NEWS__TITLE:
                setTitle(TITLE_EDEFAULT);
                return;
            case NewsPackage.NEWS__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case NewsPackage.NEWS__FAVORITE_LIST:
                setFavoriteList((FavoriteList)null);
                return;
            case NewsPackage.NEWS__GROUP:
                setGroup((Group)null);
                return;
            case NewsPackage.NEWS__LINK:
                setLink(LINK_EDEFAULT);
                return;
            case NewsPackage.NEWS__DATE:
                setDate(DATE_EDEFAULT);
                return;
            case NewsPackage.NEWS__ARTICLES:
                getArticles().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.NEWS__TITLE:
                return TITLE_EDEFAULT == null ? title != null : !TITLE_EDEFAULT.equals(title);
            case NewsPackage.NEWS__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case NewsPackage.NEWS__FAVORITE_LIST:
                return getFavoriteList() != null;
            case NewsPackage.NEWS__GROUP:
                return getGroup() != null;
            case NewsPackage.NEWS__LINK:
                return LINK_EDEFAULT == null ? link != null : !LINK_EDEFAULT.equals(link);
            case NewsPackage.NEWS__DATE:
                return DATE_EDEFAULT == null ? date != null : !DATE_EDEFAULT.equals(date);
            case NewsPackage.NEWS__ARTICLES:
                return articles != null && !articles.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (title: ");
        result.append(title);
        result.append(", description: ");
        result.append(description);
        result.append(", link: ");
        result.append(link);
        result.append(", date: ");
        result.append(date);
        result.append(')');
        return result.toString();
    }

} //NewsImpl
