/**
 * <copyright>
 * </copyright>
 *
 * $Id: ChannelImpl.java,v 1.1 2005/02/26 07:23:07 mkamo Exp $
 */
package razgriz.news.model.rss20.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import razgriz.news.model.rss20.Channel;
import razgriz.news.model.rss20.Image;
import razgriz.news.model.rss20.Item;
import razgriz.news.model.rss20.RSS;
import razgriz.news.model.rss20.RSS20Package;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Channel</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getTitle <em>Title</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getLink <em>Link</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getLanguage <em>Language</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getCopyright <em>Copyright</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getManagingEditor <em>Managing Editor</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getWebMaster <em>Web Master</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getPubDate <em>Pub Date</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getLastBuildDate <em>Last Build Date</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getCategory <em>Category</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getGenerator <em>Generator</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getDocs <em>Docs</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getCloud <em>Cloud</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getTtl <em>Ttl</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getRating <em>Rating</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getTextInput <em>Text Input</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getSkipHours <em>Skip Hours</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getSkipDays <em>Skip Days</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getAdminGeneratorAgent <em>Admin Generator Agent</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getRSS <em>RSS</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getImage <em>Image</em>}</li>
 *   <li>{@link razgriz.news.model.rss20.impl.ChannelImpl#getItem <em>Item</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ChannelImpl extends EObjectImpl implements Channel {
    /**
     * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTitle()
     * @generated
     * @ordered
     */
    protected static final String TITLE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getTitle() <em>Title</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTitle()
     * @generated
     * @ordered
     */
    protected String title = TITLE_EDEFAULT;

    /**
     * The default value of the '{@link #getLink() <em>Link</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLink()
     * @generated
     * @ordered
     */
    protected static final String LINK_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLink() <em>Link</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLink()
     * @generated
     * @ordered
     */
    protected String link = LINK_EDEFAULT;

    /**
     * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDescription()
     * @generated
     * @ordered
     */
    protected static final String DESCRIPTION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDescription()
     * @generated
     * @ordered
     */
    protected String description = DESCRIPTION_EDEFAULT;

    /**
     * The default value of the '{@link #getLanguage() <em>Language</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLanguage()
     * @generated
     * @ordered
     */
    protected static final String LANGUAGE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLanguage() <em>Language</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLanguage()
     * @generated
     * @ordered
     */
    protected String language = LANGUAGE_EDEFAULT;

    /**
     * The default value of the '{@link #getCopyright() <em>Copyright</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCopyright()
     * @generated
     * @ordered
     */
    protected static final String COPYRIGHT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getCopyright() <em>Copyright</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCopyright()
     * @generated
     * @ordered
     */
    protected String copyright = COPYRIGHT_EDEFAULT;

    /**
     * The default value of the '{@link #getManagingEditor() <em>Managing Editor</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getManagingEditor()
     * @generated
     * @ordered
     */
    protected static final String MANAGING_EDITOR_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getManagingEditor() <em>Managing Editor</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getManagingEditor()
     * @generated
     * @ordered
     */
    protected String managingEditor = MANAGING_EDITOR_EDEFAULT;

    /**
     * The default value of the '{@link #getWebMaster() <em>Web Master</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getWebMaster()
     * @generated
     * @ordered
     */
    protected static final String WEB_MASTER_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getWebMaster() <em>Web Master</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getWebMaster()
     * @generated
     * @ordered
     */
    protected String webMaster = WEB_MASTER_EDEFAULT;

    /**
     * The default value of the '{@link #getPubDate() <em>Pub Date</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPubDate()
     * @generated
     * @ordered
     */
    protected static final Date PUB_DATE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getPubDate() <em>Pub Date</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPubDate()
     * @generated
     * @ordered
     */
    protected Date pubDate = PUB_DATE_EDEFAULT;

    /**
     * The default value of the '{@link #getLastBuildDate() <em>Last Build Date</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLastBuildDate()
     * @generated
     * @ordered
     */
    protected static final Date LAST_BUILD_DATE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLastBuildDate() <em>Last Build Date</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLastBuildDate()
     * @generated
     * @ordered
     */
    protected Date lastBuildDate = LAST_BUILD_DATE_EDEFAULT;

    /**
     * The default value of the '{@link #getCategory() <em>Category</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCategory()
     * @generated
     * @ordered
     */
    protected static final String CATEGORY_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getCategory() <em>Category</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCategory()
     * @generated
     * @ordered
     */
    protected String category = CATEGORY_EDEFAULT;

    /**
     * The default value of the '{@link #getGenerator() <em>Generator</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getGenerator()
     * @generated
     * @ordered
     */
    protected static final String GENERATOR_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getGenerator() <em>Generator</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getGenerator()
     * @generated
     * @ordered
     */
    protected String generator = GENERATOR_EDEFAULT;

    /**
     * The default value of the '{@link #getDocs() <em>Docs</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDocs()
     * @generated
     * @ordered
     */
    protected static final String DOCS_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDocs() <em>Docs</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDocs()
     * @generated
     * @ordered
     */
    protected String docs = DOCS_EDEFAULT;

    /**
     * The default value of the '{@link #getCloud() <em>Cloud</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCloud()
     * @generated
     * @ordered
     */
    protected static final String CLOUD_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getCloud() <em>Cloud</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCloud()
     * @generated
     * @ordered
     */
    protected String cloud = CLOUD_EDEFAULT;

    /**
     * The default value of the '{@link #getTtl() <em>Ttl</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTtl()
     * @generated
     * @ordered
     */
    protected static final String TTL_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getTtl() <em>Ttl</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTtl()
     * @generated
     * @ordered
     */
    protected String ttl = TTL_EDEFAULT;

    /**
     * The default value of the '{@link #getRating() <em>Rating</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getRating()
     * @generated
     * @ordered
     */
    protected static final String RATING_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getRating() <em>Rating</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getRating()
     * @generated
     * @ordered
     */
    protected String rating = RATING_EDEFAULT;

    /**
     * The default value of the '{@link #getTextInput() <em>Text Input</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTextInput()
     * @generated
     * @ordered
     */
    protected static final String TEXT_INPUT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getTextInput() <em>Text Input</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTextInput()
     * @generated
     * @ordered
     */
    protected String textInput = TEXT_INPUT_EDEFAULT;

    /**
     * The default value of the '{@link #getSkipHours() <em>Skip Hours</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSkipHours()
     * @generated
     * @ordered
     */
    protected static final String SKIP_HOURS_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getSkipHours() <em>Skip Hours</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSkipHours()
     * @generated
     * @ordered
     */
    protected String skipHours = SKIP_HOURS_EDEFAULT;

    /**
     * The default value of the '{@link #getSkipDays() <em>Skip Days</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSkipDays()
     * @generated
     * @ordered
     */
    protected static final String SKIP_DAYS_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getSkipDays() <em>Skip Days</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSkipDays()
     * @generated
     * @ordered
     */
    protected String skipDays = SKIP_DAYS_EDEFAULT;

    /**
     * The default value of the '{@link #getAdminGeneratorAgent() <em>Admin Generator Agent</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAdminGeneratorAgent()
     * @generated
     * @ordered
     */
    protected static final String ADMIN_GENERATOR_AGENT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getAdminGeneratorAgent() <em>Admin Generator Agent</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAdminGeneratorAgent()
     * @generated
     * @ordered
     */
    protected String adminGeneratorAgent = ADMIN_GENERATOR_AGENT_EDEFAULT;

    /**
     * The cached value of the '{@link #getImage() <em>Image</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getImage()
     * @generated
     * @ordered
     */
    protected Image image = null;

    /**
     * The cached value of the '{@link #getItem() <em>Item</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getItem()
     * @generated
     * @ordered
     */
    protected EList item = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ChannelImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return RSS20Package.eINSTANCE.getChannel();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getTitle() {
        return title;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setTitle(String newTitle) {
        String oldTitle = title;
        title = newTitle;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__TITLE, oldTitle, title));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getLink() {
        return link;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLink(String newLink) {
        String oldLink = link;
        link = newLink;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__LINK, oldLink, link));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getDescription() {
        return description;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDescription(String newDescription) {
        String oldDescription = description;
        description = newDescription;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__DESCRIPTION, oldDescription, description));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getLanguage() {
        return language;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLanguage(String newLanguage) {
        String oldLanguage = language;
        language = newLanguage;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__LANGUAGE, oldLanguage, language));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getCopyright() {
        return copyright;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setCopyright(String newCopyright) {
        String oldCopyright = copyright;
        copyright = newCopyright;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__COPYRIGHT, oldCopyright, copyright));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getManagingEditor() {
        return managingEditor;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setManagingEditor(String newManagingEditor) {
        String oldManagingEditor = managingEditor;
        managingEditor = newManagingEditor;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__MANAGING_EDITOR, oldManagingEditor, managingEditor));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getWebMaster() {
        return webMaster;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setWebMaster(String newWebMaster) {
        String oldWebMaster = webMaster;
        webMaster = newWebMaster;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__WEB_MASTER, oldWebMaster, webMaster));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Date getPubDate() {
        return pubDate;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setPubDate(Date newPubDate) {
        Date oldPubDate = pubDate;
        pubDate = newPubDate;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__PUB_DATE, oldPubDate, pubDate));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Date getLastBuildDate() {
        return lastBuildDate;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLastBuildDate(Date newLastBuildDate) {
        Date oldLastBuildDate = lastBuildDate;
        lastBuildDate = newLastBuildDate;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__LAST_BUILD_DATE, oldLastBuildDate, lastBuildDate));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getCategory() {
        return category;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setCategory(String newCategory) {
        String oldCategory = category;
        category = newCategory;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__CATEGORY, oldCategory, category));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getGenerator() {
        return generator;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setGenerator(String newGenerator) {
        String oldGenerator = generator;
        generator = newGenerator;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__GENERATOR, oldGenerator, generator));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getDocs() {
        return docs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDocs(String newDocs) {
        String oldDocs = docs;
        docs = newDocs;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__DOCS, oldDocs, docs));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getCloud() {
        return cloud;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setCloud(String newCloud) {
        String oldCloud = cloud;
        cloud = newCloud;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__CLOUD, oldCloud, cloud));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getTtl() {
        return ttl;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setTtl(String newTtl) {
        String oldTtl = ttl;
        ttl = newTtl;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__TTL, oldTtl, ttl));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getRating() {
        return rating;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setRating(String newRating) {
        String oldRating = rating;
        rating = newRating;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__RATING, oldRating, rating));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getTextInput() {
        return textInput;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setTextInput(String newTextInput) {
        String oldTextInput = textInput;
        textInput = newTextInput;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__TEXT_INPUT, oldTextInput, textInput));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getSkipHours() {
        return skipHours;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSkipHours(String newSkipHours) {
        String oldSkipHours = skipHours;
        skipHours = newSkipHours;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__SKIP_HOURS, oldSkipHours, skipHours));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getSkipDays() {
        return skipDays;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSkipDays(String newSkipDays) {
        String oldSkipDays = skipDays;
        skipDays = newSkipDays;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__SKIP_DAYS, oldSkipDays, skipDays));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getAdminGeneratorAgent() {
        return adminGeneratorAgent;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setAdminGeneratorAgent(String newAdminGeneratorAgent) {
        String oldAdminGeneratorAgent = adminGeneratorAgent;
        adminGeneratorAgent = newAdminGeneratorAgent;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__ADMIN_GENERATOR_AGENT, oldAdminGeneratorAgent, adminGeneratorAgent));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public RSS getRSS() {
        if (eContainerFeatureID != RSS20Package.CHANNEL__RSS) return null;
        return (RSS)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setRSS(RSS newRSS) {
        if (newRSS != eContainer || (eContainerFeatureID != RSS20Package.CHANNEL__RSS && newRSS != null)) {
            if (EcoreUtil.isAncestor(this, (EObject)newRSS))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newRSS != null)
                msgs = ((InternalEObject)newRSS).eInverseAdd(this, RSS20Package.RSS__CHANNEL, RSS.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newRSS, RSS20Package.CHANNEL__RSS, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__RSS, newRSS, newRSS));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Image getImage() {
        return image;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetImage(Image newImage, NotificationChain msgs) {
        Image oldImage = image;
        image = newImage;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__IMAGE, oldImage, newImage);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setImage(Image newImage) {
        if (newImage != image) {
            NotificationChain msgs = null;
            if (image != null)
                msgs = ((InternalEObject)image).eInverseRemove(this, RSS20Package.IMAGE__CHANNEL, Image.class, msgs);
            if (newImage != null)
                msgs = ((InternalEObject)newImage).eInverseAdd(this, RSS20Package.IMAGE__CHANNEL, Image.class, msgs);
            msgs = basicSetImage(newImage, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, RSS20Package.CHANNEL__IMAGE, newImage, newImage));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public List getItem() {
        if (item == null) {
            item = new EObjectContainmentWithInverseEList(Item.class, this, RSS20Package.CHANNEL__ITEM, RSS20Package.ITEM__CHANNEL);
        }
        return item;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case RSS20Package.CHANNEL__RSS:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, RSS20Package.CHANNEL__RSS, msgs);
                case RSS20Package.CHANNEL__IMAGE:
                    if (image != null)
                        msgs = ((InternalEObject)image).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RSS20Package.CHANNEL__IMAGE, null, msgs);
                    return basicSetImage((Image)otherEnd, msgs);
                case RSS20Package.CHANNEL__ITEM:
                    return ((InternalEList)getItem()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case RSS20Package.CHANNEL__RSS:
                    return eBasicSetContainer(null, RSS20Package.CHANNEL__RSS, msgs);
                case RSS20Package.CHANNEL__IMAGE:
                    return basicSetImage(null, msgs);
                case RSS20Package.CHANNEL__ITEM:
                    return ((InternalEList)getItem()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case RSS20Package.CHANNEL__RSS:
                    return ((InternalEObject)eContainer).eInverseRemove(this, RSS20Package.RSS__CHANNEL, RSS.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case RSS20Package.CHANNEL__TITLE:
                return getTitle();
            case RSS20Package.CHANNEL__LINK:
                return getLink();
            case RSS20Package.CHANNEL__DESCRIPTION:
                return getDescription();
            case RSS20Package.CHANNEL__LANGUAGE:
                return getLanguage();
            case RSS20Package.CHANNEL__COPYRIGHT:
                return getCopyright();
            case RSS20Package.CHANNEL__MANAGING_EDITOR:
                return getManagingEditor();
            case RSS20Package.CHANNEL__WEB_MASTER:
                return getWebMaster();
            case RSS20Package.CHANNEL__PUB_DATE:
                return getPubDate();
            case RSS20Package.CHANNEL__LAST_BUILD_DATE:
                return getLastBuildDate();
            case RSS20Package.CHANNEL__CATEGORY:
                return getCategory();
            case RSS20Package.CHANNEL__GENERATOR:
                return getGenerator();
            case RSS20Package.CHANNEL__DOCS:
                return getDocs();
            case RSS20Package.CHANNEL__CLOUD:
                return getCloud();
            case RSS20Package.CHANNEL__TTL:
                return getTtl();
            case RSS20Package.CHANNEL__RATING:
                return getRating();
            case RSS20Package.CHANNEL__TEXT_INPUT:
                return getTextInput();
            case RSS20Package.CHANNEL__SKIP_HOURS:
                return getSkipHours();
            case RSS20Package.CHANNEL__SKIP_DAYS:
                return getSkipDays();
            case RSS20Package.CHANNEL__ADMIN_GENERATOR_AGENT:
                return getAdminGeneratorAgent();
            case RSS20Package.CHANNEL__RSS:
                return getRSS();
            case RSS20Package.CHANNEL__IMAGE:
                return getImage();
            case RSS20Package.CHANNEL__ITEM:
                return getItem();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case RSS20Package.CHANNEL__TITLE:
                setTitle((String)newValue);
                return;
            case RSS20Package.CHANNEL__LINK:
                setLink((String)newValue);
                return;
            case RSS20Package.CHANNEL__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case RSS20Package.CHANNEL__LANGUAGE:
                setLanguage((String)newValue);
                return;
            case RSS20Package.CHANNEL__COPYRIGHT:
                setCopyright((String)newValue);
                return;
            case RSS20Package.CHANNEL__MANAGING_EDITOR:
                setManagingEditor((String)newValue);
                return;
            case RSS20Package.CHANNEL__WEB_MASTER:
                setWebMaster((String)newValue);
                return;
            case RSS20Package.CHANNEL__PUB_DATE:
                setPubDate((Date)newValue);
                return;
            case RSS20Package.CHANNEL__LAST_BUILD_DATE:
                setLastBuildDate((Date)newValue);
                return;
            case RSS20Package.CHANNEL__CATEGORY:
                setCategory((String)newValue);
                return;
            case RSS20Package.CHANNEL__GENERATOR:
                setGenerator((String)newValue);
                return;
            case RSS20Package.CHANNEL__DOCS:
                setDocs((String)newValue);
                return;
            case RSS20Package.CHANNEL__CLOUD:
                setCloud((String)newValue);
                return;
            case RSS20Package.CHANNEL__TTL:
                setTtl((String)newValue);
                return;
            case RSS20Package.CHANNEL__RATING:
                setRating((String)newValue);
                return;
            case RSS20Package.CHANNEL__TEXT_INPUT:
                setTextInput((String)newValue);
                return;
            case RSS20Package.CHANNEL__SKIP_HOURS:
                setSkipHours((String)newValue);
                return;
            case RSS20Package.CHANNEL__SKIP_DAYS:
                setSkipDays((String)newValue);
                return;
            case RSS20Package.CHANNEL__ADMIN_GENERATOR_AGENT:
                setAdminGeneratorAgent((String)newValue);
                return;
            case RSS20Package.CHANNEL__RSS:
                setRSS((RSS)newValue);
                return;
            case RSS20Package.CHANNEL__IMAGE:
                setImage((Image)newValue);
                return;
            case RSS20Package.CHANNEL__ITEM:
                getItem().clear();
                getItem().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case RSS20Package.CHANNEL__TITLE:
                setTitle(TITLE_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__LINK:
                setLink(LINK_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__LANGUAGE:
                setLanguage(LANGUAGE_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__COPYRIGHT:
                setCopyright(COPYRIGHT_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__MANAGING_EDITOR:
                setManagingEditor(MANAGING_EDITOR_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__WEB_MASTER:
                setWebMaster(WEB_MASTER_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__PUB_DATE:
                setPubDate(PUB_DATE_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__LAST_BUILD_DATE:
                setLastBuildDate(LAST_BUILD_DATE_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__CATEGORY:
                setCategory(CATEGORY_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__GENERATOR:
                setGenerator(GENERATOR_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__DOCS:
                setDocs(DOCS_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__CLOUD:
                setCloud(CLOUD_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__TTL:
                setTtl(TTL_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__RATING:
                setRating(RATING_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__TEXT_INPUT:
                setTextInput(TEXT_INPUT_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__SKIP_HOURS:
                setSkipHours(SKIP_HOURS_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__SKIP_DAYS:
                setSkipDays(SKIP_DAYS_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__ADMIN_GENERATOR_AGENT:
                setAdminGeneratorAgent(ADMIN_GENERATOR_AGENT_EDEFAULT);
                return;
            case RSS20Package.CHANNEL__RSS:
                setRSS((RSS)null);
                return;
            case RSS20Package.CHANNEL__IMAGE:
                setImage((Image)null);
                return;
            case RSS20Package.CHANNEL__ITEM:
                getItem().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case RSS20Package.CHANNEL__TITLE:
                return TITLE_EDEFAULT == null ? title != null : !TITLE_EDEFAULT.equals(title);
            case RSS20Package.CHANNEL__LINK:
                return LINK_EDEFAULT == null ? link != null : !LINK_EDEFAULT.equals(link);
            case RSS20Package.CHANNEL__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case RSS20Package.CHANNEL__LANGUAGE:
                return LANGUAGE_EDEFAULT == null ? language != null : !LANGUAGE_EDEFAULT.equals(language);
            case RSS20Package.CHANNEL__COPYRIGHT:
                return COPYRIGHT_EDEFAULT == null ? copyright != null : !COPYRIGHT_EDEFAULT.equals(copyright);
            case RSS20Package.CHANNEL__MANAGING_EDITOR:
                return MANAGING_EDITOR_EDEFAULT == null ? managingEditor != null : !MANAGING_EDITOR_EDEFAULT.equals(managingEditor);
            case RSS20Package.CHANNEL__WEB_MASTER:
                return WEB_MASTER_EDEFAULT == null ? webMaster != null : !WEB_MASTER_EDEFAULT.equals(webMaster);
            case RSS20Package.CHANNEL__PUB_DATE:
                return PUB_DATE_EDEFAULT == null ? pubDate != null : !PUB_DATE_EDEFAULT.equals(pubDate);
            case RSS20Package.CHANNEL__LAST_BUILD_DATE:
                return LAST_BUILD_DATE_EDEFAULT == null ? lastBuildDate != null : !LAST_BUILD_DATE_EDEFAULT.equals(lastBuildDate);
            case RSS20Package.CHANNEL__CATEGORY:
                return CATEGORY_EDEFAULT == null ? category != null : !CATEGORY_EDEFAULT.equals(category);
            case RSS20Package.CHANNEL__GENERATOR:
                return GENERATOR_EDEFAULT == null ? generator != null : !GENERATOR_EDEFAULT.equals(generator);
            case RSS20Package.CHANNEL__DOCS:
                return DOCS_EDEFAULT == null ? docs != null : !DOCS_EDEFAULT.equals(docs);
            case RSS20Package.CHANNEL__CLOUD:
                return CLOUD_EDEFAULT == null ? cloud != null : !CLOUD_EDEFAULT.equals(cloud);
            case RSS20Package.CHANNEL__TTL:
                return TTL_EDEFAULT == null ? ttl != null : !TTL_EDEFAULT.equals(ttl);
            case RSS20Package.CHANNEL__RATING:
                return RATING_EDEFAULT == null ? rating != null : !RATING_EDEFAULT.equals(rating);
            case RSS20Package.CHANNEL__TEXT_INPUT:
                return TEXT_INPUT_EDEFAULT == null ? textInput != null : !TEXT_INPUT_EDEFAULT.equals(textInput);
            case RSS20Package.CHANNEL__SKIP_HOURS:
                return SKIP_HOURS_EDEFAULT == null ? skipHours != null : !SKIP_HOURS_EDEFAULT.equals(skipHours);
            case RSS20Package.CHANNEL__SKIP_DAYS:
                return SKIP_DAYS_EDEFAULT == null ? skipDays != null : !SKIP_DAYS_EDEFAULT.equals(skipDays);
            case RSS20Package.CHANNEL__ADMIN_GENERATOR_AGENT:
                return ADMIN_GENERATOR_AGENT_EDEFAULT == null ? adminGeneratorAgent != null : !ADMIN_GENERATOR_AGENT_EDEFAULT.equals(adminGeneratorAgent);
            case RSS20Package.CHANNEL__RSS:
                return getRSS() != null;
            case RSS20Package.CHANNEL__IMAGE:
                return image != null;
            case RSS20Package.CHANNEL__ITEM:
                return item != null && !item.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (title: ");
        result.append(title);
        result.append(", link: ");
        result.append(link);
        result.append(", description: ");
        result.append(description);
        result.append(", language: ");
        result.append(language);
        result.append(", copyright: ");
        result.append(copyright);
        result.append(", managingEditor: ");
        result.append(managingEditor);
        result.append(", webMaster: ");
        result.append(webMaster);
        result.append(", pubDate: ");
        result.append(pubDate);
        result.append(", lastBuildDate: ");
        result.append(lastBuildDate);
        result.append(", category: ");
        result.append(category);
        result.append(", generator: ");
        result.append(generator);
        result.append(", docs: ");
        result.append(docs);
        result.append(", cloud: ");
        result.append(cloud);
        result.append(", ttl: ");
        result.append(ttl);
        result.append(", rating: ");
        result.append(rating);
        result.append(", textInput: ");
        result.append(textInput);
        result.append(", skipHours: ");
        result.append(skipHours);
        result.append(", skipDays: ");
        result.append(skipDays);
        result.append(", adminGeneratorAgent: ");
        result.append(adminGeneratorAgent);
        result.append(')');
        return result.toString();
    }

} //ChannelImpl
