/*
 * Created on 2005/01/21
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.model.rss20.clipper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

import razgriz.common.text.XMLFirstElementPicker;
import razgriz.common.text.XMLFirstElementPicker.XMLElement;
import razgriz.news.clipper.NewsClipper;
import razgriz.news.model.Article;
import razgriz.news.model.News;
import razgriz.news.model.NewsFactory;
import razgriz.news.model.rss20.Channel;
import razgriz.news.model.rss20.Item;
import razgriz.news.model.rss20.RSS;
import razgriz.news.model.rss20.util.DefaultRSS20ResourceFactoryImpl;

/**
 * 
 */
public class RSS20NewsClipper implements NewsClipper {

    public RSS20NewsClipper() {
    }

    public boolean canClip(InputStream in) {
        XMLFirstElementPicker picker = new XMLFirstElementPicker();
        XMLElement elem = picker.pick(in);
        return "rss".equals(elem.getQName());
    }

    public News clip(InputStream in) {
        URI uri = URI.createURI("razgriz://stream");

        try {
            Resource res =
                new DefaultRSS20ResourceFactoryImpl().createResource(uri);

            res.load(in, null);
            if (res.getContents().isEmpty()) {
                throw new IllegalArgumentException(
                    "Document root element not found"
                );
            }
            RSS rss = (RSS) res.getContents().get(0);

            return convert(rss);
        } catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage()); // todo:
        }
    }

    public News convert(RSS rss) {
        NewsFactory fact = NewsFactory.eINSTANCE;
        News ret = fact.createNews();

        List channels = rss.getChannel();
        
        for (int i = 0, len = channels.size(); i < len; i++) {
            Channel ch = (Channel) rss.getChannel().get(i);

            if (i == 0) {
                ret.setDate(ch.getPubDate());
                ret.setDescription(ch.getDescription());
                ret.setLink(ch.getLink());
                ret.setTitle(ch.getTitle());
            }

            List items = ch.getItem();
            for (int j = 0, jlen = items.size(); j < jlen; j++) {
                Item item = (Item) items.get(j);
                Article article = fact.createArticle();

                article.setAuthor(item.getAuthor());
                article.setDescription(item.getDescription());
                article.setLink(item.getLink());

                Date date = item.getPubDate();
                date = date == null? new Date(): date;
                article.setDate(date);

                article.setTitle(item.getTitle());
                article.setRead(false);

                ret.getArticles().add(article);
            }
        }
 
        return ret;
    }
}
