/*
 * Created on 2005/01/31
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * 
 */
public class NewsDialog extends TitleAreaDialog {
    private String title;
    private String link;
    private String desc;

    private Text titleText;
    private Text linkText;
    private Text descText;

    public NewsDialog(Shell parentShell) {
        super(parentShell);
    }

    public String getTitle() {
        return title;
    }
    public String getLink() {
        return link;
    }
    public String getDescription() {
        return desc;
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        validate();
        return ret;
    }
    protected Control createDialogArea(Composite parent) {
        setTitle("j[X̒ǉ");
        setMessage("j[X̏͂Ă", IMessageProvider.NONE);

        Composite component = (Composite) super.createDialogArea(parent);
        Composite container = new Composite(component, SWT.NONE);
        container.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        container.setLayout(layout);

        Label titleLabel= new Label(container, SWT.NULL);
        titleLabel.setText("^Cg(&T):");
        titleText = new Text(container, SWT.BORDER | SWT.SINGLE);
        titleText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        titleText.addModifyListener(new ModifyListener() {
            public void modifyText(ModifyEvent e) {
                validate();
            }
        });

        Label urlLabel= new Label(container, SWT.NULL);
        urlLabel.setText("URL(&U):");
        linkText = new Text(container, SWT.BORDER | SWT.SINGLE);
        linkText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        linkText.addModifyListener(new ModifyListener() {
            public void modifyText(ModifyEvent e) {
                validate();
            }
        });

        Label descLabel= new Label(container, SWT.NULL);
        descLabel.setText("(&D):");
        descText = new Text(container, SWT.BORDER | SWT.SINGLE);
        descText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        descText.addModifyListener(new ModifyListener() {
            public void modifyText(ModifyEvent e) {
                validate();
            }
        });

        return container;
    }

    protected void validate() {
        String errmsg = null;

        if ("".equals(titleText.getText())) {
            errmsg = "^Cg͂Ă";
        } else if ("".equals(linkText.getText())) {
            errmsg = "URL͂Ă";
        }

        setErrorMessage(errmsg);    
        getButton(IDialogConstants.OK_ID).setEnabled(errmsg == null);
    }
    
    protected void okPressed() {
        title = titleText.getText();
        link = linkText.getText();
        desc = descText.getText();

        super.okPressed();
    }
}
