/*
 * Created on 2005/03/06
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

import razgriz.news.model.News;
import razgriz.news.ui.SharedImages;
import razgriz.news.visitor.NewsClippingVisitor;

/**
 * 
 */
public class ClipArticleAction extends Action {
    public static final String ID = ClipArticleAction.class.getName();

    private IWorkbenchSite site;
    private NewsInput input;

    public ClipArticleAction(IWorkbenchSite site, NewsInput input) {
        super();
        this.site = site;
        this.input = input;

        setId(ID);
        setText("VL擾");
        setToolTipText("VL擾܂");
        setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                SharedImages.IMG_ACT_CLIPARTICLE
            )
        );
    }

    public void run() {
        input.getNews().accept(new NewsClippingVisitor());
    }

    public static interface NewsInput {
        public News getNews();
    }
}
