/*
 * Created on 2005/01/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

import razgriz.news.model.FavoriteList;
import razgriz.news.model.Group;
import razgriz.news.model.NewsFactory;
import razgriz.news.ui.NewsUIPlugin;
import razgriz.news.ui.SharedImages;
import razgriz.news.ui.dialogs.BeanEditorDialog;
import razgriz.news.ui.dialogs.GroupDialogBean;

/**
 * 
 */
public class AddRootGroupAction extends Action {
    public static final String ID = AddRootGroupAction.class.getName();

    IWorkbenchSite site;
    TreeViewer viewer;

    public AddRootGroupAction(IWorkbenchSite site, TreeViewer viewer) {
        super();

        this.site = site;
        this.viewer = viewer;

        setId(ID);
        setText("[gO[v̒ǉ");
        setToolTipText("[gO[vǉ܂");
        setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                SharedImages.IMG_ACT_ADDROOTGROUP
            )
        );
    }

    public void run() {
        GroupDialogBean bean = new GroupDialogBean();
        BeanEditorDialog dialog = new BeanEditorDialog(
            site.getShell(),
            "O[v̒ǉ",
            "O[v̏͂Ă",
            bean,
            bean,
            bean,
            null
        );

        if (dialog.open() == InputDialog.OK) {
            Group grp = NewsFactory.eINSTANCE.createGroup();
            grp.setTitle(bean.getTitle());
            FavoriteList favlist = NewsUIPlugin.getFavoriteList();
            favlist.getFavorites().add(grp);
        }
    }
}
