/*
 * Created on 2004/11/26
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.model.rss10.util;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMLHelper;

import razgriz.news.model.rss10.util.RSS10ResourceImpl;

/**
 * 
 */
public class DefaultRSS10ResourceImpl extends RSS10ResourceImpl {
    public DefaultRSS10ResourceImpl(URI uri) {
        super(uri);
    }

    protected XMLHelper createXMLHelper() {
        XMLHelper ret = super.createXMLHelper();

        EMap map = ret.getPrefixToNamespaceMap();
        map.put("", "http://purl.org/rss/1.0/");
        map.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"); 
        map.put("dc", "http://purl.org/dc/elements/1.1/");
        map.put("sy", "http://purl.org/rss/modules/syndication/");
        map.put("content", "http://purl.org/rss/1.0/modules/content/");
        map.put("admin", "http://webns.net/mvcb/");
        map.put("cc", "http://web.resource.org/cc/");

        return ret;
    }
}
