/*
 * Created on 2005/01/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.common.text;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * 
 */
public class DateFormatUtil {
    private DateFormatUtil() {
        
    }

    private static DateFormat[] dateFormats = new DateFormat[] {
        /** RFC 1123 */
        new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH),

        /** ISO 8601 slightly modified */
        new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH),

        /** ISO 8601 slightly modified */
        new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzzz", Locale.ENGLISH),

        /** ISO 8601 slightly modified */
        new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss z", Locale.ENGLISH),

        /** ISO 8601 */
        new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz", Locale.ENGLISH),

        /** ISO 8601 slightly modified */
        new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH),

        /** ISO 8601 slightly modified */
        new SimpleDateFormat("yyyy-MM-dd'T'HHmmss.SSSz", Locale.ENGLISH),

        /** ISO 8601 slightly modified */
        new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH),

        /** Simple Date Format */
        new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH)
    };

    public static Date parse(String datestr) {
        Date result = null;
        datestr = datestr.trim();
        if (datestr.length() > 10) {
            if (
                (
                    datestr.substring(datestr.length() - 5).indexOf("+") == 0 ||
                    datestr.substring(datestr.length() - 5).indexOf("-") == 0
                ) &&
                datestr.substring(datestr.length() - 5).indexOf(":") == 2
            ) {
                String sign = datestr.substring(
                    datestr.length() - 5, datestr.length() - 4
                );
                datestr =
                    datestr.substring(0, datestr.length() - 5) + sign +
                    "0" + datestr.substring(datestr.length() - 4);
            }

            String dateEnd = datestr.substring(datestr.length() - 6);

            if (
                (dateEnd.indexOf("-") == 0 || dateEnd.indexOf("+") == 0) &&
                dateEnd.indexOf(":") == 3
            ) {
                if (
                    !"GMT".equals(datestr.substring(
                        datestr.length() - 9, datestr.length() - 6
                    ))
                ) {
                    String oldDate = datestr;
                    String newEnd = dateEnd.substring(0, 3) + dateEnd.substring(4);
                    datestr = oldDate.substring(0, oldDate.length() - 6) + newEnd;
                }
            }
        }

        for (int i = 0; i < dateFormats.length; i++) {
            try {
                return dateFormats[i].parse(datestr);
            } catch (java.text.ParseException eA) {
            }
        }

        throw new IllegalArgumentException(); // todo:
    }
}
