/*
 * Created on 2005/01/27
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.common.eclipse;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/**
 * 
 */
public class ExtensionUtil {

    private ExtensionUtil() {
    }

    public static void processRegistry(String xpid, IExtensionProcessor processor) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint epoint = reg.getExtensionPoint(xpid);
        IExtension[] extensions = epoint.getExtensions();
        for (int i = 0, len = extensions.length; i < len; i++) {
            IExtension extension = extensions[i];
            IConfigurationElement[] celems =
                extension.getConfigurationElements();

            for (int j = 0; j < celems.length; j++) {
                IConfigurationElement celem = celems[j];
                processor.process(extension, celem);
            }
        }
    }

    public static interface IExtensionProcessor {
        public void process(IExtension extension, IConfigurationElement member);
    }
}
