/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui.views;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import razgriz.news.NewsException;
import razgriz.news.model.News;
import razgriz.news.model.util.ModelVisitor;
import razgriz.news.ui.NewsUIPlugin;
import razgriz.news.ui.actions.AddGroupAction;
import razgriz.news.ui.actions.AddNewsAction;
import razgriz.news.ui.actions.AddRootGroupAction;
import razgriz.news.ui.actions.EditGroupAction;
import razgriz.news.ui.actions.EditNewsAction;
import razgriz.news.ui.actions.RemoveFavoriteAction;
import razgriz.news.ui.views.ArticleListView;
import razgriz.news.ui.views.FavoriteListTreeContentProvider;
import razgriz.news.visitor.NewsClippingVisitor;

public class FavoriteListView
extends ViewPart {
    public static final String ID;
    private Composite parent;
    private TreeViewer viewer;
    private FavoriteListTreeContentProvider provider;
    private Action addGroupAction;
    private Action addRootGroupAction;
    private Action addNewsAction;
    private Action editGroupAction;
    private Action editNewsAction;
    private Action removeFavoriteAction;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("razgriz.news.ui.views.FavoriteListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new FavoriteListTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FavoriteListTreeContentProvider());
        this.viewer.setInput((Object)NewsUIPlugin.getFavoriteList());
        this.makeActions();
        this.contributeToActionBars();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    private ImageDescriptor getSharedImageDescriptor(String descstr) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(descstr);
    }

    private void makeActions() {
        this.addGroupAction = new AddGroupAction((IWorkbenchSite)this.getSite(), this.viewer);
        this.addRootGroupAction = new AddRootGroupAction((IWorkbenchSite)this.getSite(), this.viewer);
        this.addNewsAction = new AddNewsAction((IWorkbenchSite)this.getSite(), this.viewer);
        this.editGroupAction = new EditGroupAction((IWorkbenchSite)this.getSite(), this.viewer);
        this.editNewsAction = new EditNewsAction((IWorkbenchSite)this.getSite(), this.viewer);
        this.removeFavoriteAction = new RemoveFavoriteAction((IWorkbenchSite)this.getSite(), this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FavoriteListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Iterator ite = sel.iterator();
                while (ite.hasNext()) {
                    Object obj = ite.next();
                    if (!(obj instanceof News)) continue;
                    News news = (News)obj;
                    try {
                        news.accept((ModelVisitor)new NewsClippingVisitor());
                        IWorkbenchPage wpage = FavoriteListView.this.getSite().getWorkbenchWindow().getActivePage();
                        ArticleListView view = (ArticleListView)wpage.showView(ArticleListView.ID, ArticleListView.createSecondaryId(news), 1);
                        view.setInput(news);
                    }
                    catch (NewsException e) {
                        MessageDialog.openError((Shell)FavoriteListView.this.getSite().getShell(), (String)"\u8a18\u4e8b\u306e\u66f4\u65b0\u30a8\u30e9\u30fc", (String)("\u8a18\u4e8b\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + e.getMessage()));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e.getMessage());
                    }
                }
            }
        });
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.addRootGroupAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addRootGroupAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addNewsAction);
        manager.add((IAction)this.addRootGroupAction);
        manager.add((IAction)this.addGroupAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.editNewsAction);
        manager.add((IAction)this.editGroupAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.removeFavoriteAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additionsend"));
    }
}

