/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui.views;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import razgriz.news.model.Article;
import razgriz.news.model.News;
import razgriz.news.model.util.NewsSwitch;
import razgriz.news.ui.NewsUIPlugin;
import razgriz.news.ui.actions.ClipArticleAction;
import razgriz.news.ui.browser.NewsBrowser;
import razgriz.news.ui.browser.NewsBrowserInput;

public class ArticleListView
extends ViewPart {
    public static final String ID;
    private static final String KEY_NEWS_URI = "newsUri";
    private static final DateFormat DF_ARTICLE_DATE;
    private News news;
    private TableViewer viewer;
    private Action clipArticleAction;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("razgriz.news.ui.views.ArticleListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
        DF_ARTICLE_DATE = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public ArticleListView getThis() {
        return this;
    }

    public static String createSecondaryId(News news) {
        return news.getLink().replace(':', '!');
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento == null) {
            return;
        }
        Resource res = NewsUIPlugin.getFavoriteList().eResource();
        String uri = memento.getString(KEY_NEWS_URI);
        if (!StringUtils.isEmpty((String)uri)) {
            this.news = (News)res.getEObject(uri);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.news != null) {
            Resource res = NewsUIPlugin.getFavoriteList().eResource();
            memento.putString(KEY_NEWS_URI, res.getURIFragment((EObject)this.news));
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = this.createArticleTable(parent);
        this.makeActions();
        this.contributeToActionBars();
        this.hookDoubleClickAction();
        this.setInput(this.news);
    }

    private TableViewer createArticleTable(Composite parent) {
        TableViewer ret = new TableViewer(parent, 65538);
        ret.setContentProvider((IContentProvider)new ArticleListContentProvider());
        ret.setLabelProvider((IBaseLabelProvider)new ArticleListLabelProvider());
        Table table = ret.getTable();
        table.setFont(JFaceResources.getFont((String)"sysfont.bold"));
        TableColumn nameCol = new TableColumn(table, 16384);
        nameCol.setText(NewsUIPlugin.getResourceString("title.title"));
        TableColumn dateCol = new TableColumn(table, 16384);
        dateCol.setText(NewsUIPlugin.getResourceString("title.date"));
        TableColumn descCol = new TableColumn(table, 16384);
        descCol.setText(NewsUIPlugin.getResourceString("title.description"));
        table.setHeaderVisible(true);
        ret.setSorter((ViewerSorter)new ArticleSorter());
        return ret;
    }

    private void makeActions() {
        this.clipArticleAction = new ClipArticleAction((IWorkbenchSite)this.getSite(), new ClipArticleAction.NewsInput(){

            public News getNews() {
                return ArticleListView.this.news;
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.clipArticleAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.clipArticleAction);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Iterator ite = sel.iterator();
                while (ite.hasNext()) {
                    Object obj = ite.next();
                    if (!(obj instanceof Article)) continue;
                    Article article = (Article)obj;
                    try {
                        article.setRead(true);
                        NewsBrowser editor = (NewsBrowser)NewsUIPlugin.openEditor(new NewsBrowserInput(article), NewsBrowser.ID);
                        editor.activateBrowserPage();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e.getMessage());
                    }
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void updateTableAppearance() {
        Table table = this.viewer.getTable();
        if (this.news != null) {
            TableItem[] items = table.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                Article article = (Article)item.getData();
                String fontsym = article.isRead() ? "sysfont.normal" : "sysfont.bold";
                item.setFont(NewsUIPlugin.getFont(fontsym));
                ++i;
            }
            TableColumn[] cols = table.getColumns();
            int i2 = 0;
            while (i2 < cols.length) {
                cols[i2].pack();
                ++i2;
            }
        }
    }

    public void setInput(News news) {
        this.news = news;
        this.viewer.setInput((Object)news);
        this.setPartName(news == null ? "" : news.getTitle());
        this.updateTableAppearance();
    }

    private class ArticleListContentProvider
    implements IStructuredContentProvider,
    Adapter {
        TableViewer viewer;
        News news;
        Set adaptedSet = new HashSet();

        public void addAdaption(EObject adapted) {
            adapted.eAdapters().add((Object)this);
            this.adaptedSet.add(adapted);
        }

        public void removeAdaption(EObject adapted) {
            this.adaptedSet.remove(adapted);
            adapted.eAdapters().remove((Object)this);
        }

        public void clearAdaption() {
            Iterator ite = this.adaptedSet.iterator();
            while (ite.hasNext()) {
                EObject adapted = (EObject)ite.next();
                adapted.eAdapters().remove((Object)this);
                ite.remove();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = (TableViewer)viewer;
            News newNews = (News)newInput;
            this.clearAdaption();
            if (newNews != null) {
                this.addAdaption((EObject)newNews);
                List newartlist = newNews.getArticles();
                int i = 0;
                while (i < newartlist.size()) {
                    Article article = (Article)newartlist.get(i);
                    this.addAdaption((EObject)article);
                    ++i;
                }
            }
            this.news = newNews;
        }

        public void dispose() {
            this.clearAdaption();
        }

        public Object[] getElements(Object parent) {
            if (parent == null) {
                return new Object[0];
            }
            News n = (News)parent;
            List articlelist = n.getArticles();
            return articlelist.toArray(new Article[articlelist.size()]);
        }

        public void notifyChanged(Notification notification) {
            if (notification.isTouch()) {
                return;
            }
            Object obj = notification.getNotifier();
            ArticleListUpdateSwitch sw = new ArticleListUpdateSwitch(this, notification);
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(this, sw, obj){
                final /* synthetic */ ArticleListContentProvider this$1;
                private final /* synthetic */ NewsSwitch val$sw;
                private final /* synthetic */ Object val$obj;
                {
                    this.this$1 = articleListContentProvider;
                    this.val$sw = newsSwitch;
                    this.val$obj = object;
                }

                public void run() {
                    this.val$sw.doSwitch((EObject)this.val$obj);
                }
            });
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }
    }

    private class ArticleListUpdateSwitch
    extends NewsSwitch {
        private ArticleListContentProvider provider;
        private Notification notification;
        static /* synthetic */ Class class$0;

        public ArticleListUpdateSwitch(ArticleListContentProvider provider, Notification notification) {
            this.provider = provider;
            this.notification = notification;
        }

        public Object caseNews(News news) {
            switch (this.notification.getEventType()) {
                case 3: {
                    EObject eobj = (EObject)this.notification.getNewValue();
                    this.provider.addAdaption(eobj);
                    ArticleListView.this.viewer.refresh();
                    ArticleListView.this.updateTableAppearance();
                    break;
                }
                case 5: {
                    List eobjlist = (List)this.notification.getNewValue();
                    int i = 0;
                    while (i < eobjlist.size()) {
                        EObject eobj = (EObject)eobjlist.get(i);
                        this.provider.addAdaption(eobj);
                        ++i;
                    }
                    ArticleListView.this.viewer.refresh();
                    ArticleListView.this.updateTableAppearance();
                    break;
                }
                case 4: {
                    EObject eobj = (EObject)this.notification.getOldValue();
                    this.provider.removeAdaption(eobj);
                    ArticleListView.this.viewer.refresh();
                    ArticleListView.this.updateTableAppearance();
                    break;
                }
                case 6: {
                    List eobjlist = (List)this.notification.getOldValue();
                    int i = 0;
                    while (i < eobjlist.size()) {
                        EObject eobj = (EObject)eobjlist.get(i);
                        this.provider.removeAdaption(eobj);
                        ++i;
                    }
                    ArticleListView.this.viewer.refresh();
                    ArticleListView.this.updateTableAppearance();
                    break;
                }
                case 1: {
                    int fid;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("razgriz.news.model.News");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((fid = this.notification.getFeatureID((Class)clazz)) == 0) {
                        ArticleListView.this.setPartName(this.notification.getNewStringValue());
                        break;
                    }
                    if (fid != 3 && fid != 2 || this.notification.getNewValue() != null) break;
                    this.provider.clearAdaption();
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.hideView((IViewPart)ArticleListView.this.getThis());
                }
            }
            return news;
        }

        public Object caseArticle(Article article) {
            switch (this.notification.getEventType()) {
                case 1: {
                    ArticleListView.this.updateTableAppearance();
                }
            }
            return article;
        }
    }

    private class ArticleListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArticleListLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Article article = (Article)obj;
            switch (index) {
                case 0: {
                    return StringUtils.defaultString((String)article.getTitle());
                }
                case 1: {
                    Date d = article.getDate();
                    return d == null ? "" : StringUtils.defaultString((String)DF_ARTICLE_DATE.format(d));
                }
                case 2: {
                    return StringUtils.defaultString((String)article.getDescription());
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    private class ArticleSorter
    extends ViewerSorter {
        ArticleSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Article a1 = (Article)e1;
            Article a2 = (Article)e2;
            if (a1.getDate() == null || a2.getDate() == null) {
                return 0;
            }
            return a2.getDate().compareTo(a1.getDate());
        }
    }
}

