/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui;

import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import razgriz.news.NewsPlugin;
import razgriz.news.favlist.FavoriteListService;
import razgriz.news.model.FavoriteList;

public class NewsUIPlugin
extends AbstractUIPlugin {
    public static final String ID;
    private static NewsUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private FavoriteList favoriteList;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("razgriz.news.ui.NewsUIPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
    }

    public NewsUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("razgriz.news.ui.NewsUIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initFontRegistry();
        FavoriteListService service = NewsPlugin.getDefault().getFavoriteListService();
        this.favoriteList = service.load("favoritelist");
        this.refreshProxySet();
    }

    public void stop(BundleContext context) throws Exception {
        FavoriteListService service = NewsPlugin.getDefault().getFavoriteListService();
        service.save("favoritelist");
        super.stop(context);
    }

    public static NewsUIPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = NewsUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void refreshProxySet() {
        IPreferenceStore store = this.getPreferenceStore();
        Properties prop = System.getProperties();
        if (store.getBoolean("proxyUse")) {
            prop.setProperty("proxySet", "true");
            prop.setProperty("proxyHost", store.getString("proxyHost"));
            prop.setProperty("proxyPort", store.getString("proxyPort"));
        } else {
            prop.remove("proxySet");
            prop.remove("proxyHost");
            prop.remove("proxyPort");
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("proxyUse", false);
        store.setDefault("proxyHost", "");
        store.setDefault("proxyPort", "");
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                NewsUIPlugin.this.refreshProxySet();
            }
        });
    }

    protected FontRegistry initFontRegistry() {
        FontRegistry ret = JFaceResources.getFontRegistry();
        Display display = Display.getCurrent();
        Font sysfont = display.getSystemFont();
        FontData[] sysfontdata = sysfont.getFontData();
        ret.put("sysfont.normal", sysfontdata);
        FontData[] sysfontbolddata = sysfont.getFontData();
        int i = 0;
        while (i < sysfontbolddata.length) {
            sysfontbolddata[i].setStyle(1);
            ++i;
        }
        ret.put("sysfont.bold", sysfontbolddata);
        return ret;
    }

    public static FontRegistry getFontRegistry() {
        return JFaceResources.getFontRegistry();
    }

    public static Font getFont(String symbolicName) {
        return JFaceResources.getFont((String)symbolicName);
    }

    public static FavoriteList getFavoriteList() {
        return NewsUIPlugin.getDefault().favoriteList;
    }

    public static IEditorPart openEditor(IEditorInput input, String editorId) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

