/**
 * <copyright>
 * </copyright>
 *
 * $Id: NewsPackage.java,v 1.2 2005/03/02 16:06:51 mkamo Exp $
 */
package razgriz.news.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see razgriz.news.model.NewsFactory
 * @generated
 */
public interface NewsPackage extends EPackage{
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String copyright = "KAMO Masahiko";

    /**
     * The package name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNAME = "model";

    /**
     * The package namespace URI.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_URI = "http:///razgriz/news/model.ecore";

    /**
     * The package namespace name.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    String eNS_PREFIX = "razgriz.news.model";

    /**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    NewsPackage eINSTANCE = razgriz.news.model.impl.NewsPackageImpl.init();

    /**
     * The meta object id for the '{@link razgriz.news.model.impl.ArticleImpl <em>Article</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see razgriz.news.model.impl.ArticleImpl
     * @see razgriz.news.model.impl.NewsPackageImpl#getArticle()
     * @generated
     */
    int ARTICLE = 0;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARTICLE__TITLE = 0;

    /**
     * The feature id for the '<em><b>Link</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARTICLE__LINK = 1;

    /**
     * The feature id for the '<em><b>Description</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARTICLE__DESCRIPTION = 2;

    /**
     * The feature id for the '<em><b>Author</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARTICLE__AUTHOR = 3;

    /**
     * The feature id for the '<em><b>Date</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARTICLE__DATE = 4;

    /**
     * The feature id for the '<em><b>Read</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARTICLE__READ = 5;

    /**
     * The feature id for the '<em><b>News</b></em>' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARTICLE__NEWS = 6;

    /**
     * The number of structural features of the the '<em>Article</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int ARTICLE_FEATURE_COUNT = 7;

    /**
     * The meta object id for the '{@link razgriz.news.model.impl.NewsImpl <em>News</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see razgriz.news.model.impl.NewsImpl
     * @see razgriz.news.model.impl.NewsPackageImpl#getNews()
     * @generated
     */
    int NEWS = 1;

    /**
     * The meta object id for the '{@link razgriz.news.model.impl.FavoriteListImpl <em>Favorite List</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see razgriz.news.model.impl.FavoriteListImpl
     * @see razgriz.news.model.impl.NewsPackageImpl#getFavoriteList()
     * @generated
     */
    int FAVORITE_LIST = 2;

    /**
     * The meta object id for the '{@link razgriz.news.model.Favorite <em>Favorite</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see razgriz.news.model.Favorite
     * @see razgriz.news.model.impl.NewsPackageImpl#getFavorite()
     * @generated
     */
    int FAVORITE = 3;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FAVORITE__TITLE = 0;

    /**
     * The feature id for the '<em><b>Description</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FAVORITE__DESCRIPTION = 1;

    /**
     * The feature id for the '<em><b>Favorite List</b></em>' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FAVORITE__FAVORITE_LIST = 2;

    /**
     * The feature id for the '<em><b>Group</b></em>' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FAVORITE__GROUP = 3;

    /**
     * The number of structural features of the the '<em>Favorite</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FAVORITE_FEATURE_COUNT = 4;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NEWS__TITLE = FAVORITE__TITLE;

    /**
     * The feature id for the '<em><b>Description</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NEWS__DESCRIPTION = FAVORITE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Favorite List</b></em>' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NEWS__FAVORITE_LIST = FAVORITE__FAVORITE_LIST;

    /**
     * The feature id for the '<em><b>Group</b></em>' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NEWS__GROUP = FAVORITE__GROUP;

    /**
     * The feature id for the '<em><b>Link</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NEWS__LINK = FAVORITE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Date</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NEWS__DATE = FAVORITE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Articles</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NEWS__ARTICLES = FAVORITE_FEATURE_COUNT + 2;

    /**
     * The number of structural features of the the '<em>News</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int NEWS_FEATURE_COUNT = FAVORITE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Favorites</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FAVORITE_LIST__FAVORITES = 0;

    /**
     * The number of structural features of the the '<em>Favorite List</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int FAVORITE_LIST_FEATURE_COUNT = 1;

    /**
     * The meta object id for the '{@link razgriz.news.model.impl.GroupImpl <em>Group</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see razgriz.news.model.impl.GroupImpl
     * @see razgriz.news.model.impl.NewsPackageImpl#getGroup()
     * @generated
     */
    int GROUP = 4;

    /**
     * The feature id for the '<em><b>Title</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GROUP__TITLE = FAVORITE__TITLE;

    /**
     * The feature id for the '<em><b>Description</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GROUP__DESCRIPTION = FAVORITE__DESCRIPTION;

    /**
     * The feature id for the '<em><b>Favorite List</b></em>' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GROUP__FAVORITE_LIST = FAVORITE__FAVORITE_LIST;

    /**
     * The feature id for the '<em><b>Group</b></em>' container reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GROUP__GROUP = FAVORITE__GROUP;

    /**
     * The feature id for the '<em><b>Members</b></em>' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GROUP__MEMBERS = FAVORITE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Group</em>' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    int GROUP_FEATURE_COUNT = FAVORITE_FEATURE_COUNT + 1;

    /**
     * Returns the meta object for class '{@link razgriz.news.model.Article <em>Article</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Article</em>'.
     * @see razgriz.news.model.Article
     * @generated
     */
    EClass getArticle();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.Article#getTitle <em>Title</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Title</em>'.
     * @see razgriz.news.model.Article#getTitle()
     * @see #getArticle()
     * @generated
     */
    EAttribute getArticle_Title();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.Article#getLink <em>Link</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Link</em>'.
     * @see razgriz.news.model.Article#getLink()
     * @see #getArticle()
     * @generated
     */
    EAttribute getArticle_Link();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.Article#getDescription <em>Description</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Description</em>'.
     * @see razgriz.news.model.Article#getDescription()
     * @see #getArticle()
     * @generated
     */
    EAttribute getArticle_Description();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.Article#getAuthor <em>Author</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Author</em>'.
     * @see razgriz.news.model.Article#getAuthor()
     * @see #getArticle()
     * @generated
     */
    EAttribute getArticle_Author();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.Article#getDate <em>Date</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Date</em>'.
     * @see razgriz.news.model.Article#getDate()
     * @see #getArticle()
     * @generated
     */
    EAttribute getArticle_Date();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.Article#isRead <em>Read</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Read</em>'.
     * @see razgriz.news.model.Article#isRead()
     * @see #getArticle()
     * @generated
     */
    EAttribute getArticle_Read();

    /**
     * Returns the meta object for the container reference '{@link razgriz.news.model.Article#getNews <em>News</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>News</em>'.
     * @see razgriz.news.model.Article#getNews()
     * @see #getArticle()
     * @generated
     */
    EReference getArticle_News();

    /**
     * Returns the meta object for class '{@link razgriz.news.model.News <em>News</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>News</em>'.
     * @see razgriz.news.model.News
     * @generated
     */
    EClass getNews();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.News#getLink <em>Link</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Link</em>'.
     * @see razgriz.news.model.News#getLink()
     * @see #getNews()
     * @generated
     */
    EAttribute getNews_Link();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.News#getDate <em>Date</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Date</em>'.
     * @see razgriz.news.model.News#getDate()
     * @see #getNews()
     * @generated
     */
    EAttribute getNews_Date();

    /**
     * Returns the meta object for the containment reference list '{@link razgriz.news.model.News#getArticles <em>Articles</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Articles</em>'.
     * @see razgriz.news.model.News#getArticles()
     * @see #getNews()
     * @generated
     */
    EReference getNews_Articles();

    /**
     * Returns the meta object for class '{@link razgriz.news.model.FavoriteList <em>Favorite List</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Favorite List</em>'.
     * @see razgriz.news.model.FavoriteList
     * @generated
     */
    EClass getFavoriteList();

    /**
     * Returns the meta object for the containment reference list '{@link razgriz.news.model.FavoriteList#getFavorites <em>Favorites</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Favorites</em>'.
     * @see razgriz.news.model.FavoriteList#getFavorites()
     * @see #getFavoriteList()
     * @generated
     */
    EReference getFavoriteList_Favorites();

    /**
     * Returns the meta object for class '{@link razgriz.news.model.Favorite <em>Favorite</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Favorite</em>'.
     * @see razgriz.news.model.Favorite
     * @generated
     */
    EClass getFavorite();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.Favorite#getTitle <em>Title</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Title</em>'.
     * @see razgriz.news.model.Favorite#getTitle()
     * @see #getFavorite()
     * @generated
     */
    EAttribute getFavorite_Title();

    /**
     * Returns the meta object for the attribute '{@link razgriz.news.model.Favorite#getDescription <em>Description</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Description</em>'.
     * @see razgriz.news.model.Favorite#getDescription()
     * @see #getFavorite()
     * @generated
     */
    EAttribute getFavorite_Description();

    /**
     * Returns the meta object for the container reference '{@link razgriz.news.model.Favorite#getFavoriteList <em>Favorite List</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Favorite List</em>'.
     * @see razgriz.news.model.Favorite#getFavoriteList()
     * @see #getFavorite()
     * @generated
     */
    EReference getFavorite_FavoriteList();

    /**
     * Returns the meta object for the container reference '{@link razgriz.news.model.Favorite#getGroup <em>Group</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Group</em>'.
     * @see razgriz.news.model.Favorite#getGroup()
     * @see #getFavorite()
     * @generated
     */
    EReference getFavorite_Group();

    /**
     * Returns the meta object for class '{@link razgriz.news.model.Group <em>Group</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for class '<em>Group</em>'.
     * @see razgriz.news.model.Group
     * @generated
     */
    EClass getGroup();

    /**
     * Returns the meta object for the containment reference list '{@link razgriz.news.model.Group#getMembers <em>Members</em>}'.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Members</em>'.
     * @see razgriz.news.model.Group#getMembers()
     * @see #getGroup()
     * @generated
     */
    EReference getGroup_Members();

    /**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
    NewsFactory getNewsFactory();

} //NewsPackage
