package razgriz.news.ui.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import razgriz.news.ui.NewsUI;
import razgriz.news.ui.NewsUIPlugin;

public class ProxyPreferencePage
    extends FieldEditorPreferencePage
    implements IWorkbenchPreferencePage {
    
    public static final String ID = ProxyPreferencePage.class.getName();

    private BooleanFieldEditor proxyUseField;
    private StringFieldEditor proxyHostField;
    private StringFieldEditor proxyPortField;
    
    public ProxyPreferencePage() {
        super(GRID);
        setPreferenceStore(NewsUIPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    private void coordinateFieldsEnabled() {
        proxyHostField.setEnabled(
            proxyUseField.getBooleanValue(), getFieldEditorParent()
        );
        proxyPortField.setEnabled(
            proxyUseField.getBooleanValue(), getFieldEditorParent()
        );
    }

    
    protected void createFieldEditors() {
        proxyUseField = new BooleanFieldEditor(
            NewsUI.PREF_PROXY_USE, "vLVT[ogp(&U):", getFieldEditorParent()
        );
        proxyHostField = new StringFieldEditor(
            NewsUI.PREF_PROXY_HOST, "vLVT[ozXg(&H):", getFieldEditorParent()
        );
        proxyPortField = new StringFieldEditor(
            NewsUI.PREF_PROXY_PORT, "vLVT[o|[g(&P):", getFieldEditorParent()
        );

        addField(proxyUseField);
        addField(proxyHostField);
        addField(proxyPortField);
    }

    protected void initialize() {
        super.initialize();
        coordinateFieldsEnabled();
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        coordinateFieldsEnabled();
    }
}