/*
 * Created on 2005/03/06
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchSite;

import razgriz.news.model.Favorite;
import razgriz.news.model.FavoriteList;
import razgriz.news.model.Group;
import razgriz.news.model.ModelElement;
import razgriz.news.model.News;
import razgriz.news.model.util.ModelVisitor;
import razgriz.news.model.util.NewsSwitch;

/**
 * 
 */
public class RemoveFavoriteAction extends Action {
    public static final String ID = RemoveFavoriteAction.class.getName();

    IWorkbenchSite site;
    TreeViewer viewer;

    public RemoveFavoriteAction(
        IWorkbenchSite site, TreeViewer viewer
    ) {
        super();

        this.site = site;
        this.viewer = viewer;

        setId(ID);
        setText("Cɓ̍폜");
        setToolTipText("Cɓ폜܂");
        setImageDescriptor(null);
    }

    public void run() {
        IStructuredSelection sel = (IStructuredSelection) viewer.getSelection();

        for (Iterator ite = sel.iterator(); ite.hasNext(); ) {
            Object obj = ite.next();
            if (!(obj instanceof Favorite)) {
                continue;
            }
            if (obj instanceof Group) {
                Group grp = (Group) obj;
                NewsCollectingVisitor visitor = new NewsCollectingVisitor();
                grp.accept(visitor);
                News[] newses = visitor.getResult();
                for (int i = 0; i < newses.length; i++) {
                    News news = newses[i];
                    if (news.eContainer() != null) {
                        new RemoveFromContainerSwitch(news).doSwitch(
                            news.eContainer()
                        );
                    }
                }
                if (grp.eContainer() != null) {
                    new RemoveFromContainerSwitch(grp).doSwitch(
                        grp.eContainer()
                    );
                }
            } else if (obj instanceof News) {
                News news = (News) obj;
                if (news.eContainer() != null) {
                    new RemoveFromContainerSwitch(news).doSwitch(
                        news.eContainer()
                    );
                }
            }
        }
    }

    private class NewsCollectingVisitor extends ModelVisitor {
        private List newsList;
        public NewsCollectingVisitor() {
            newsList = new ArrayList();
        }
        public Object caseNews(News news) {
            newsList.add(news);
            return news;
        }
        public boolean prune(ModelElement elem) {
            return (elem instanceof News);
        }
        public News[] getResult() {
            return (News[]) newsList.toArray(new News[newsList.size()]);
        }
    }

    private class RemoveFromContainerSwitch extends NewsSwitch {
        private Favorite removed;
        public RemoveFromContainerSwitch(Favorite removed) {
            this.removed = removed;
        }

        public Object caseFavoriteList(FavoriteList favlist) {
            favlist.getFavorites().remove(removed);
            return favlist;
        }
        public Object caseGroup(Group group) {
            group.getMembers().remove(removed);
            return group;
        }
    }
}
