/*
 * Created on 2005/01/21
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.clipper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.CopyUtils;

import razgriz.news.NewsException;
import razgriz.news.model.News;

/**
 * 
 */
public class NewsClipperService {
    private List idToClipperList;
    
    public NewsClipperService() {
        idToClipperList = new ArrayList();
    }

    public News clip(InputStream in) {
        try {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            try {
                CopyUtils.copy(in, baout);
            } finally {
                baout.close();
            }

            ByteArrayInputStream bain =
                new ByteArrayInputStream(baout.toByteArray());
            try {
                NewsClipper clipper = getSuitableClipper(bain);
                bain.reset();
                return clipper.clip(bain);
            } finally {
                bain.close();
            }
        } catch (IOException e) {
            throw new NewsException(e);  // todo:
        }
    }

    public synchronized void registerClipper(String id, NewsClipper clipper) {
        idToClipperList.add(new IdToClipperListEntry(id, clipper));
    }

    public synchronized NewsClipper getClipper(String clipperId) {
        IdToClipperListEntry entry = null;
        for (
            int i = 0, len = idToClipperList.size(); i < len; i++
        ) {
            entry = (IdToClipperListEntry) idToClipperList.get(i);
            if (entry.getId().equals(clipperId)) {
                return entry.getClipper();
            }
        }

        throw new NewsException("Unknown clipperId: clipperId=" + clipperId);
    }
    
    protected synchronized NewsClipper getSuitableClipper(InputStream in) {
        try {
            IdToClipperListEntry entry = null;
            NewsClipper clipper = null;
            for (
                int i = 0, len = idToClipperList.size(); i < len; i++
            ) {
                in.reset();
                entry = (IdToClipperListEntry) idToClipperList.get(i);
                clipper = entry.getClipper();
                if (clipper.canClip(in)) {
                    return clipper;
                }
            }
            throw new NewsException("Unsupported input");
        } catch(IOException e) {
            throw new NewsException(e);
        }
    }

    private static class IdToClipperListEntry {
        private String id;
        private NewsClipper clipper;
        
        public IdToClipperListEntry(String id, NewsClipper clipper) {
            this.id = id;
            this.clipper = clipper;
        }
        
        public String getId() {
            return id;
        }
        public NewsClipper getClipper() {
            return clipper;
        }
    }
}
