/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.activities.ActivityEvent;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.CategoryEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityRequirementBinding;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.internal.activities.AbstractActivityManager;
import org.eclipse.ui.internal.activities.Activity;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBinding;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRegistryEvent;
import org.eclipse.ui.internal.activities.ActivityRequirementBinding;
import org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition;
import org.eclipse.ui.internal.activities.Category;
import org.eclipse.ui.internal.activities.CategoryActivityBinding;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.activities.ExtensionActivityRegistry;
import org.eclipse.ui.internal.activities.IActivityRegistry;
import org.eclipse.ui.internal.activities.IActivityRegistryListener;
import org.eclipse.ui.internal.activities.Identifier;
import org.eclipse.ui.internal.util.Util;

public final class MutableActivityManager
extends AbstractActivityManager
implements IMutableActivityManager {
    private Map activitiesById = new WeakHashMap();
    private Map activityRequirementBindingsByActivityId = new HashMap();
    private Map activityDefinitionsById = new HashMap();
    private Map activityPatternBindingsByActivityId = new HashMap();
    private IActivityRegistry activityRegistry;
    private Map categoriesById = new WeakHashMap();
    private Map categoryActivityBindingsByCategoryId = new HashMap();
    private Map categoryDefinitionsById = new HashMap();
    private Set definedActivityIds = new HashSet();
    private Set definedCategoryIds = new HashSet();
    private Set enabledActivityIds = new HashSet();
    private Map identifiersById = new WeakHashMap();
    static /* synthetic */ Class class$0;

    public MutableActivityManager() {
        this(new ExtensionActivityRegistry(Platform.getExtensionRegistry()));
    }

    public MutableActivityManager(IActivityRegistry activityRegistry) {
        if (activityRegistry == null) {
            throw new NullPointerException();
        }
        this.activityRegistry = activityRegistry;
        this.activityRegistry.addActivityRegistryListener(new IActivityRegistryListener(){

            public void activityRegistryChanged(ActivityRegistryEvent activityRegistryEvent) {
                MutableActivityManager.this.readRegistry(false);
            }
        });
        this.readRegistry(true);
    }

    public IActivity getActivity(String activityId) {
        if (activityId == null) {
            throw new NullPointerException();
        }
        Activity activity = (Activity)this.activitiesById.get(activityId);
        if (activity == null) {
            activity = new Activity(activityId);
            this.updateActivity(activity);
            this.activitiesById.put(activityId, activity);
        }
        return activity;
    }

    public ICategory getCategory(String categoryId) {
        if (categoryId == null) {
            throw new NullPointerException();
        }
        Category category = (Category)this.categoriesById.get(categoryId);
        if (category == null) {
            category = new Category(categoryId);
            this.updateCategory(category);
            this.categoriesById.put(categoryId, category);
        }
        return category;
    }

    public Set getDefinedActivityIds() {
        return Collections.unmodifiableSet(this.definedActivityIds);
    }

    public Set getDefinedCategoryIds() {
        return Collections.unmodifiableSet(this.definedCategoryIds);
    }

    public Set getEnabledActivityIds() {
        return Collections.unmodifiableSet(this.enabledActivityIds);
    }

    public IIdentifier getIdentifier(String identifierId) {
        if (identifierId == null) {
            throw new NullPointerException();
        }
        Identifier identifier = (Identifier)this.identifiersById.get(identifierId);
        if (identifier == null) {
            identifier = new Identifier(identifierId);
            this.updateIdentifier(identifier);
            this.identifiersById.put(identifierId, identifier);
        }
        return identifier;
    }

    private void getRequiredActivityIds(Set activityIds, Set requiredActivityIds) {
        Iterator iterator = activityIds.iterator();
        while (iterator.hasNext()) {
            String activityId = (String)iterator.next();
            IActivity activity = this.getActivity(activityId);
            HashSet<String> childActivityIds = new HashSet<String>();
            Set activityRequirementBindings = activity.getActivityRequirementBindings();
            Iterator iterator2 = activityRequirementBindings.iterator();
            while (iterator2.hasNext()) {
                IActivityRequirementBinding activityRequirementBinding = (IActivityRequirementBinding)iterator2.next();
                childActivityIds.add(activityRequirementBinding.getRequiredActivityId());
            }
            childActivityIds.removeAll(requiredActivityIds);
            requiredActivityIds.addAll(childActivityIds);
            this.getRequiredActivityIds(childActivityIds, requiredActivityIds);
        }
    }

    private boolean isMatch(String string, Set activityIds) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        activityIds = Util.safeCopy(activityIds, (Class)clazz);
        Iterator iterator = activityIds.iterator();
        while (iterator.hasNext()) {
            String activityId = (String)iterator.next();
            Activity activity = (Activity)this.getActivity(activityId);
            if (!activity.isMatch(string)) continue;
            return true;
        }
        return false;
    }

    private void notifyActivities(Map activityEventsByActivityId) {
        Iterator iterator = activityEventsByActivityId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String activityId = (String)entry.getKey();
            ActivityEvent activityEvent = (ActivityEvent)entry.getValue();
            Activity activity = (Activity)this.activitiesById.get(activityId);
            if (activity == null) continue;
            activity.fireActivityChanged(activityEvent);
        }
    }

    private void notifyCategories(Map categoryEventsByCategoryId) {
        Iterator iterator = categoryEventsByCategoryId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String categoryId = (String)entry.getKey();
            CategoryEvent categoryEvent = (CategoryEvent)entry.getValue();
            Category category = (Category)this.categoriesById.get(categoryId);
            if (category == null) continue;
            category.fireCategoryChanged(categoryEvent);
        }
    }

    private void notifyIdentifiers(Map identifierEventsByIdentifierId) {
        Iterator iterator = identifierEventsByIdentifierId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String identifierId = (String)entry.getKey();
            IdentifierEvent identifierEvent = (IdentifierEvent)entry.getValue();
            Identifier identifier = (Identifier)this.identifiersById.get(identifierId);
            if (identifier == null) continue;
            identifier.fireIdentifierChanged(identifierEvent);
        }
    }

    private void readRegistry(boolean setDefaults) {
        ArrayList activityDefinitions = new ArrayList();
        activityDefinitions.addAll(this.activityRegistry.getActivityDefinitions());
        HashMap activityDefinitionsById = new HashMap(ActivityDefinition.activityDefinitionsById(activityDefinitions, false));
        Iterator iterator = activityDefinitionsById.values().iterator();
        while (iterator.hasNext()) {
            ActivityDefinition activityDefinition = (ActivityDefinition)iterator.next();
            String name = activityDefinition.getName();
            if (name != null && name.length() != 0) continue;
            iterator.remove();
        }
        ArrayList categoryDefinitions = new ArrayList();
        categoryDefinitions.addAll(this.activityRegistry.getCategoryDefinitions());
        HashMap categoryDefinitionsById = new HashMap(CategoryDefinition.categoryDefinitionsById(categoryDefinitions, false));
        Iterator iterator2 = categoryDefinitionsById.values().iterator();
        while (iterator2.hasNext()) {
            CategoryDefinition categoryDefinition = (CategoryDefinition)iterator2.next();
            String name = categoryDefinition.getName();
            if (name != null && name.length() != 0) continue;
            iterator2.remove();
        }
        Map activityRequirementBindingDefinitionsByActivityId = ActivityRequirementBindingDefinition.activityRequirementBindingDefinitionsByActivityId(this.activityRegistry.getActivityRequirementBindingDefinitions());
        HashMap<String, HashSet<ActivityRequirementBinding>> activityRequirementBindingsByActivityId = new HashMap<String, HashSet<ActivityRequirementBinding>>();
        Iterator iterator3 = activityRequirementBindingDefinitionsByActivityId.entrySet().iterator();
        while (iterator3.hasNext()) {
            Collection activityRequirementBindingDefinitions;
            Map.Entry entry = iterator3.next();
            String parentActivityId = (String)entry.getKey();
            if (!activityDefinitionsById.containsKey(parentActivityId) || (activityRequirementBindingDefinitions = (Collection)entry.getValue()) == null) continue;
            Iterator iterator22 = activityRequirementBindingDefinitions.iterator();
            while (iterator22.hasNext()) {
                ActivityRequirementBindingDefinition activityRequirementBindingDefinition = (ActivityRequirementBindingDefinition)iterator22.next();
                String childActivityId = activityRequirementBindingDefinition.getRequiredActivityId();
                if (!activityDefinitionsById.containsKey(childActivityId)) continue;
                ActivityRequirementBinding activityRequirementBinding = new ActivityRequirementBinding(childActivityId, parentActivityId);
                HashSet<ActivityRequirementBinding> activityRequirementBindings = (HashSet<ActivityRequirementBinding>)activityRequirementBindingsByActivityId.get(parentActivityId);
                if (activityRequirementBindings == null) {
                    activityRequirementBindings = new HashSet<ActivityRequirementBinding>();
                    activityRequirementBindingsByActivityId.put(parentActivityId, activityRequirementBindings);
                }
                activityRequirementBindings.add(activityRequirementBinding);
            }
        }
        Map activityPatternBindingDefinitionsByActivityId = ActivityPatternBindingDefinition.activityPatternBindingDefinitionsByActivityId(this.activityRegistry.getActivityPatternBindingDefinitions());
        HashMap<String, HashSet<ActivityPatternBinding>> activityPatternBindingsByActivityId = new HashMap<String, HashSet<ActivityPatternBinding>>();
        Iterator iterator4 = activityPatternBindingDefinitionsByActivityId.entrySet().iterator();
        while (iterator4.hasNext()) {
            Collection activityPatternBindingDefinitions;
            Map.Entry entry = iterator4.next();
            String activityId = (String)entry.getKey();
            if (!activityDefinitionsById.containsKey(activityId) || (activityPatternBindingDefinitions = (Collection)entry.getValue()) == null) continue;
            Iterator iterator23 = activityPatternBindingDefinitions.iterator();
            while (iterator23.hasNext()) {
                ActivityPatternBindingDefinition activityPatternBindingDefinition = (ActivityPatternBindingDefinition)iterator23.next();
                String pattern = activityPatternBindingDefinition.getPattern();
                if (pattern == null || pattern.length() == 0) continue;
                ActivityPatternBinding activityPatternBinding = new ActivityPatternBinding(activityId, Pattern.compile(pattern));
                HashSet<ActivityPatternBinding> activityPatternBindings = (HashSet<ActivityPatternBinding>)activityPatternBindingsByActivityId.get(activityId);
                if (activityPatternBindings == null) {
                    activityPatternBindings = new HashSet<ActivityPatternBinding>();
                    activityPatternBindingsByActivityId.put(activityId, activityPatternBindings);
                }
                activityPatternBindings.add(activityPatternBinding);
            }
        }
        Map categoryActivityBindingDefinitionsByCategoryId = CategoryActivityBindingDefinition.categoryActivityBindingDefinitionsByCategoryId(this.activityRegistry.getCategoryActivityBindingDefinitions());
        HashMap<String, HashSet<CategoryActivityBinding>> categoryActivityBindingsByCategoryId = new HashMap<String, HashSet<CategoryActivityBinding>>();
        Iterator iterator5 = categoryActivityBindingDefinitionsByCategoryId.entrySet().iterator();
        while (iterator5.hasNext()) {
            Collection categoryActivityBindingDefinitions;
            Map.Entry entry = iterator5.next();
            String categoryId = (String)entry.getKey();
            if (!categoryDefinitionsById.containsKey(categoryId) || (categoryActivityBindingDefinitions = (Collection)entry.getValue()) == null) continue;
            Iterator iterator24 = categoryActivityBindingDefinitions.iterator();
            while (iterator24.hasNext()) {
                CategoryActivityBindingDefinition categoryActivityBindingDefinition = (CategoryActivityBindingDefinition)iterator24.next();
                String activityId = categoryActivityBindingDefinition.getActivityId();
                if (!activityDefinitionsById.containsKey(activityId)) continue;
                CategoryActivityBinding categoryActivityBinding = new CategoryActivityBinding(activityId, categoryId);
                HashSet<CategoryActivityBinding> categoryActivityBindings = (HashSet<CategoryActivityBinding>)categoryActivityBindingsByCategoryId.get(categoryId);
                if (categoryActivityBindings == null) {
                    categoryActivityBindings = new HashSet<CategoryActivityBinding>();
                    categoryActivityBindingsByCategoryId.put(categoryId, categoryActivityBindings);
                }
                categoryActivityBindings.add(categoryActivityBinding);
            }
        }
        this.activityRequirementBindingsByActivityId = activityRequirementBindingsByActivityId;
        this.activityDefinitionsById = activityDefinitionsById;
        this.activityPatternBindingsByActivityId = activityPatternBindingsByActivityId;
        this.categoryActivityBindingsByCategoryId = categoryActivityBindingsByCategoryId;
        this.categoryDefinitionsById = categoryDefinitionsById;
        boolean definedActivityIdsChanged = false;
        HashSet definedActivityIds = new HashSet(activityDefinitionsById.keySet());
        Set previouslyDefinedActivityIds = null;
        if (!definedActivityIds.equals(this.definedActivityIds)) {
            previouslyDefinedActivityIds = this.definedActivityIds;
            this.definedActivityIds = definedActivityIds;
            definedActivityIdsChanged = true;
        }
        boolean definedCategoryIdsChanged = false;
        HashSet definedCategoryIds = new HashSet(categoryDefinitionsById.keySet());
        Set previouslyDefinedCategoryIds = null;
        if (!definedCategoryIds.equals(this.definedCategoryIds)) {
            previouslyDefinedCategoryIds = this.definedCategoryIds;
            this.definedCategoryIds = definedCategoryIds;
            definedCategoryIdsChanged = true;
        }
        HashSet enabledActivityIds = new HashSet(this.enabledActivityIds);
        this.getRequiredActivityIds(this.enabledActivityIds, enabledActivityIds);
        boolean enabledActivityIdsChanged = false;
        Set previouslyEnabledActivityIds = null;
        if (!this.enabledActivityIds.equals(enabledActivityIds)) {
            previouslyEnabledActivityIds = this.enabledActivityIds;
            this.enabledActivityIds = enabledActivityIds;
            enabledActivityIdsChanged = true;
        }
        Map activityEventsByActivityId = this.updateActivities(this.activitiesById.keySet());
        Map categoryEventsByCategoryId = this.updateCategories(this.categoriesById.keySet());
        Map identifierEventsByIdentifierId = this.updateIdentifiers(this.identifiersById.keySet());
        if (definedActivityIdsChanged || definedCategoryIdsChanged || enabledActivityIdsChanged) {
            this.fireActivityManagerChanged(new ActivityManagerEvent(this, definedActivityIdsChanged, definedCategoryIdsChanged, enabledActivityIdsChanged, previouslyDefinedActivityIds, previouslyDefinedCategoryIds, previouslyEnabledActivityIds));
        }
        if (activityEventsByActivityId != null) {
            this.notifyActivities(activityEventsByActivityId);
        }
        if (categoryEventsByCategoryId != null) {
            this.notifyCategories(categoryEventsByCategoryId);
        }
        if (identifierEventsByIdentifierId != null) {
            this.notifyIdentifiers(identifierEventsByIdentifierId);
        }
        if (setDefaults) {
            this.setEnabledActivityIds(new HashSet(this.activityRegistry.getDefaultEnabledActivities()));
        }
    }

    public void setEnabledActivityIds(Set enabledActivityIds) {
        Map identifierEventsByIdentifierId;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        enabledActivityIds = Util.safeCopy(enabledActivityIds, (Class)clazz);
        HashSet requiredActivityIds = new HashSet(enabledActivityIds);
        this.getRequiredActivityIds(enabledActivityIds, requiredActivityIds);
        enabledActivityIds = requiredActivityIds;
        boolean activityManagerChanged = false;
        Map activityEventsByActivityId = null;
        Set previouslyEnabledActivityIds = null;
        if (!this.enabledActivityIds.equals(enabledActivityIds)) {
            previouslyEnabledActivityIds = this.enabledActivityIds;
            this.enabledActivityIds = enabledActivityIds;
            activityManagerChanged = true;
            activityEventsByActivityId = this.updateActivities(this.activitiesById.keySet());
        }
        if (activityManagerChanged && (identifierEventsByIdentifierId = this.updateIdentifiers(this.identifiersById.keySet())) != null) {
            this.notifyIdentifiers(identifierEventsByIdentifierId);
        }
        if (activityEventsByActivityId != null) {
            this.notifyActivities(activityEventsByActivityId);
        }
        if (activityManagerChanged) {
            this.fireActivityManagerChanged(new ActivityManagerEvent(this, false, false, true, null, null, previouslyEnabledActivityIds));
        }
    }

    private Map updateActivities(Collection activityIds) {
        TreeMap<String, ActivityEvent> activityEventsByActivityId = new TreeMap<String, ActivityEvent>();
        Iterator iterator = activityIds.iterator();
        while (iterator.hasNext()) {
            ActivityEvent activityEvent;
            String activityId = (String)iterator.next();
            Activity activity = (Activity)this.activitiesById.get(activityId);
            if (activity == null || (activityEvent = this.updateActivity(activity)) == null) continue;
            activityEventsByActivityId.put(activityId, activityEvent);
        }
        return activityEventsByActivityId;
    }

    private ActivityEvent updateActivity(Activity activity) {
        Set activityRequirementBindings = (Set)this.activityRequirementBindingsByActivityId.get(activity.getId());
        boolean activityRequirementBindingsChanged = activity.setActivityRequirementBindings(activityRequirementBindings != null ? activityRequirementBindings : Collections.EMPTY_SET);
        Set activityPatternBindings = (Set)this.activityPatternBindingsByActivityId.get(activity.getId());
        boolean activityPatternBindingsChanged = activity.setActivityPatternBindings(activityPatternBindings != null ? activityPatternBindings : Collections.EMPTY_SET);
        ActivityDefinition activityDefinition = (ActivityDefinition)this.activityDefinitionsById.get(activity.getId());
        boolean definedChanged = activity.setDefined(activityDefinition != null);
        boolean enabledChanged = activity.setEnabled(this.enabledActivityIds.contains(activity.getId()));
        boolean nameChanged = activity.setName(activityDefinition != null ? activityDefinition.getName() : null);
        boolean descriptionChanged = activity.setDescription(activityDefinition != null ? activityDefinition.getDescription() : null);
        if (activityRequirementBindingsChanged || activityPatternBindingsChanged || definedChanged || enabledChanged || nameChanged || descriptionChanged) {
            return new ActivityEvent(activity, activityRequirementBindingsChanged, activityPatternBindingsChanged, definedChanged, descriptionChanged, enabledChanged, nameChanged);
        }
        return null;
    }

    private Map updateCategories(Collection categoryIds) {
        TreeMap<String, CategoryEvent> categoryEventsByCategoryId = new TreeMap<String, CategoryEvent>();
        Iterator iterator = categoryIds.iterator();
        while (iterator.hasNext()) {
            CategoryEvent categoryEvent;
            String categoryId = (String)iterator.next();
            Category category = (Category)this.categoriesById.get(categoryId);
            if (category == null || (categoryEvent = this.updateCategory(category)) == null) continue;
            categoryEventsByCategoryId.put(categoryId, categoryEvent);
        }
        return categoryEventsByCategoryId;
    }

    private CategoryEvent updateCategory(Category category) {
        Set categoryActivityBindings = (Set)this.categoryActivityBindingsByCategoryId.get(category.getId());
        boolean categoryActivityBindingsChanged = category.setCategoryActivityBindings(categoryActivityBindings != null ? categoryActivityBindings : Collections.EMPTY_SET);
        CategoryDefinition categoryDefinition = (CategoryDefinition)this.categoryDefinitionsById.get(category.getId());
        boolean definedChanged = category.setDefined(categoryDefinition != null);
        boolean nameChanged = category.setName(categoryDefinition != null ? categoryDefinition.getName() : null);
        boolean descriptionChanged = category.setDescription(categoryDefinition != null ? categoryDefinition.getDescription() : null);
        if (categoryActivityBindingsChanged || definedChanged || nameChanged || descriptionChanged) {
            return new CategoryEvent(category, categoryActivityBindingsChanged, definedChanged, descriptionChanged, nameChanged);
        }
        return null;
    }

    private IdentifierEvent updateIdentifier(Identifier identifier) {
        String id = identifier.getId();
        HashSet<String> activityIds = new HashSet<String>();
        Iterator iterator = this.definedActivityIds.iterator();
        while (iterator.hasNext()) {
            String activityId = (String)iterator.next();
            Activity activity = (Activity)this.getActivity(activityId);
            if (!activity.isMatch(id)) continue;
            activityIds.add(activityId);
        }
        boolean enabled = this.isMatch(id, this.enabledActivityIds) || !this.isMatch(id, this.definedActivityIds);
        boolean activityIdsChanged = identifier.setActivityIds(activityIds);
        boolean enabledChanged = identifier.setEnabled(enabled);
        if (activityIdsChanged || enabledChanged) {
            return new IdentifierEvent(identifier, activityIdsChanged, enabledChanged);
        }
        return null;
    }

    private Map updateIdentifiers(Collection identifierIds) {
        TreeMap<String, IdentifierEvent> identifierEventsByIdentifierId = new TreeMap<String, IdentifierEvent>();
        Iterator iterator = identifierIds.iterator();
        while (iterator.hasNext()) {
            IdentifierEvent identifierEvent;
            String identifierId = (String)iterator.next();
            Identifier identifier = (Identifier)this.identifiersById.get(identifierId);
            if (identifier == null || (identifierEvent = this.updateIdentifier(identifier)) == null) continue;
            identifierEventsByIdentifierId.put(identifierId, identifierEvent);
        }
        return identifierEventsByIdentifierId;
    }
}

