/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.visitor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import razgriz.news.NewsException;
import razgriz.news.NewsPlugin;
import razgriz.news.clipper.NewsClipperService;
import razgriz.news.model.ModelElement;
import razgriz.news.model.News;
import razgriz.news.model.util.ModelVisitor;

public class NewsClippingVisitor
extends ModelVisitor {
    public Object caseNews(final News news) {
        Thread thread = new Thread(){

            public void run() {
                NewsClipperService service = NewsPlugin.getDefault().getNewsClipperService();
                try {
                    URL url = new URL(news.getLink());
                    InputStream in = url.openStream();
                    News clipped = service.clip(in);
                    news.getArticles().addAll(ListUtils.subtract((List)clipped.getArticles(), (List)news.getArticles()));
                    in.close();
                }
                catch (IOException e) {
                    throw new NewsException(e);
                }
            }
        };
        thread.start();
        return news;
    }

    public boolean prune(ModelElement elem) {
        return elem instanceof News;
    }
}

