<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */

/**
 * RA Util
 */
class RaUtil {
/* ------------------------------------------------------------------------ */

/* -- Public Method -- */
  /**
   * checkEncoding
   * @param string $value Value
   * @param string $encoding Encoding
   * @return boolean $check Result
   */
  public static function checkEncoding($value, $encoding=null) {
    $check = true;
    if (!self::checkDoubleStr($value)) return $check;
    if (is_null($encoding)) $encoding = RaConfig::CHARSET; 
    if (function_exists('mb_check_encoding')) $check = mb_check_encoding($value, $encoding);
    if ($check) {
      mb_language('Japanese');
      $checkEncoding = mb_detect_encoding($value, 'auto');
      $convValue = mb_convert_encoding($value, $encoding, $checkEncoding);
      if ($convValue !== $value) $check = false;
    }
    return $check;
  }

  /**
   * convertEncoding
   * @param string $value Value
   * @param string $fromEncoding From Encoding
   * @param string $toEncoding To Encoding
   * @return string $convValue Result
   */
  public static function convertEncoding($value, $fromEncoding, $toEncoding=null) {
    $convValue = $value;
    if (is_null($toEncoding)) $toEncoding = RaConfig::CHARSET; 
    if (!self::checkEncoding($value, $toEncoding)) {
        mb_language('Japanese');
        $convValue = mb_convert_encoding($value, $toEncoding, $fromEncoding);
    }
    return $convValue;
  }

  /**
   * convertKana
   * @param string $value Value
   * @param string $option Option
   * @param string $encoding Encoding
   * @return string $result Result
   */
  public static function convertKana($value, $option, $encoding=null) {
    if (is_null($encoding)) $encoding = RaConfig::CHARSET; 
    return mb_convert_kana($value, $option, $encoding);
  }

  /**
   * strLen
   * @param string $value Value
   * @param string $encoding Encoding
   * @return int $result Result
   */
  public static function strLen($value, $encoding=null) {
    if (is_null($encoding)) $encoding = RaConfig::CHARSET; 
    return mb_strlen($value, $encoding);
  }

  /**
   * subStr
   * @param string $value Value
   * @param int $start Start
   * @param int $length Length
   * @param string $encoding Encoding
   * @return string $result Result
   */
  public static function subStr($value, $start, $length, $encoding=null) {
    if (is_null($encoding)) $encoding = RaConfig::CHARSET; 
    return mb_substr($value, $start, $length, $encoding);
  }

  /**
   * strToLower
   * @param string $value Value
   * @param string $encoding Encoding
   * @return string $result Result
   */
  public static function strToLower($value, $encoding=null) {
    if (is_null($encoding)) $encoding = RaConfig::CHARSET; 
    return mb_strtolower($value, $encoding);
  }

  /**
   * setCookie
   * @param string $key Key
   * @param string $value Value
   * @param int $enableDays Cookie Enable Days
   * @param string $path Path
   * @param string $domain Domain
   */
  public static function setCookie($key, $value, $enableDays, $path=null, $domain=null) {
    if ($enableDays == 0) {
      $enableDays = mktime(0, 0, 0, 1, 1, 1970);
    } else {
      $enableDays = $_SERVER['REQUEST_TIME'] + 60 * 60 * 24 * $enableDays;
    }
    if (is_null($path)) {
      $scriptName = $_SERVER['SCRIPT_NAME'];
      $path = substr($scriptName, 0, strrpos($scriptName, '/') + 1);
    }
    if (is_null($domain)) $domain = $_SERVER['SERVER_NAME'];
    if (strpos($domain, '.') > 0) {
      setcookie($key, $value, $enableDays, $path, $domain);  
    } else {
      setcookie($key, $value, $enableDays, $path);  
    }
  }

  /**
   * versionComparePhp
   * @param string $version1 Version1
   * @param string $version2 Version2
   * @param string $operator Operator
   * @result boolean CompareResult
   */
  public static function versionComparePhp($version1, $version2, $operator) {
    return (!is_null($version1) && !is_null($version2)) ? version_compare($version1, $version2, $operator) : false;
  }

  /**
   * versionCompareMysql
   * @param string $version1 Version1
   * @param string $version2 Version2
   * @param string $operator Operator
   * @result boolean CompareResult
   */
  public static function versionCompareMysql($version1, $version2, $operator) {
    return (!is_null($version1) && !is_null($version2)) ? version_compare($version1, $version2, $operator) : false;
  }

  /**
   * isHttp
   * @result boolean CheckResult
   */
  public static function isHttp() {
    return (isset($_SERVER['SERVER_PROTOCOL']) && strpos(strtolower($_SERVER['SERVER_PROTOCOL']), 'http') !== false) ? true: false;
  }

  /**
   * isWindows
   * @result boolean CheckResult
   */
  public static function isWindows() {
    return (PHP_OS=='WINNT'||PHP_OS=='WIN32'||PHP_OS=='Windows') ? true : false;
  }

  /**
   * checkDoubleStr
   * @param string $value Value
   * @result boolean CheckResult
   */
  public static function checkDoubleStr($value){
    return preg_match('/^[ -~｡-ﾟ]*$/', $value) ? false : true;
  }
/* ------------------------------------------------------------------------ */

}
?>
