<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */

/**
 * RA Base Helper
 */
abstract class RaHelper {
/* ------------------------------------------------------------------------ */

/* -- Protected Property -- */
  /**
   * request
   * @var RaRequest
   */
  protected $request = null;
  /**
   * session
   * @var RaSession
   */
  protected $session = null;
  /**
   * message
   * @var RaMessage
   */
  protected $message = null;
  /**
   * result
   * @var RaResult
   */
  protected $result = null;
  /**
   * controller
   * @var string
   */
  protected $controller = null;
  /**
   * action
   * @var string
   */
  protected $action = null;
/* ------------------------------------------------------------------------ */

/* -- Public Method -- */
  /**
   * Constructer
   * @param RaRequest $request Request
   * @param RaSession $session Session
   * @param RaMessage $message Message
   * @param RaResult $result Result
   * @param string $controller controllerName
   * @param string $action actionName
   */
  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result=null, $controller, $action) {
    $this->request = $request;
    $this->session = $session;
    $this->message = $message;
    $this->result = $result;
    $this->controller = $controller;
    $this->action = $action;
  }

  /**
   * getTextData
   * @return string textData
   */
  public function getTextData() {
    $textData = $this->result->get('textData');
    return !is_null($textData) ? $textData : '';
  }
/* ------------------------------------------------------------------------ */
  
/* -- Protected Method -- */
  /**
   * checkGet
   * @return boolean checkResult
   */
  protected final function checkGet() {
    return isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] != 'GET' ? false : true; 
  }
  /**
   * checkPost
   * @return boolean checkResult
   */
  protected final function checkPost() {
    return isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] != 'POST' ? false : true; 
  }
/* ------------------------------------------------------------------------ */

}
?>
