<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class MenuConfig {

  public static $titles = array(
                    array(
                        'time' => '時間別',
                        'week' => '曜日別',
                        'term' => '日別'
                    ),
                    array(
                        'uid' => '訪問者',
                        'ip' => 'IPアドレス',
                        'remotehost' => 'リモートホスト',
                        'domain' => 'ドメイン',
                        'jpdomain' => '企業・学校等の法人',
                        'country' => '国',
                        'pref' => '都道府県'
                    ),
                    array(
                        'rank' => 'ページ',
                        'pagein' => 'Inページ',
                        'pageout' => 'Outページ',
                        'clickrank' => 'リンククリック',
                        'btnrank' => 'ボタンクリック',
                        'adsenserank' => 'AdSense クリック',
                        'adsensepagerank' => 'AdSense ページ',
                        'adsenseip' => 'AdSense IP',
                        'rate' => '直帰率'
                    ),
                    array(
                        'key' => '検索フレーズ',
                        'word' => '検索ワード',
                        'engine' => '検索エンジン',
                        'crawler' => 'クローラー',
                        'host' => 'リンク元ホスト',
                        'referer' => 'リンク元ページ'
                    ),
                    array(
                        'brow' => 'ブラウザ',
                        'os' => 'ＯＳ',
                        'screenwh' => '画面解像度',
                        'screencol' => '画面色数',
                        'jsck' => 'Javascript/Cookie'
                    ),
                    array(
                        'sendmail' => 'メール送信',
                        'download' => 'ログのダウンロード'
                    ),
                    array(
                        'selectpage' => 'ページ選択',
                        'selectuid' => '訪問者選択'
                    ),
                    array(
                        'setting' => 'アクセス解析設定',
                        'aliaslist' => '訪問者名設定',
                        'domainlist' => 'ドメイン名設定',
                        'tag' => '解析用タグの確認',
                        'phpcode' => 'PHPコードの確認'
                    ),
                    array(
                        'deletelog' => 'ログ容量確認',
                        'syssetting' => 'システム設定',
                        'uninstall' => 'アンインストール'
                    ),
                    array(
                        'logout' => 'ログアウト'
                    )
  );

  public static $actionControllers = array(
                    'selectpage' => 'admin',
                    'selectuid' => 'admin',
                    'time' => 'research',
                    'week' => 'research',
                    'term' => 'research',
                    'uid' => 'research',
                    'ip' => 'research',
                    'remotehost' => 'research',
                    'domain' => 'research',
                    'jpdomain' => 'research',
                    'country' => 'research',
                    'pref' => 'research',
                    'rank' => 'research',
                    'pagein' => 'research',
                    'pageout' => 'research',
                    'clickrank' => 'research',
                    'btnrank' => 'research',
                    'rate' => 'research',
                    'key' => 'research',
                    'word' => 'research',
                    'engine' => 'research',
                    'host' => 'research',
                    'referer' => 'research',
                    'crawler' => 'research',
                    'brow' => 'research',
                    'os' => 'research',
                    'screenwh' => 'research',
                    'screencol' => 'research',
                    'jsck' => 'research',
                    'adsenserank' => 'research',
                    'adsensepagerank' => 'research',
                    'adsenseip' => 'research',
                    'sendmail' => 'research',
                    'download' => 'research',
                    'aliaslist' => 'admin',
                    'domainlist' => 'admin',
                    'tag' => 'admin',
                    'phpcode' => 'admin',
                    'setting' => 'admin',
                    'deletelog' => 'admin',
                    'syssetting' => 'admin',
                    'uninstall' => 'admin',
                    'logout' => 'login'
  );

  public static $actionStyleSheets = array(
                    'aliaslist' => 'selectadmin',
                    'domainlist' => 'selectadmin',
                    'tag' => 'selectadmin',
                    'phpcode' => 'selectadmin',
                    'setting' => 'selectadmin',
                    'deletelog' => 'selectadmin',
                    'syssetting' => 'selectadmin',
                    'uninstall' => 'selectadmin',
                    'logout' => 'selectback'
  );

  public static $convertActions = array(
                    'time_detail' => 'time',
                    'uid_detail' => 'uid',
                    'ip_user' => 'ip',
                    'remotehost_user' => 'remotehost',
                    'domain_user' => 'domain',
                    'jpdomain_user' => 'jpdomain',
                    'country_user' => 'country',
                    'pref_user' => 'pref',
                    'rank_user' => 'rank',
                    'key_user' => 'key',
                    'engine_key' => 'engine',
                    'engine_user' => 'engine',
                    'host_user' => 'host',
                    'crawler_user' => 'crawler',
                    'referer_user' => 'referer',
                    'rate_user' => 'rate',
                    'clickrank_user' => 'clickrank',
                    'btnrank_user' => 'btnrank',
                    'pagein_user' => 'pagein',
                    'pageout_user' => 'pageout',
                    'brow_ver' => 'brow',
                    'brow_user' => 'brow',
                    'os_user' => 'os',
                    'screenwh_user' => 'screenwh',
                    'screencol_user' => 'screencol',
                    'jsck_user' => 'jsck',
                    'adsenserank_user' => 'adsenserank',
                    'adsensepagerank_user' => 'adsensepagerank',
                    'adsenseip_user' => 'adsenseip',
                    'aliasedit' => 'aliaslist',
                    'domainedit' => 'domainlist',
                    'douninstall' => 'uninstall',
                    'deletelog_confirm' => 'deletelog'
  );

  public static $calendarConvertActions = array(
                    'term' => 'time',
                    'sendmail' => 'time',
                    'download' => 'time'
  );

  public static $monthActions = array(
                    'week',
                    'term'
  );

  public static $sendMailActions = array(
                    'time',
                    'week',
                    'uid',
                    'ip',
                    'remotehost',
                    'domain',
                    'jpdomain',
                    'country',
                    'pref',
                    'rank',
                    'pagein',
                    'pageout',
                    'clickrank',
                    'btnrank',
                    'adsenserank',
                    'adsensepagerank',
                    'adsenseip',
                    'rate',
                    'key',
                    'word',
                    'engine',
                    'crawler',
                    'host',
                    'referer',
                    'brow',
                    'os',
                    'screenwh',
                    'screencol',
                    'jsck'
  );

}
?>
