<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */

/**
 * RA Session
 */
class RaSession {
/* ------------------------------------------------------------------------ */

/* -- Public Method -- */
  /**
   * Constructer
   */
  public function __construct() {
    $this->_clearSessionId();
    session_name(RaConfig::SESSION_NAME);
    session_start();
  }

  /**
   * set
   * @param string $key Session Key
   * @param string $data Session Value
   */
  public function set($key, $data) {
    $_SESSION[$key] = $data;
  }

  /**
   * get
   * @param string $key Session Key
   * @return string $value Session Value
   */
  public function get($key) {
    return isset($_SESSION[$key]) ? $_SESSION[$key] : null;
  }

  /**
   * delete
   * @param string $key Session Key
   */
  public function delete($key) {
    unset($_SESSION[$key]);
  }

  /**
   * destroy
   */
  public function destroy() {
    foreach ($_SESSION as $key => $value) unset($_SESSION[$key]);
  }

  /**
   * reGenerateId
   */
  public function reGenerateId() {
    session_regenerate_id();
  }
/* ------------------------------------------------------------------------ */

/* -- Private Method -- */
  /**
   * clearSessionId
   */
  private function _clearSessionId() {
    $serverName = $_SERVER['SERVER_NAME'];
    $pos = substr_count($serverName, '.');
    if ($pos > 0 && !preg_match('/^([0-9])+\.([0-9])+\.([0-9])+\.([0-9])+$/', $serverName)) {
      $serverName = strtolower(strrev($serverName));
      $domains = explode('.', $serverName);
      $domain = '';
      foreach ($domains as $value) {
        $domain = strrev($value). '.'. $domain;  
        if (substr($domain, strlen($domain) - 1, strlen($domain)) == '.') $domain = substr($domain, 0, strlen($domain) - 1);
        RaUtil::setCookie(RaConfig::SESSION_NAME, '', 0, '/', $domain);  
      }
    }
  }
/* ------------------------------------------------------------------------ */

}
?>
