<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */

/**
 * RA Exception
 */
class RaException extends Exception {
/* ------------------------------------------------------------------------ */

/* -- Private Property -- */
  /**
   * nativeError
   * @var boolean
   */
  private $_nativeError = false;
  /**
   * app_error_file
   * @var string
   */
  private $_app_error_file = null;
  /**
   * app_error_line
   * @var int
   */
  private $_app_error_line = null;
/* ------------------------------------------------------------------------ */

/* -- Public Method -- */
  /**
   * Constructer
   * @param string $message Err Message
   * @param long $code Err Code
   */
  public function __construct($message, $code=null){
    if (is_null($code)) $code = RaConfig::DEFAULT_ERR_CODE; 
    parent::__construct($message, $code);
    $traces = $this->getTrace();
    foreach ($traces as $k => $v) {
      if (isset($v['file'])) { 
        $file = $v['file'];
        if (stripos($file, RA_CORE_DIR. RA_SYSTEM_DIR) === false) {
          $this->_app_error_file = $file;
          $this->_app_error_line = isset($v['line']) ? $v['line'] : 0;
          break;
        }
      }
    }
  }

  /**
   * setNativeError
   * @param boolean $value value
   */
  public final function setNativeError($value) {
    $this->_nativeError = $value;
  }

  /**
   * getNativeError
   * @return boolean $nativeError Native Error
   */
  public final function getNativeError() {
    return $this->_nativeError;
  }

  /**
   * getAppErrorFile
   * @return string $app_error_file ApplicationError File
   */
  public final function getAppErrorFile() { 
    return $this->_app_error_file;
  }

  /**
   * getAppErrorLine
   * @return int $app_error_line ApplicationError Line
   */
  public final function getAppErrorLine() { 
    return $this->_app_error_line;
  }

  /**
   * raErrorHandler
   * @param string $errno errno
   * @param string $errstr errstr
   * @param string $errfile errfile
   * @param int $errline errline
   * @param array $errcontext errcontext
   */
  public static function raErrorHandler($errno, $errstr, $errfile, $errline, $errcontext) {
    $exception = new self($errstr, $errno);
    $exception->setNativeError(true);
    throw $exception;
  }
/* ------------------------------------------------------------------------ */

}
?>
