<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class InstallHelper extends BaseHelper {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result=null, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
  }
  
  public function hostName() {
    print !is_null($this->request->get('hostname')) ? $this->request->get('hostname') : InstallController::DEFAULT_DATABASE_HOSTNAME;
  }

  public function userName() {
    print $this->request->get('username');
  }

  public function pswd() {
    print $this->request->get('pswd');
  }

  public function dbName() {
    print $this->request->get('dbname');
  }

  public function tablePrefix() {
    print !is_null($this->request->get('tableprefix')) ? $this->request->get('tableprefix') : InstallController::DEFAULT_TABLE_PREFIX;
  }

  public function siteName() {
    print $this->request->get('sitename');
  }

  public function url() {
    print $this->request->get('url');
  }

}
?>
