<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class ErrorController extends BaseController {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
  }

  public function error() {
    $result = $this->result;
    if (is_null($this->request->get('controller')) && is_null($this->request->get('action')) && !$this->session->get('nextStop')) {
      if (file_exists(SETTING_INSTALL_COMPLETE_FILE) && file_exists(UPGRADE_DIR)) {
        $result->setNextController('upgrade');
        $result->setNextAction('disp');
      } else {
        $result->setNextController('install');
        $result->setNextAction('step0');
      }
    }
    $this->session->delete('nextStop');
    return $result;
  }

}
?>
