<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class UpgradeHelper extends BaseHelper {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result=null, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
  }
  
  public function upgradeDisp() {
    $html = '';
    $version = $this->result->get('version');
    $coreVersion = File::replaceCrlf(File::readFile(RA_CORE_DIR. 'version.txt'), '');
    $foundVersion = false;
    if (floatval($version) < floatval($coreVersion)) {
      $foundVersion = true;
      $html .= '<div class="notice">バージョン'. $coreVersion. 'へのアップグレードを行ないます。</div>';
      $html .= '<div class="install">以下の「アップグレード」ボタンを押してください。</div>';
      $html .= '<div class="install">';
      $html .= '<form action="'. $this->getIndexUrl('upgrade', 'upgrade', '&amp;select='. $coreVersion). '" method="post">';
      $html .= '<input class="button" type="submit" value=" バージョン'. $coreVersion. 'へのアップグレード " onclick="disableButton(this.form);" />';
      $html .= '</form>';
      $html .= '</div>';
    }
    if (!$foundVersion) {
      $html .= '<div class="err_msg">現在のバージョンは'. $version. 'です。<br />アップロードしたアップグレード用ファイルを削除してからログインしてください。</div>';
   }
    print $html;
  }

  public function linkTag() {
    $html = '';
    $html = '<a href="./'. Config::INDEX_FILENAME. '">ログイン</a>';
    print $html;
  }

}
?>
