<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class LoginController extends BaseController {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
  }

  public function login() {
    $result = $this->result;

    $this->session->destroy();

    if (file_exists(SETTING_INSTALL_COMPLETE_FILE) && file_exists(UPGRADE_DIR)) {
      $result->setNextController('upgrade');
      $result->setNextAction('disp');
      return $result;
    }

    $system = new System();
    $systemData = $system->find(array('condition' => array('id = 1')));
    if (is_null($systemData['version'])) {
      $this->session->set('nextStop', true);
      if (!File::deleteFile(SETTING_DATABASE_FILE)) $this->message->setMessage('データベース接続設定の削除に失敗しました。<br />'. '「setting」ディレクトリのアクセス権（パーミッション）を確認してください。<br />'. SETTING_DIR);
      throw new RaException('システムのバージョンが取得できませんでした。systemテーブルの内容を確認してください。');
    }
    $version = File::replaceCrlf(File::readFile(RA_CORE_DIR. 'version.txt'), '');
    if (SystemUtil::versionCompareRa($systemData['version'], $version, '!=')) {
      $this->session->set('nextStop', true);
      throw new RaException('システムとファイルのバージョンが異なります。<br />アップグレード処理を行なってください。<br />'.
                            'システムバージョン: '. $systemData['version']. ', ファイルバージョン: '. $version);
    }

    $this->session->set('version', $systemData['version']);

    if (!$this->checkPost()) {
      if ($this->_indexRedirect() && 
          isset($_COOKIE[Config::COOKIE_LOGINID]) &&
          isset($_COOKIE[Config::COOKIE_LOGINKEY]) &&
          trim($_COOKIE[Config::COOKIE_LOGINID]) != '' &&
          trim($_COOKIE[Config::COOKIE_LOGINKEY]) != '') {
        $site = new Site();
        $siteData = $site->find(array('condition' => array('id = ? and cookiekey = ?', $_COOKIE[Config::COOKIE_LOGINID], md5($_COOKIE[Config::COOKIE_LOGINKEY]))));
        if (!is_null($siteData['id'])) return $this->_loginSuccess($siteData);
      }
      return $result;
    }

    if ($this->checkRedirect()) {
      return $result;
    }

    $pswd = $this->request->get('pswd');
    if (trim($pswd) == '') {
      $this->message->setMessage('パスワードを入力してください。');
      return $result;
    } 

    $site = new Site();
    $siteData = $site->find(array('condition' => array('pswd = ?', md5($pswd))));
    if (is_null($siteData['id'])) {
      $this->message->setMessage('パスワードの入力に誤りがあります。');
      return $result;
    }

    if ($this->request->get('memory') == Config::ON) {
      $cookieKey = md5(microtime(). rand(0, 30000));
      $site->setValue('cookiekey', md5($cookieKey));
      $site->save();
      Track::setCookie(Config::COOKIE_LOGINID, $siteData['id'], Config::AUTOLOGIN_DAYS);
      Track::setCookie(Config::COOKIE_LOGINKEY, $cookieKey, Config::AUTOLOGIN_DAYS);
    } else {
      Track::clearCookie(Config::COOKIE_LOGINID);
      Track::clearCookie(Config::COOKIE_LOGINKEY);
    }

    return $this->_loginSuccess($siteData);
  }

  public function logout() {
    $result = $this->result;
    Track::clearCookie(Config::COOKIE_LOGINKEY);
    $result->setNextController('login');
    $result->setNextAction('login');
    $this->session->set('nextStop', true);
    return $result;
  }

  private function _loginSuccess($siteData) {
    $result = $this->result;

    $log = new Log();
    $log->createTable('log_'. Calendar::getNextMonth(Config::CREATE_LOG_MONTHS));

    $now = $_SERVER['REQUEST_TIME'];
    $yyyy = date('Y', $now);
    $mm = date('m', $now);
    $dd = date('d', $now);

    if (SystemUtil::checkPhpMemoryLimit()) {
      $alias = new Alias();
      $aliasData = $alias->findAll(array('order' => 'name ASC'));

      $domain = new Domain();
      $domainData = $domain->findAll(array('order' => 'name ASC'));
    } else {
      $aliasData = array();
      $domainData = array();
    }

    $this->session->set('login', $siteData['id']);
    $this->session->set('siteData', $siteData);
    $this->session->set('aliasData', $aliasData);
    $this->session->set('domainData', $domainData);
    $this->session->set('yyyyFrom', $yyyy);
    $this->session->set('mmFrom', $mm);
    $this->session->set('ddFrom', $dd);
    $this->session->set('yyyyTo', $yyyy);
    $this->session->set('mmTo', $mm);
    $this->session->set('ddTo', $dd);

    $result->setNextController('research');
    $result->setNextAction('time');

    return $result;
  }

  private function _indexRedirect() {
    $rtn = false;
    if ($this->checkRedirect() && is_null($this->request->get('controller')) && is_null($this->request->get('action'))) {
      $rtn = true;
    }
    return $rtn;
  }

}
?>
