<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */

/**
 * RA Util
 */
class RaUtil {
/* ------------------------------------------------------------------------ */

/* -- Public Method -- */
  /**
   * checkEncoding
   * @param string $value Value
   * @param string $encoding Encoding
   * @return boolean $check Result
   */
  public static function checkEncoding($value, $encoding=null) {
    if (is_null($encoding)) $encoding = RaConfig::CHARSET; 
    $check = true;
    if (function_exists('mb_check_encoding')) {
      if (!mb_check_encoding($value, $encoding)) $check = false;
    } else {
      $convValue = mb_convert_encoding($value, $encoding, $encoding);
      if (!($convValue === $value)) $check = false;
    }
    return $check;
  }

  /**
   * convertEncoding
   * @param string $value Value
   * @param string $fromEncoding From Encoding
   * @param string $toEncoding To Encoding
   * @return string $convValue Result
   */
  public static function convertEncoding($value, $fromEncoding, $toEncoding=null) {
    $convValue = $value;
    if (is_null($toEncoding)) $toEncoding = RaConfig::CHARSET; 
    if (!self::checkEncoding($value, $toEncoding)) $convValue = mb_convert_encoding($value, $toEncoding, $fromEncoding);
    return $convValue;
  }

  /**
   * setCookie
   * @param string $key Key
   * @param string $value Value
   * @param int $enableDays Cookie Enable Days
   * @param string $path Path
   * @param string $domain Domain
   */
  public static function setCookie($key, $value, $enableDays, $path=null, $domain=null) {
    if ($enableDays == 0) {
      $enableDays = mktime(0, 0, 0, 1, 1, 1970);
    } else {
      $enableDays = $_SERVER['REQUEST_TIME'] + 60 * 60 * 24 * $enableDays;
    }
    if (is_null($path)) {
      $scriptName = $_SERVER['SCRIPT_NAME'];
      $path = substr($scriptName, 0, strrpos($scriptName, '/') + 1);
    }
    if (is_null($domain)) $domain = $_SERVER['SERVER_NAME'];
    if (strpos($domain, '.') > 0) {
      setcookie($key, $value, $enableDays, $path, $domain);  
    } else {
      setcookie($key, $value, $enableDays, $path);  
    }
  }
/* ------------------------------------------------------------------------ */

}
?>
