<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class SystemUtil {

  private static $_singleton = null;
  private $_messages = array();

  public static function getSystemDataSize($createYyyyMm) {
    $systemDataSize = 0;
    $next = 0;
    $month = 1;
    while(true) {
      try {
        $yyyymm = Calendar::getNextMonth($next);
        if ($yyyymm < $createYyyyMm) break;
        $log = new Log(true, $yyyymm);
        $systemDataSize = $systemDataSize + $log->getDataSize();
        $log = null;
        $next--;
        $month++;
      } catch (Exception $exception) {
        if ($exception->getCode() == RaModel::TABLE_NOTFOUND_ERR_CODE) {
          $next--;
          $month++;
          continue;
        } else {
          throw $exception;
        }
      }
    }
    $alias = new Alias();
    $systemDataSize = $systemDataSize + $alias->getDataSize();
    $domain = new Domain();
    $systemDataSize = $systemDataSize + $domain->getDataSize();
    $site = new Site();
    $systemDataSize = $systemDataSize + $site->getDataSize();
    $title = new Title();
    $systemDataSize = $systemDataSize + $title->getDataSize();
    $system = new System();
    $systemDataSize = $systemDataSize + $system->getDataSize();
    return $systemDataSize;
  }

  public static function getMemoryLimit(){
    $memoryLimit = str_replace('M', '', ini_get('memory_limit'));
    return trim($memoryLimit) <> '' ? $memoryLimit : Config::MINIMUM_MEMORY_LIMIT;
  }

  public static function setSystemMessage($message){
    $messages = SystemUtil::getInstance()->_messages;
    array_push($messages, $message);
    SystemUtil::getInstance()->_messages = $messages;
  }

  public static function getSystemMessage(){
    return SystemUtil::getInstance()->_messages;
  }

  public static function clearSystemMessage(){
    SystemUtil::getInstance()->_messages = array();
  }

  private function __construct() {
  }

  private static function getInstance() {
    if (SystemUtil::$_singleton == null) {
      SystemUtil::$_singleton = new SystemUtil();
    }
    return SystemUtil::$_singleton;
  }

}
?>
