<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class ResearchController extends BaseController {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
    $memoryLimit = SystemUtil::getMemoryLimit();
    if ($memoryLimit > Config::MINIMUM_MEMORY_LIMIT) {
      $title = new Title();
      $titleData = $title->findAll();
    } else {
      $titleData = array();
    }
    $this->result->set('titleData', $titleData);
  }

  public function brow() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND browser <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND browser LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function brow_ver() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND brow_ver LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $conditions[0] .= ' AND browser = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function brow_user() {
    $this->checkRequest(array('select', 'browser'));
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND brow_ver = ?';
    array_push($conditions, $this->request->get('select'));
    $conditions[0] .= ' AND browser = ?';
    array_push($conditions, $this->request->get('browser'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function btnrank() {
    $conditions = $this->_initConditions(Config::CLICK_BTN);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND url LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function btnrank_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::CLICK_BTN);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND url = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function clickrank() {
    $conditions = $this->_initConditions(Config::CLICK_LINK);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND url LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function clickrank_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::CLICK_LINK);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND url = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsenseip() {
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    $conditions[0] .= ' AND remote_addr <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND remote_addr LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsenseip_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND remote_addr = ?';
    array_push($conditions, $this->request->get('select'));
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND uid LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsenserank() {
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    $conditions[0] .= ' AND title <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsenserank_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND title = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsensepagerank() {
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    $conditions[0] .= ' AND referer_title <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND referer_title LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsensepagerank_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND referer_title = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function host() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND referer_host <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND referer_host <> ?';
    array_push($conditions, Config::FROM_BOOKMARK);
    $conditions[0] .= ' AND engine = ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND referer_host LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function host_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND referer_host = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function referer() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND referer_title <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND engine = ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND referer_host <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND referer_title LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function referer_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND referer_title = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function crawler() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND crawler <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND crawler LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function crawler_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND crawler = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function key() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND keyword <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND keyword LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function key_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND keyword = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function os() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND os <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND os LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function os_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND os = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function pagein() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('search'));
  }

  public function pagein_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function pageout() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('search'));
  }

  public function pageout_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function ip() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND remote_addr <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND remote_addr LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function ip_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND remote_addr = ?';
    array_push($conditions, $this->request->get('select'));
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND uid LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function remotehost() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND remote_host <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND remote_host <> ?';
    array_push($conditions, Config::NO_DATA);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND remote_host LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function remotehost_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND remote_host = ?';
    array_push($conditions, $this->request->get('select'));
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND uid LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function domain() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND domain <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND domain <> ?';
    array_push($conditions, Config::NO_DATA);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND domain LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function domain_user() {
    $this->checkRequest('select');
    if (!is_null($this->request->get('logtype'))) {
      $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    } else {
      $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    }
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND domain = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function jpdomain() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND jpdomain <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND jpdomain LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function jpdomain_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND jpdomain = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function pref() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND pref <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND pref <> ?';
    array_push($conditions, Config::NO_DATA);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND pref LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function pref_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND pref = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function country() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND country <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND country <> ?';
    array_push($conditions, Config::NO_DATA);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND country LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function country_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND country = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function rank() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND url LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function rank_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND url = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function rate() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function rate_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function screencol() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND screencol <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function screencol_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND screencol = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function screenwh() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND screenwh <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function screenwh_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND screenwh = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function jsck() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND jsck <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function jsck_user() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND jsck = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function term() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions);
  }

  public function time() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions);
  }

  public function time_detail() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions();
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function uid() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND uid LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function uid_detail() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions();
    $conditions[0] .= ' AND uid = ?';
    array_push($conditions, $this->request->get('select'));
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function week() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions);
  }

  public function word() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND keyword <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND keyword LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('search'));
  }

  public function engine() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND engine <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND engine LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function engine_key() {
    $this->checkRequest('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND engine <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND keyword <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND engine = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function engine_user() {
    $this->checkRequest(array('select', 'engine'));
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND keyword = ?';
    array_push($conditions, $this->request->get('select'));
    $conditions[0] .= ' AND engine = ?';
    array_push($conditions, $this->request->get('engine'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function download() {
    return $this->result;
  }

  public function log() {
    $result = $this->result;
    if (!$this->checkPost()) {
      $result->setNextController('research');
      $result->setNextAction('download');
      return $result;
    }
    if (!$this->checkParamYyyyMmDd($this->request->get('yyyy_from'), $this->request->get('mm_from'), $this->request->get('dd_from'),
                                   $this->request->get('yyyy_to'), $this->request->get('mm_to'), $this->request->get('dd_to'))) {
      $this->message->setMessage('期間を正しく設定してください。');
      $result->setNextController('research');
      $result->setNextAction('download');
      return $result;
    }
    if (is_null($this->request->get('charset'))) {
      $this->message->setMessage('文字コードを選択してください。');
      $result->setNextController('research');
      $result->setNextAction('download');
      return $result;
    }
    $result->setCharset($this->request->get('charset'));
    $conditions = $this->_initConditions();
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions);
  }

  private function _initConditions($logtype = null) {
    $conditions = array('');
    if (!is_null($logtype)) {
      $conditions[0] .= ' AND logtype = ?';
      array_push($conditions, $logtype);
    }
    if (!is_null($this->session->get('selectUid'))) {
      $conditions[0] .= ' AND uid = ?';
      array_push($conditions, $this->session->get('selectUid'));
    }
    $conditions = $this->_chkNoCrawler($conditions);
    $conditions = $this->_chkfilter($this->_getFilters(), $conditions);
    return $conditions;
  }

  private function _getFilters() {
    $siteData = $this->session->get('siteData');
    $filter = $siteData['filter'];
    if (strlen(trim($filter)) == 0) return null;
    $filter = File::replaceCrlf($filter, "/r");
    return explode("/r" , $filter);
  }

  private function _chkfilter($filters, $conditions) {
    if (is_array($filters)) {
      foreach ($filters as $filter) {
        if (trim($filter) <> '') {
          $conditions[0] .= ' AND (';
          $conditions[0] .= ' remote_host NOT LIKE ?';
          array_push($conditions, '%' . $filter . '%');
          $conditions[0] .= ' AND';
          $conditions[0] .= ' remote_addr NOT LIKE ?';
          array_push($conditions, '%' . $filter . '%');
          $conditions[0] .= ' )';
        }
      }
    }
    return $conditions; 
  }

  private function _chkNoCrawler($conditions) {
    $id = $this->session->get('login');
    $site = new Site();
    $site->find(array('condition' => array('id = ?', $id)));
    $nocrawler = $site->getValue('nocrawler');
    if ($nocrawler == Config::ON) {
      $conditions[0] .= ' AND crawler = \'\'';
    }
    return $conditions; 
  }

  private function _doResearch($findOptions, $compareValue=null) {
    $dbg = debug_backtrace();
    $method = $dbg[1]['function'];
    $yyyyMmOptions = array('yyyyFrom' => $this->session->get('yyyyFrom'),
                           'mmFrom' => $this->session->get('mmFrom'),
                           'ddFrom' => $this->session->get('ddFrom'),
                           'yyyyTo' => $this->session->get('yyyyTo'),
                           'mmTo' => $this->session->get('mmTo'),
                           'ddTo' => $this->session->get('ddTo'));
    $now = $_SERVER['REQUEST_TIME'];
    $yyyy = date('Y', $now);
    $mm = date('m', $now);
    if ($this->session->get('yyyyFrom'). $this->session->get('mmFrom') == $yyyy. $mm ||
        $this->session->get('yyyyFrom'). $this->session->get('mmFrom') == Calendar::getNextMonth(1)) {
      $log = new Log();
    } else {
      $log = new Log(true);
    }
    $results = $log->findSummary($findOptions, $method, $yyyyMmOptions, $compareValue);
    $result = $this->result;
    foreach($results as $k => $v) {
      $result->set($k, $v);
    }
    return $result;
  }

}
?>
