package com.rapide_act;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.PrintWriter;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.sql.Blob;
import java.sql.Clob;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import java.nio.charset.Charset;

public class CmnUtils{
	
	protected static void emptyFile(String _file) throws Exception{
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(_file))));
			pw.close();
		}
		catch (Exception e){
			throw e;
		}
	}

	protected static void writeCsv(String _file, int _columnCount, ArrayList<String> _alData) throws Exception{
		PrintWriter pw = null;
		try {
			debugPrint("Start write csv," + "columnCount=" + _columnCount);
			pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(_file))));
			for(int i=0;i<_alData.size();i++){
				pw.print(_alData.get(i).replaceAll("\n","\r\n"));
				if (_columnCount == 1){
					pw.println("");
				} else {
					if ((i+1) % _columnCount == 0 && i > 0){
						pw.println("");
					} else {
						pw.print(",");
					}
				}
			}
			pw.close();
			debugPrint("End write csv");
		}
		catch (Exception e){
			throw e;
		}
	}

	protected static void writeSeparator(String _file, int _columnCount, ArrayList<String> _alData, String _sprtr) throws Exception{
		PrintWriter pw = null;
		try {
			debugPrint("Start write Separator," + "columnCount=" + _columnCount);
			pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(_file))));
			for(int i=0;i<_alData.size();i++){
				pw.print(_alData.get(i).replaceAll("\n","\r\n"));
				if (_columnCount == 1){
					pw.println("");
				} else {
					if ((i+1) % _columnCount == 0 && i > 0){
						pw.println("");
					} else {
						pw.print(_sprtr);
					}
				}
			}
			pw.close();
			debugPrint("End write Separator");
		}
		catch (Exception e){
			throw e;
		}
	}

	protected static void printConsole(int _columnCount, ArrayList<String> _alData) throws Exception{
		try {
			debugPrint("Start console print");
			for(int i=0;i<_alData.size();i++){
				System.out.print(_alData.get(i).replaceAll("\n","\r\n"));
				if (_columnCount == 1){
					System.out.println("");
				} else {
					if ((i+1) % _columnCount == 0 && i > 0){
						System.out.println("");
					} else {
						System.out.print(",");
					}
				}
			}
			debugPrint("End console print");
		}
		catch (Exception e){
			throw e;
		}
	}

	protected static void deepPrint(String _message) throws Exception{
		if(System.getProperty("deep")!=null && System.getProperty("deep").toUpperCase().equals("Y"))System.out.println(new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [DEBUG] " + _message);
	}

	protected static void debugPrint(String _message) throws Exception{
		if(
			(System.getProperty("deep")!=null && System.getProperty("deep").toUpperCase().equals("Y")) || 
			(System.getProperty("debug")!=null && System.getProperty("debug").toUpperCase().equals("Y"))
		)System.out.println(new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [DEBUG] " + _message);
	}

	protected static void debugPrinting(String _message) throws Exception{
		if(
			(System.getProperty("deep")!=null && System.getProperty("deep").toUpperCase().equals("Y")) || 
			(System.getProperty("debug")!=null && System.getProperty("debug").toUpperCase().equals("Y"))
		)System.out.print(new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [DEBUG] " + _message);
	}

	protected static void infoPrint(String _message) throws Exception{
		System.out.println(new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [INFO] " + _message);
	}
	protected static void infoPrinting(String _message) throws Exception{
		System.out.print(new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [INFO] " + _message);
	}

	protected static void errorPrint(String _message) throws Exception{
		System.out.println(new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + " [ERROR] " + _message);
	}

	protected static String getTimestamp() throws Exception{
		return (new java.text.SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
	}

	protected static String getYmdhm() throws Exception{
		return (new java.text.SimpleDateFormat("yyyyMMddHHmm").format(new Date()));
	}

	protected static int getArrayRowNo(ArrayList<String> _al, int _alMember, int _seq, String _value) throws Exception {
		int ret = -1;
		for(int i=0;i<_al.size()/_alMember;i++){
			if(_al.get(i*_alMember + _seq).equals(_value)){
				ret = i;
				break;
			}
		}
		return ret;
	}

	protected static String [] getArrayRowData(ArrayList<String> _al, int _alMember, int _row) throws Exception {
		String [] rowData = new String[_alMember];
		int colNo = 0;
		for(int i=_row*_alMember;i<_row*_alMember + _alMember;i++){
			rowData[colNo] = _al.get(i);
			colNo++;
		}
		return rowData;
	}

	protected static String [] splitCsv(String _line) throws Exception {
		return split(_line, ",");
	}

	protected static String [] splitSpace(String _line) throws Exception {
		return split(_line, " ");
	}

	protected static String [] splitDot(String _line) throws Exception {
		return split(_line, "\\.");
	}
	
	protected static String [] splitCrLf(String _line) throws Exception {
		return split(_line, "\r\n");
	}

	protected static String [] splitSlash(String _line) throws Exception {
		return split(_line, "/");
	}

	protected static String [] splitTab(String _line) throws Exception {
		return split(_line, "\t");
	}

	protected static String [] split(String _line, String _delim) throws Exception {
		String [] strSplit;
		strSplit = _line.split(_delim, -1);
		return strSplit;
	}
	
	protected static boolean isLastCrLf(String _str) throws Exception{
		boolean rtn = false;
		char[] charArray = _str.toCharArray();
		if (_str.length() > 1){
			if (charArray[_str.length() - 2] != '\r' && charArray[_str.length() - 1] != '\n'){
				rtn = true;
			}
		}
		return rtn;
	}

	protected static char[] hexArray = "0123456789ABCDEF".toCharArray();
	protected static String bytesToHex(byte[] _bytes){
		char[] hexChars = new char[_bytes.length * 2];
		for(int j=0;j<_bytes.length;j++){
			int v = _bytes[j] & 0xFF;
			hexChars[j * 2] = hexArray[v >>> 4];
			hexChars[j * 2 + 1] = hexArray[v & 0x0F];
		}
		return new String(hexChars);
	}
	protected static byte[] hexToBytes(String _hex){
		byte[] bytes = new byte[_hex.length()/2];
		for(int j=0;j<_hex.length()/2;j++){
			bytes[j] = (byte)Integer.parseInt(_hex.substring(j*2,(j+1)*2),16);
		}
		return bytes;
	}

	protected static String bytesToBase64(byte[] _bytes){
		return new String(Base64.encodeBase64(_bytes));
	}
	protected static byte[] base64ToBytes(String _base64){
		return Base64.decodeBase64(_base64.getBytes());
	}

	protected static String clobToString(Clob _clob) throws Exception{
		return _clob.getSubString(1, (int)_clob.length());
	}

	protected static String getLineSeparator(){
		return System.getProperty("line.separator");
	}

	protected static boolean isMatch(String [] _tables, String _table) throws Exception{
		boolean rtn = false;
		Pattern p = null;
		Matcher m = null;
		if(_tables != null && _tables.length>0){
			for (int i = 0; i < _tables.length; i++) {
				String s = _tables[i].replace("*",".*");
				//debugPrint("s="+s);
				//p = Pattern.compile(s);
				//m = p.matches(_table);
				if(_table.matches(s)){
					rtn = true;
					break;
				}
			}
		}
		return rtn;
	}
	
	protected static String getYesNo(boolean _bln){
		String retVal;
		if(_bln){
			retVal = "Yes";
		} else {
			retVal = "No";
		}
		return retVal;
	}

	protected static boolean isMatch(String [] _tabCols, String _table, String _col) throws Exception{
		boolean rtn = false;
		Pattern p = null;
		Matcher m = null;
		if(_tabCols != null && _tabCols.length>0){
			for (int i = 0; i < _tabCols.length; i++) {
				String s = null;
				String [] tbCols = splitDot(_tabCols[i]);
				//infoPrint("length="+tbCols.length);
				if (tbCols.length == 1){
					s = _tabCols[i].replace("*",".*");
					if(_col.matches(s)){
						rtn = true;
						break;
					}
				} else if (tbCols.length == 2){
					if(_table.matches(tbCols[0].replace("*",".*")) && _col.matches(tbCols[1].replace("*",".*"))){
						rtn = true;
						break;
					}
				}
			}
		}
		return rtn;
	}

	protected static boolean isJapanese(String _str) throws Exception{
		for(int i=0;i<_str.length();i++){
			char chr = _str.charAt(i);
			Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(chr);
			if (Character.UnicodeBlock.HIRAGANA.equals(unicodeBlock))return true;
			if (Character.UnicodeBlock.KATAKANA.equals(unicodeBlock))return true;
			if (Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS.equals(unicodeBlock))return true;
			if (Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS.equals(unicodeBlock))return true;
			if (Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION.equals(unicodeBlock))return true;
		}
		return false;
	}

	protected static boolean isHankaku(char _chr) throws Exception{
		if((_chr <= '\u007e') || (_chr == '\u00a5') || (_chr == '\u203e') || (_chr >= '\uff61' && _chr <= '\uff9f')){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColLength(String _colType) throws Exception{
		if(
			_colType.toUpperCase().equals("RAW") ||
			_colType.toUpperCase().equals("BINARY") ||
			_colType.toUpperCase().equals("VARBINARY") ||
			_colType.toUpperCase().equals("CHAR") ||
			_colType.toUpperCase().equals("NCHAR") || 
			_colType.toUpperCase().equals("VARCHAR") || 
			_colType.toUpperCase().equals("VARCHAR2") || 
			_colType.toUpperCase().equals("NVARCHAR") || 
			_colType.toUpperCase().equals("NVARCHAR2") || 
			_colType.toUpperCase().equals("GRAPHIC") || 
			_colType.toUpperCase().equals("VARGRAPHIC")
		){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColPrec(String _colType, String _colPrec) throws Exception{
		if(
			!_colPrec.equals("") && 
			!_colPrec.equals("0") && 
			(
				_colType.toUpperCase().equals("DECIMAL") ||
				_colType.toUpperCase().equals("NUMBER") || 
				_colType.toUpperCase().equals("NUMERIC")
			)
		){
			return true;
		} else {
			return false;
		}
	}

	protected static int getColLength(String _colType, String _colLen) throws Exception{
		if(
			_colType.toUpperCase().equals("NCHAR") ||
			_colType.toUpperCase().equals("NVARCHAR") ||
			_colType.toUpperCase().equals("NVARCHAR2")){
				return Integer.parseInt(_colLen)/2;
		} else {
			return Integer.parseInt(_colLen);
		}
	}

	protected static boolean isColString(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("LONG") ||
			_str.toUpperCase().equals("XML") ||
			_str.toUpperCase().equals("UNIQUEIDENTIFIER") ||
			_str.toUpperCase().equals("TEXT") ||
			_str.toUpperCase().equals("NTEXT") ||
			_str.toUpperCase().equals("CHARACTER") ||
			_str.toUpperCase().equals("CHAR") ||
			_str.toUpperCase().equals("BPCHAR") ||
			_str.toUpperCase().equals("NCHAR") ||
			_str.toUpperCase().equals("VARCHAR") ||
			_str.toUpperCase().equals("VARCHAR2") ||
			_str.toUpperCase().equals("NVARCHAR") ||
			_str.toUpperCase().equals("NVARCHAR2") ||
			_str.toUpperCase().equals("LONG VARCHAR") ||
			_str.toUpperCase().equals("GRAPHIC") ||
			_str.toUpperCase().equals("VARGRAPHIC") ||
			_str.toUpperCase().equals("LONG VARGRAPHIC") ||
			_str.toUpperCase().equals("MVARCHAR")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColBoolean(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("BIT") ||
			_str.toUpperCase().equals("BOOL") ||
			_str.toUpperCase().equals("BOOLEAN")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColDate(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("DATE")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColYear(String _str) throws Exception{
		if(
		_str.toUpperCase().equals("YEAR")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColTime(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("TIME")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColTimestamp(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("TIMESTAMP") ||
			_str.toUpperCase().equals("SMALLDATETIME") ||
			_str.toUpperCase().equals("DATETIME") ||
			_str.toUpperCase().equals("DATETIME2")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColBigDecimal(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("NUMERIC") ||
			_str.toUpperCase().equals("NUMBER") ||
			_str.toUpperCase().equals("MONEY") ||
			_str.toUpperCase().equals("SMALLMONEY") ||
			_str.toUpperCase().equals("DECFLOAT") ||
			_str.toUpperCase().equals("DECIMAL")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColShort(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("TINYINT") ||
			_str.toUpperCase().equals("TINYINT UNSIGNED") ||
			_str.toUpperCase().equals("SMALLINT")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColInt(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("INTEGER") ||
			_str.toUpperCase().equals("SMALLINT UNSIGNED") ||
			_str.toUpperCase().equals("MEDIUMINT") ||
			_str.toUpperCase().equals("SERIAL") ||
			_str.toUpperCase().equals("INT2") ||
			_str.toUpperCase().equals("INT4") ||
			_str.toUpperCase().equals("INT")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColLong(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("INTEGER UNSIGNED") ||
			_str.toUpperCase().equals("MEDIUMINT UNSIGNED") ||
			_str.toUpperCase().equals("BIGINT UNSIGNED") ||
			_str.toUpperCase().equals("BIGINT") ||
			_str.toUpperCase().equals("BIGSERIAL") ||
			_str.toUpperCase().equals("SERIAL8") ||
			_str.toUpperCase().equals("INT8")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColFloat(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("REAL") ||
			_str.toUpperCase().equals("SMALLFLT")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColDouble(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("FLOAT") ||
			_str.toUpperCase().equals("DOUBLE") ||
			_str.toUpperCase().equals("DOUBLE PRECISION")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColBytes(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("RAW") ||
			_str.toUpperCase().equals("GEOMETRY") ||
			_str.toUpperCase().equals("BINARY")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColBlob(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("BYTEA") ||
			_str.toUpperCase().equals("BLOB") ||
			_str.toUpperCase().equals("VARBINARY") ||
			_str.toUpperCase().equals("UDT") ||
			_str.toUpperCase().equals("IMAGE")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isColClob(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("CLOB") ||
			_str.toUpperCase().equals("NCLOB")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isLob(String _str) throws Exception{
		if(
			isColClob(_str) || isColBlob(_str)){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isEmpty(String _str) throws Exception{
		if(_str == null || _str.equals("")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isNumeric(String _str) {
		boolean retVal = true;
		try {
			int val = Integer.parseInt(_str);
		} catch (Exception e){
			retVal = false;
		}
		return retVal;
	}

	protected static boolean isReserved(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("CURRENT_DATE") ||
			_str.toUpperCase().equals("CURRENT_TIME") ||
			_str.toUpperCase().equals("CURRENT_TIMESTAMP") ||
			_str.toUpperCase().equals("CURRENT_USER") ||
			_str.toUpperCase().equals("LOCALTIME") ||
			_str.toUpperCase().equals("LOCALTIMESTAMP") ||
			_str.toUpperCase().equals("NULL")){
			return true;
		} else {
			return false;
		}
	}

	protected static boolean isCharacterSet(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("CP932") ||
			_str.toUpperCase().equals("UTF8") ||
			_str.toUpperCase().equals("UJIS")){
			return true;
		} else {
			return false;
		}
	}

	protected static String[] getSystemProperty(String _str) throws Exception{
		String [] retValue = null;
		if(System.getProperty(_str)!=null){
			retValue = splitCsv(System.getProperty(_str).toUpperCase());
		}
		return retValue;
	}

	protected static String getSystemProperty(String _str, String _strDefault) throws Exception{
		String retValue = _strDefault;
		if(System.getProperty(_str)!=null){
			retValue = System.getProperty(_str).toUpperCase();
		}
		return retValue;
	}

	protected static char getSystemProperty(String _str, char _chrDefault) throws Exception{
		char retValue = _chrDefault;
		if(System.getProperty(_str)!=null){
			retValue = System.getProperty(_str).toUpperCase().charAt(0);
		}
		return retValue;
	}

	protected static boolean getSystemProperty(String _str, boolean _blnDefault) throws Exception{
		boolean retValue = _blnDefault;
		if(System.getProperty(_str)!=null){
			if(System.getProperty(_str).toUpperCase().equals("Y")){
				retValue = true;
			} else if (System.getProperty(_str).toUpperCase().equals("N")){
				retValue = false;
			} else {
				retValue = true;
			}
		}
		return retValue;
	}

	protected static String getSeparator(String _str, String _strDefault) throws Exception{
		String retValue = _strDefault;
		if(System.getProperty(_str)!=null){
			String _sprtr = System.getProperty(_str);
			char [] chr = new char[_sprtr.length()];
			int j = 0;
			for(int i=0;i<_sprtr.length();i++){
				if (i < _sprtr.length() - 1){
					if (_sprtr.charAt(i) == '\\'){
						switch(_sprtr.charAt(i + 1)){
							case 't':
								chr[j] = 0x09;
								i++;
								j++;
								break;
							default:
								chr[j] = _sprtr.charAt(i);
								j++;
								break;
						}
					} else {
						chr[j] = _sprtr.charAt(i);
						j++;
					}
				} else {
					chr[j] = _sprtr.charAt(i);
					j++;
				}
			}
			char [] chr2 = new char[j];
			for(int i=0;i<j;i++){
				chr2[i] = chr[i];
			}
			retValue = String.valueOf(chr2);
		}
		return retValue;
	}

	protected static String getDelimiter(String _str) throws Exception{
		String retValue = _str;
		if(_str!=null){
			char [] chr = new char[_str.length()];
			int j = 0;
			for(int i=0;i<_str.length();i++){
				if (i < _str.length() - 1){
					if (_str.charAt(i) == '\\'){
						switch(_str.charAt(i + 1)){
							case 't':
								chr[j] = 0x09;
								i++;
								j++;
								break;
							default:
								chr[j] = _str.charAt(i);
								j++;
								break;
						}
					} else {
						chr[j] = _str.charAt(i);
						j++;
					}
				} else {
					chr[j] = _str.charAt(i);
					j++;
				}
			}
			char [] chr2 = new char[j];
			for(int i=0;i<j;i++){
				chr2[i] = chr[i];
			}
			retValue = String.valueOf(chr2);
		}
		return retValue;
	}

	protected static String getLineSeparator(String _str, String _strDefault) throws Exception{
		String retValue = _strDefault;
		if(System.getProperty(_str)!=null){
			String _sprtr = System.getProperty(_str);
			char [] chr = new char[_sprtr.length()];
			int j = 0;
			for(int i=0;i<_sprtr.length();i++){
				if (i < _sprtr.length() - 1){
					if (_sprtr.charAt(i) == '\\'){
						switch(_sprtr.charAt(i + 1)){
							case 'r':
								chr[j] = 0x0d;
								i++;
								j++;
								break;
							case 'n':
								chr[j] = 0x0a;
								i++;
								j++;
								break;
						}
					}
				}
			}
			char [] chr2 = new char[j];
			for(int i=0;i<j;i++){
				chr2[i] = chr[i];
			}
			retValue = String.valueOf(chr2);
		}
		return retValue;
	}

	protected static String getLineSeparator(String _str) throws Exception{
		String retValue = _str;
		if(_str!=null){
			char [] chr = new char[_str.length()];
			int j = 0;
			for(int i=0;i<_str.length();i++){
				if (i < _str.length() - 1){
					if (_str.charAt(i) == '\\'){
						switch(_str.charAt(i + 1)){
							case 'r':
								chr[j] = 0x0d;
								i++;
								j++;
								break;
							case 'n':
								chr[j] = 0x0a;
								i++;
								j++;
								break;
						}
					}
				}
			}
			char [] chr2 = new char[j];
			for(int i=0;i<j;i++){
				chr2[i] = chr[i];
			}
			retValue = String.valueOf(chr2);
		}
		return retValue;
	}

	protected static boolean isFixString(String _str) throws Exception{
		if(
			_str.toUpperCase().equals("CHARACTER") ||
			_str.toUpperCase().equals("CHAR") ||
			_str.toUpperCase().equals("NCHAR")){
			return true;
		} else {
			return false;
		}
	}

	protected static int getByteLength(String string, Charset charset) {
		return string.getBytes(charset).length;
	}

	protected static String padSpace(String str, int len, Charset charset){
		int bytelen = getByteLength(str, charset);
		if(len > bytelen){
			for(int i=0; i<(len - bytelen);i++){
			    str = str + " ";
			}
		}
		return str;
	}

}
