package com.rapide_act;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.sql.Blob;
import java.sql.Clob;

public class RapideMetaUnloader{

	private static final int DB_TYPE_ORACLE = 0;
	private static final int DB_TYPE_SQLSERVER = 1;
	private static final int DB_TYPE_MYSQL = 2;
	private static final int DB_TYPE_DB2 = 3;
	private static final int DB_TYPE_POSTGRESQL = 4;
	private static final int DB_TYPE_HIRDB = 5;
	private static final int DB_TYPE_UNKNOWN = -1;
	private static final int TYPE_TABLE = 0;
	private static final int TYPE_INDEX = 1;
	private static final int TYPE_VIEW = 2;
	private static final int TYPE_PROCEDURE = 3;
	private static final int TYPE_SEQ = 4;
	private static final int TYPE_SYNONYM = 5;
	private static final int TYPE_OBJ = 6;
	private static final int TYPE_FK = 7;
	private static final String [] FILE_NAME = {
		"TABLEDEF",
		"INDEXDEF",
		"VIEWDEF",
		"PROCDEF",
		"SEQDEF",
		"SYNMDEF",
		"OBJDEF",
		"FKDEF"
	};
	private static final String lineSeparator = System.getProperty("line.separator");
	protected static final String [] DB_SQL_QUOTED_S = {"\"", "[", "`", "\"", "\"", "\""};
	protected static final String [] DB_SQL_QUOTED_E = {"\"", "]", "`", "\"", "\"", "\""};
	private static final String [] DROP_OPTION = {" CASCADE CONSTRAINT PURGE", "", "", "", "", ""};
//	private static final String [] cp.SQL_TERMINATOR = {";", lineSeparator + "GO", ";", ";", ";", ";"};
//	private static final String [] cp.SQL_PREFIX = {"@", ":r ", "", "", "", ""};
	private static final String [][] sql =  {
		{	//ORACLE
		"select "
		     + "a.table_name as table_name,"
		     + "replace(replace(b.comments, chr(13), ''), chr(10), '') as table_comments,"
		     + "c.column_name as column_name, "
		     + "replace(replace(d.comments, chr(13), ''), chr(10), '') as column_comments, "
		     + "decode(c.data_type, 'TIMESTAMP(6)', 'TIMESTAMP',c.data_type) as data_type, "
		     + "c.data_length as data_length,"
		     + "c.data_precision as data_precision,"
		     + "c.data_scale as data_scale,"
		     + "decode(c.nullable, 'N', '', null) as nullable,"
		     + "c.data_default as data_default "
		     + "from user_tables a "
		     + "inner join user_tab_comments b "
		     + "on a.table_name = b.table_name "
		     + "inner join user_tab_columns c "
		     + "on a.table_name = c.table_name "
		     + "inner join user_col_comments d "
		     + "on c.table_name = d.table_name "
		     + " and c.column_name = d.column_name "
		     + "order by a.table_name,c.column_id",
		"select "
		     + " a.table_name,"
		     + " a.index_name,"
		     + " a.index_type,"
		     + " c.constraint_type,"
		     + " b.column_name,"
		     + " b.column_position "
		     + " from"
		     + " user_indexes a,"
		     + " user_ind_columns b,"
		     + " user_constraints c "
		     + " where"
		     + "  a.table_name = b.table_name and"
		     + "  a.index_name = b.index_name and"
		     + "  a.table_name = c.table_name(+) and"
		     + "  a.index_name = c.constraint_name(+) "
		     + " order by"
		     + " a.table_name,"
		     + " a.index_name,"
		     + " b.column_position",
		"select "
		     + " a.view_name, "
		     + " replace(replace(c.comments, chr(13), ''), chr(10), '') as comments "
		     + " from"
		     + " user_views a, "
		     + " user_tab_comments c "
		     + " where"
			+ "  a.view_name = c.table_name(+) "
		     + " order by"
		     + " a.view_name",
		"select "
		     + " object_name, "
		     + " object_type "
		     + "from"
		     + " user_objects"
		     + " where object_type in('PACKAGE BODY','PROCEDURE','FUNCTION','TRIGGER','TYPE')"
		     + " group by object_name,object_type"
		     + " order by object_name,object_type",
		"select "
		     + "  sequence_name,"
		     + "  to_char(min_value) as min_value,"
		     + "  to_char(max_value) as max_value,"
		     + "  to_char(increment_by) as increment_by,"
		     + "  cycle_flag,"
		     + "  order_flag,"
		     + "  to_char(cache_size) as cache_size,"
		     + "  to_char(last_number) as last_number "
		     + " from user_sequences "
		     + " order by sequence_name",
		"select "
		     + "  synonym_name,"
		     + "  table_owner,"
		     + "  table_name,"
		     + "  db_link "
		     + "from user_synonyms "
		     + "order by synonym_name,table_owner,table_name",
		"select "
		     + " a.table_name,"
		     + " a.object_name,"
		     + " a.object_type,"
		     + " a.pct_free,"
		     + " a.pct_used,"
		     + " a.ini_trans,"
		     + " a.freelists,"
		     + " a.freelist_groups,"
		     + " a.buffer_pool,"
		     + " a.tablespace_name, "
		     + " a.logging, "
		     + " b.bytes "
		     + "from "
		     + "(select "
		     + " table_name,"
		     + " table_name as object_name,"
		     + " 'TABLE' as object_type,"
		     + " pct_free,"
		     + " pct_used,"
		     + " ini_trans,"
		     + " freelists,"
		     + " freelist_groups,"
		     + " buffer_pool,"
		     + " tablespace_name, "
		     + " logging "
		     + "from "
		     + " user_tables "
		     + " union select "
		     + " table_name,"
		     + " index_name as object_name,"
		     + " 'INDEX' as object_type,"
		     + " pct_free,"
		     + " null as pct_used,"
		     + " ini_trans,"
		     + " freelists,"
		     + " freelist_groups,"
		     + " buffer_pool,"
		     + " tablespace_name, "
		     + " logging "
		     + " from "
		     + " user_indexes "
		     + ") a, "
		     + "(select "
		     + " segment_name,"
		     + " segment_type,"
		     + " bytes "
		     + " from "
		     + " user_segments "
		     + ") b "
		     + " where a.object_name = b.segment_name "
		     + " and a.object_type = b.segment_type "
		     + " order by"
		     + " a.table_name,"
		     + " a.object_name",
		"select distinct "
		     + " a.table_name as table_name, "
		     + " a.constraint_name as constraint_name, "
		     + " b.column_name as column_name, "
		     + " b.position as position,"
		     + " c.table_name as r_table_name, "
		     + " d.column_name as r_column_name, "
		     + " d.position as r_position "
		     + " from "
		     + "   user_constraints a, "
		     + "   user_cons_columns b,"
		     + "   user_constraints c, "
		     + "   user_cons_columns d "
		     + " where "
		     + "   a.constraint_type = 'R'"
		     + "   and a.owner = b.owner"
		     + "   and a.table_name = b.table_name"
		     + "   and a.constraint_name = b.constraint_name"
		     + "   and c.constraint_type in('P','U')"
		     + "   and c.owner = b.owner"
		     + "   and c.table_name = d.table_name"
		     + "   and c.constraint_name = d.constraint_name"
		     + "   and a.r_owner = c.owner"
		     + "   and a.r_constraint_name = c.constraint_name"
		     + " order by"
		     + "   a.table_name,a.constraint_name,b.position,d.position"
		},
		{	//SQL SERVER
		"select "
		     + "a.name    as table_name, "
		     + "replace(replace(cast(b.value as varchar(4000)), char(13), ''), char(10), '') as table_comments, "
		     + "c.name    as column_name, "
		     + "replace(replace(cast(d.value as varchar(4000)), char(13), ''), char(10), '') as column_comments, "
		     + "e.name as data_type, "
		     + "c.max_length as data_length, "
		     + "c.precision as data_precision, "
		     + "c.scale as data_scale, "
		     + "case c.is_nullable"
		     + "  when '0' then 'Z'"
		     + "  else null "
		     + "end as nullable,"
		     + "g.definition as data_default "
		     + "from "
		     + "sys.tables as a "
		     + "left outer join sys.extended_properties as b "
		     + "on a.object_id = b.major_id and b.minor_id = 0 "
		     + "inner join sys.columns as c "
		     + "on a.object_id = c.object_id "
		     + "left outer join sys.extended_properties as d "
		     + "on a.object_id = d.major_id and c.column_id = d.minor_id "
		     + "inner join sys.types as e "
		     + "on c.system_type_id = e.system_type_id and c.user_type_id = e.user_type_id "
		     + "left outer join sys.sysconstraints f "
		     + "on c.object_id = f.id "
		     + "and c.column_id = f.colid "
		     + "and (f.status & 2069) = 2069 "
		     + "left outer join sys.default_constraints g "
		     + "on f.constid = g.object_id "
		     + "and a.schema_id = g.schema_id "
		     + "order by a.name,c.column_id ",
		"select "
		     + "d.name as table_name, "
		     + "a.name as index_name, "
		     + "a.type as index_type, "
		     + "case a.is_unique "
		     + "  when 1 then "
		     + "    case a.is_primary_key "
		     + "      when 1 then 'P' "
		     + "        else "
		     + "            case a.is_unique_constraint "
		     + "                when 1 then 'U' "
		     + "                else '' "
		     + "            end "
		     + "    end "
		     + "  else '' "
		     + "end as constraint_type, "
		     + "c.name as column_name, "
		     + "b.key_ordinal as column_position "
		     + "from "
		     + "  sys.indexes as a "
		     + "  inner join sys.index_columns as b "
		     + "      on a.object_id = b.object_id and a.index_id = b.index_id "
		     + "  inner join sys.columns as c "
		     + "      on c.column_id = b.column_id "
		     + "         and c.object_id = b.object_id "
		     + "  inner join sys.objects as d "
		     + "      on a.object_id = d.object_id and d.type = 'U' "
		     + "order by d.name, a.name,b.key_ordinal",
		"select "
		     + " a.name as view_name, "
		     + " replace(replace(cast(b.value as varchar(4000)), char(13), ''), char(10), '') as comments "
		     + "from "
		     + " sys.views a "
		     + " left outer join sys.extended_properties as b "
		     + " on a.object_id = b.major_id and b.minor_id = 0 "
		     + "order by "
		     + " a.name",
		"select "
		     + " name as object_name, 'PROCEDURE' as object_type from sys.procedures"
		     + " union select "
		     + " name as object_name, 'FUNCTION' as object_type from sys.objects where type in('FN', 'FS', 'FT', 'IF', 'TF') "
		     + " union select "
		     + " name as object_name, 'TRIGGER' as object_type from sys.triggers "
		     + " order by object_name,object_type ",
		"select "
		     + "  name as sequence_name,"
		     + "  cast(minimum_value as varchar(20)) as min_value,"
		     + "  cast(maximum_value as varchar(20)) as max_value,"
		     + "  cast(increment as varchar(20)) as increment_by,"
		     + "  is_cycling as cycle_flag,"
		     + "  is_cached as order_flag,"
		     + "  cast(cache_size as varchar(20)) as cache_size,"
		     + "  cast(start_value as varchar(20)) as last_number "
		     + " from sys.sequences "
		     + " order by name",
		"select "
		     + " a.name as synonym_name,"
		     + " b.name as table_owner,"
		     + " base_object_name as table_name,"
		     + " '' as db_link "
		     + "from sys.synonyms a "
		     + " inner join sys.schemas as b "
		     + " on a.schema_id = b.schema_id "
		     + "order by synonym_name,table_owner,table_name",
		"select "
		     + " c.name as table_name, "
		     + " b.index_id, "
		     + " d.name as index_name , "
		     + " a.type_desc as allocation_type, "
		     + " a.data_pages, "
		     + " partition_number "
		     + "from "
		     + " sys.allocation_units as a "
		     + " inner join sys.partitions as b "
		     + " on a.container_id = b.partition_id "
		     + " inner join sys.objects as c "
		     + " on b.object_id = c.object_id and c.type = 'U' "
		     + " inner join sys.indexes as d "
		     + " on b.index_id = d.index_id and d.object_id = b.object_id "
		     + "order by c.name, b.index_id",
		"select distinct "
		     + " c.name as table_name, "
		     + " a.name as constraint_name, "
		     + " d.name as column_name, "
		     + " b.constraint_column_id as position, "
		     + " e.name as r_table_name, "
		     + " f.name as r_column_name ,"
		     + " f.column_id as r_position "
		     + "from sys.foreign_keys as a "
		     + " inner join sys.foreign_key_columns as b "
		     + "     on a.object_id = b.constraint_object_id "
		     + " inner join sys.tables as c "
		     + "     on b.parent_object_id = c.object_id "
		     + " inner join sys.columns as d "
		     + "     on b.parent_object_id = d.object_id and "
		     + "         b.parent_column_id = d.column_id "
		     + " inner join sys.tables as e "
		     + "     on b.referenced_object_id = e.object_id "
		     + " inner join sys.columns as f "
		     + "     on b.referenced_object_id = f.object_id and "
		     + "         b.referenced_column_id = f.column_id "
		     + " inner join sys.key_constraints as g "
		     + "     on a.referenced_object_id = g.parent_object_id "
		     + "order by table_name,constraint_name, position"
		}
	};
	private static String sql_view_text[] = {
		"select text from user_views where view_name = ?",
		"select c.definition "
		     + "from sys.views a "
		     + "inner join sys.objects b "
		     + "on  b.object_id = a.object_id "
		     + "inner join sys.sql_modules c "
		     + "on  c.object_id = b.object_id "
		     + "where a.name = ?"
	};
	private static String sql_view_column_and_comment[] = {
		"select "
	     + " b.column_name,"
	     + " replace(replace(d.comments, chr(13), ''), chr(10), '') as comments "
	     + " from"
	     + " user_tab_columns b,"
	     + " user_col_comments d "
	     + " where"
	     + "  b.table_name = ? and"
	     + "  b.table_name = d.table_name(+) and"
	     + "  b.column_name = d.column_name(+) "
	     + " order by"
	     + " b.column_id",
	    " select "
	     + " b.name as column_name, "
	     + " '' as comments "
	     + " from "
	     + " sys.objects a "
	     + " inner join sys.columns b on a.object_id = b.object_id and a.name = ? "
	     + " inner join sys.types c on b.system_type_id = c.system_type_id "
	     + " where a.type = 'V' "
	     + " and c.user_type_id <> 256 "
	     + " order by b.column_id"
	};
	private static String sql_proc[] = {
		"select text from user_source where type = ? and name = ? order by line",
		"select d.definition "
		     + "from "
		     + " (select a.name,'PROCEDURE' as type,c.definition "
		     + "from sys.procedures a "
		     + "inner join sys.objects b "
		     + "on b.object_id = a.object_id "
		     + "inner join sys.sql_modules c "
		     + "on  c.object_id = b.object_id "
		     + "union select "
		     + " a.name,'FUNCTION' as type,c.definition "
		     + "from sys.objects a "
		     + "inner join sys.objects b "
		     + "on  b.object_id = a.object_id "
		     + "inner join sys.sql_modules c "
		     + "on  c.object_id = b.object_id and a.type in('FN', 'FS', 'FT', 'IF', 'TF') "
		     + "union select "
		     + "a.name,'TRIGGER' as type,c.definition "
		     + "from sys.triggers a "
		     + "inner join sys.objects b "
		     + "on  b.object_id = a.object_id "
		     + "inner join sys.sql_modules c "
		     + "on  c.object_id = b.object_id) d "
		     + "where d.type = ? and d.name = ?"
	};

	private String database = null;
	private String phyfileExtension = "phy";

	public static void main(String args[]){
		try {
			if (args.length > 0){
				RapideMetaUnloader RapideMetaUnloader = new RapideMetaUnloader(args[0]);
				RapideMetaUnloader.metaUnload();
			} else {
				RapideMetaUnloader RapideMetaUnloader = new RapideMetaUnloader(null);
				RapideMetaUnloader.metaUnload();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	RapideMetaUnloader(String _database) {
		super();
		database = _database;
	}


	private void metaUnload(){
		Connection conn = null;
		PreparedStatement stmt = null;
		BufferedReader [] br = new BufferedReader[4];
		PrintWriter [] pw = new PrintWriter[6];
		File folder = null;
		File subFolder = null;
		String strLine = null;
		String strLine2 = null;
		String [][] strSplit = new String[4][];
		String strContents = null;
		ArrayList<String> alData = null;
		ArrayList<String> alData2 = null;
		int columnCount = 0;
		String tableName = null;
		String tableCmnt = null;
		String colName = null;
		String colCmnt = null;
		String colType = null;
		String colLen = null;
		String colPrec = null;
		String colScale = null;
		String colNoN = null;
		String colDflt = null;
		String indexName = null;
		String indexType = null;
		String constraintType = null;
		String colPos = null;
		String seqName = null;
		String minVal = null;
		String maxVal = null;
		String incSz = null;
		String cycFg = null;
		String odFg = null;
		String cacheSz = null;
		String lstNo = null;
		String synmOwner = null;
		String synmName = null;
		String tbOwner = null;
		String tbName = null;
		String dbLnk = null;
		String userName = null;
		String passWord = null;
		String host = null;
		String created = null;
		String acStat = null;
		String defTbsp = null;
		String tmpTbsp = null;
		String grntee = null;
		String grntor = null;
		String grntrl = null;
		String prvs = null;
		String grntabl = null;
		String hrchy = null;

		String objName = null;
		String objTyp = null;
		String pctFree = null;
		String pctUsed = null;
		String iniTrns = null;
		String freeLst = null;
		String flstGrp = null;
		String bufPool = null;
		String tblSpace = null;
		String logging = null;
		String segByts = null;

		String fkName = null;
		String fkCol = null;
		String fkColPos = null;
		String rtbName = null;
		String rfkName = null;
		String rfkCol = null;
		String rfkColPos = null;

		CmnProps cp = null;
		CmnAccessObjects dao = null;
		
		try {
			cp = new CmnProps();
			cp.setProperty(database);
			
			if (cp.dbType > cp.DB_TYPE_SQLSERVER || cp.dbType <0){
				throw new Exception("f[^x[XΏۊOłB[" + cp.DB_TYPE_NAME[cp.dbType] + "]");
			}
			if(cp.outFolder != null){
				folder = new File(cp.outFolder);
			} else {
				if(database != null){
					folder = new File(cp.DEFAULT_OUT_FOLDER + "/DDL_" + database.toUpperCase() + "_" + CmnUtils.getYmdhm());
				} else {
					folder = new File(cp.DEFAULT_OUT_FOLDER + "/DDL_" + cp.DB_TYPE_NAME[cp.dbType].toUpperCase() + "_" + CmnUtils.getYmdhm());
				}
				folder.mkdir();
			}

			CmnUtils.infoPrint("-->o͐tH_='" + folder + "'");
			CmnUtils.infoPrint("^f[^A[hJn܂B");

			// Connect
			dao = new CmnAccessObjects(cp);
			conn = dao.connect();
			// Def tsv Writing start
			for(int i=0;i<sql[cp.dbType].length;i++){
				dao.select(sql[cp.dbType][i]);
				CmnUtils.writeSeparator(folder + "/" + FILE_NAME[i] + "_" + database +"." + cp.fileExtension, dao.getColumnCount(), dao.getArrayList(), cp.delimiter);
			}
			// Def tsv Writing end

			// Table Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[TYPE_TABLE] + "_" + database + "." + cp.fileExtension));
			subFolder = new File(folder + "/TABLES");
			subFolder.mkdir();
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_TABLE]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_TABLE]))));
			pw[3] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.TRUNCATE_TABLE]))));

			tableName = "";
			tableCmnt = "";
			colName = "";
			colCmnt = "";
			colType = "";
			colLen = "";
			colPrec = "";
			colScale = "";
			colNoN = "";
			colDflt = "";

			StringBuffer sbTbCnts = new StringBuffer();
			StringBuffer sbTbCmnt = new StringBuffer();
			while((strLine=br[0].readLine()) != null){
				if(!strLine.equals("")){
					strSplit[0] = CmnUtils.split(strLine, cp.delimiter);
					if (!tableName.equals("")){
						sbTbCnts.append("    " + DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
						sbTbCnts.append(" " + colType);
						if(!colCmnt.equals(""))sbTbCmnt.append(commentOnColumn(cp, tableName, colName, colCmnt, TYPE_TABLE));
						if(!colCmnt.equals(""))sbTbCmnt.append(lineSeparator);
						if(CmnUtils.isColPrec(colType, colPrec)){
							sbTbCnts.append("(" + colPrec);
							if (!colScale.equals("") && !colScale.equals("0"))sbTbCnts.append("," + colScale);
							sbTbCnts.append(")");
						} else if (CmnUtils.isColLength(colType)){
							if(colLen.equals("-1")){
								sbTbCnts.append("(max)");
							} else {
								sbTbCnts.append("(" + CmnUtils.getColLength(colType, colLen) + ")");
							}
						}
						if (!colDflt.equals(""))sbTbCnts.append(" DEFAULT " + colDflt.trim());
						if (!colNoN.equals("")){
							sbTbCnts.append(" NOT NULL");
						} else {
							sbTbCnts.append(" NULL");
						}
						if (!strSplit[0][0].equals(tableName)){
							pw[1].println(cp.SQL_PREFIX[cp.dbType] + "TABLES/" + tableName + ".sql");
							pw[2].println("DROP TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ tableName + DB_SQL_QUOTED_E[cp.dbType]+ DROP_OPTION[cp.dbType] + cp.SQL_TERMINATOR[cp.dbType]);
							pw[3].println("TRUNCATE TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ tableName + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
							sbTbCnts.append(lineSeparator);
							sbTbCnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
							sbTbCnts.append(lineSeparator);
							pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + tableName + ".sql"))));
							strSplit[1] = CmnUtils.split(sbTbCnts.toString(), lineSeparator);
							for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[0].println(strSplit[1][i]);
							strSplit[2] = CmnUtils.split(sbTbCmnt.toString(), lineSeparator);
							for(int i=0;i<strSplit[2].length;i++)if(!strSplit[2][i].trim().equals(""))pw[0].println(strSplit[2][i]);
							pw[0].close();
							pw[0] = null;
							CmnUtils.infoPrint(String.format("%1$-30s",tableName) + " ^f[^A[h܂B");
							sbTbCnts = new StringBuffer();
							sbTbCmnt = new StringBuffer();
							sbTbCnts.append("CREATE TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]);
							sbTbCnts.append(lineSeparator);
							sbTbCnts.append("(");
							sbTbCnts.append(lineSeparator);
							if(!strSplit[0][1].equals(""))sbTbCmnt.append(commentOnTable(cp, strSplit[0][0], strSplit[0][1], TYPE_TABLE));
							if(!strSplit[0][1].equals(""))sbTbCmnt.append(lineSeparator);
						} else {
							sbTbCnts.append(",");
							sbTbCnts.append(lineSeparator);
						}
					}
					else {
						sbTbCnts.append("CREATE TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]);
						sbTbCnts.append(lineSeparator);
						sbTbCnts.append("(");
						sbTbCnts.append(lineSeparator);
						if(!strSplit[0][1].equals(""))sbTbCmnt.append(commentOnTable(cp, strSplit[0][0], strSplit[0][1], TYPE_TABLE));
						if(!strSplit[0][1].equals(""))sbTbCmnt.append(lineSeparator);
					}
					for(int i=0;i<strSplit[0].length;i++)CmnUtils.debugPrint("'" + strSplit[0][i] + "'");

					tableName = strSplit[0][0];
					tableCmnt = strSplit[0][1];
					colName = strSplit[0][2];
					colCmnt = strSplit[0][3];
					colType = strSplit[0][4];
					colLen = strSplit[0][5];
					colPrec = strSplit[0][6];
					colScale = strSplit[0][7];
					colNoN = strSplit[0][8];
					colDflt = strSplit[0][9];
				}
			}

			if (!tableName.equals("")){
				sbTbCnts.append("    " + DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
				sbTbCnts.append(" " + colType);
				if(!colCmnt.equals(""))sbTbCmnt.append(commentOnColumn(cp, tableName, colName, colCmnt, TYPE_TABLE));
				if(!colCmnt.equals(""))sbTbCmnt.append(lineSeparator);
				if(CmnUtils.isColPrec(colType, colPrec)){
					sbTbCnts.append("(" + colPrec);
					if (!colScale.equals("") && !colScale.equals("0"))sbTbCnts.append("," + colScale);
					sbTbCnts.append(")");
				} else if (CmnUtils.isColLength(colType)){
					if(colLen.equals("-1")){
						sbTbCnts.append("(max)");
					} else {
						sbTbCnts.append("(" + CmnUtils.getColLength(colType, colLen) + ")");
					}
				}
				if (!colDflt.equals(""))sbTbCnts.append(" DEFAULT " + colDflt.trim());
				if (!colNoN.equals("")){
					sbTbCnts.append(" NOT NULL");
				} else {
					sbTbCnts.append(" NULL");
				}
				pw[1].println(cp.SQL_PREFIX[cp.dbType] + "TABLES/" + tableName + ".sql");
				pw[2].println("DROP TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ tableName + DB_SQL_QUOTED_E[cp.dbType]+ DROP_OPTION[cp.dbType] + cp.SQL_TERMINATOR[cp.dbType]);
				pw[3].println("TRUNCATE TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ tableName + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				sbTbCnts.append(lineSeparator);
				sbTbCnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
				sbTbCnts.append(lineSeparator);
				pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + tableName + ".sql"))));
				strSplit[1] = CmnUtils.split(sbTbCnts.toString(), lineSeparator);
				for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[0].println(strSplit[1][i]);
				strSplit[2] = CmnUtils.split(sbTbCmnt.toString(), lineSeparator);
				for(int i=0;i<strSplit[2].length;i++)if(!strSplit[2][i].trim().equals(""))pw[0].println(strSplit[2][i]);
				pw[0].close();
				pw[0] = null;
				CmnUtils.infoPrint(String.format("%1$-30s",tableName) + " ^f[^A[h܂B");
			}
			for(int i=1;i<4;i++)pw[i].close();
			for(int i=1;i<4;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Table Contents end

			// Index Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[TYPE_INDEX] + "_" + database + "." + cp.fileExtension));
			pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY]))));
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX]))));
			pw[3] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_PKEY]))));
			pw[4] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_UKEY]))));
			pw[5] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_INDEX]))));

			//Initial Process
			tableName = "";
			indexName = "";
			indexType = "";
			constraintType = "";
			colName = "";
			colPos = "";
			StringBuffer sbIxCnts = new StringBuffer();
			StringBuffer sbIx2Cnts = new StringBuffer();
			StringBuffer sbIx3Cnts = new StringBuffer();

			//Loop Process
			while((strLine=br[0].readLine()) != null){
				if(!strLine.equals("")){
					strSplit[0] = CmnUtils.split(strLine, cp.delimiter);
					//Not 1st Line Process
					if (!indexName.equals("")){
						if (!strSplit[0][1].equals(indexName)){
							//Post Process
							if (colPos.equals("1")){
								sbIxCnts.append(DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
								if (constraintType.equals("U"))sbIx2Cnts.append(DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
							} else {
								sbIxCnts.append(", " + DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
								if (constraintType.equals("U"))sbIx2Cnts.append(", " + DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
							}
							sbIxCnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
							sbIxCnts.append(lineSeparator);
							if (constraintType.equals("U"))sbIx2Cnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
							sbIx2Cnts.append(lineSeparator);
							sbIx3Cnts.append(lineSeparator);

							//Write Buffer
							if (constraintType.equals("P")){
								strSplit[1] = CmnUtils.split(sbIxCnts.toString(), lineSeparator);
								for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[0].println(strSplit[1][i]);
								strSplit[2] = CmnUtils.split(sbIx2Cnts.toString(), lineSeparator);
								for(int i=0;i<strSplit[2].length;i++)if(!strSplit[2][i].trim().equals(""))pw[3].println(strSplit[2][i]);
							} else if (constraintType.equals("U")){
								strSplit[1] = CmnUtils.split(sbIxCnts.toString(), lineSeparator);
								for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[1].println(strSplit[1][i]);
								strSplit[2] = CmnUtils.split(sbIx2Cnts.toString(), lineSeparator);
								for(int i=0;i<strSplit[2].length;i++)if(!strSplit[2][i].trim().equals(""))pw[4].println(strSplit[2][i]);
							} else if (constraintType.equals("")){
								strSplit[1] = CmnUtils.split(sbIxCnts.toString(), lineSeparator);
								for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[2].println(strSplit[1][i]);
							}
							strSplit[3] = CmnUtils.split(sbIx3Cnts.toString(), lineSeparator);
							for(int i=0;i<strSplit[3].length;i++)if(!strSplit[3][i].trim().equals(""))pw[5].println(strSplit[3][i]);

							//Initial Process
							sbIxCnts = new StringBuffer();
							sbIx2Cnts = new StringBuffer();
							sbIx3Cnts = new StringBuffer();

							//Index Changed Process
							if (strSplit[0][3].equals("P")){
								sbIxCnts.append("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ " ADD CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ " PRIMARY KEY(");
								sbIx2Cnts.append("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ " DROP CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
							} else if (strSplit[0][3].equals("U")){
								sbIxCnts.append("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ " ADD CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ " UNIQUE(");
								sbIx2Cnts.append("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ " DROP UNIQUE(");
							} else if (strSplit[0][3].equals("")){
								sbIxCnts.append("CREATE INDEX " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ " ON " + strSplit[0][0] + "(");
							}
							sbIx3Cnts.append("DROP INDEX " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
						} else if (strSplit[0][1].equals(indexName)){
							if (colPos.equals("1")){
								sbIxCnts.append(DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
								if (constraintType.equals("U"))sbIx2Cnts.append(DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
							} else {
								sbIxCnts.append(", " + DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
								if (constraintType.equals("U"))sbIx2Cnts.append(", " + DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
							}
						}
					}

					//1st Line Process
					else {
						if (strSplit[0][3].equals("P")){
							sbIxCnts.append("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ " ADD CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ " PRIMARY KEY(");
							sbIx2Cnts.append("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ " DROP CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
						} else if (strSplit[0][3].equals("U")){
							sbIxCnts.append("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ " ADD CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ " UNIQUE(");
							sbIx2Cnts.append("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ " DROP UNIQUE(");
						} else if (strSplit[0][3].equals("")){
							sbIxCnts.append("CREATE INDEX " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ " ON " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ "(");
						}
						sbIx3Cnts.append("DROP INDEX " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][1] + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
					}
					for(int i=0;i<strSplit[0].length;i++)CmnUtils.debugPrint("'" + strSplit[0][i] + "'");

					tableName = strSplit[0][0];
					indexName = strSplit[0][1];
					indexType = strSplit[0][2];
					constraintType = strSplit[0][3];
					colName = strSplit[0][4];
					colPos = strSplit[0][5];
				}
			}
			if (!indexName.equals("")){
				//Post Process
				if (colPos.equals("1")){
					sbIxCnts.append(DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
					if (constraintType.equals("U"))sbIx2Cnts.append(DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
				} else {
					sbIxCnts.append(", " + DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
					if (constraintType.equals("U"))sbIx2Cnts.append(", " + DB_SQL_QUOTED_S[cp.dbType]+ colName + DB_SQL_QUOTED_E[cp.dbType]);
				}
				sbIxCnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
				sbIxCnts.append(lineSeparator);
				if (constraintType.equals("U"))sbIx2Cnts.append(")" + cp.SQL_TERMINATOR[cp.dbType]);
				sbIx2Cnts.append(lineSeparator);
				sbIx3Cnts.append(lineSeparator);

				//Write Buffer
				if (constraintType.equals("P")){
					strSplit[1] = CmnUtils.split(sbIxCnts.toString(), lineSeparator);
					for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[0].println(strSplit[1][i]);
					strSplit[2] = CmnUtils.split(sbIx2Cnts.toString(), lineSeparator);
					for(int i=0;i<strSplit[2].length;i++)if(!strSplit[2][i].trim().equals(""))pw[3].println(strSplit[2][i]);
				} else if (constraintType.equals("U")){
					strSplit[1] = CmnUtils.split(sbIxCnts.toString(), lineSeparator);
					for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[1].println(strSplit[1][i]);
					strSplit[2] = CmnUtils.split(sbIx2Cnts.toString(), lineSeparator);
					for(int i=0;i<strSplit[2].length;i++)if(!strSplit[2][i].trim().equals(""))pw[4].println(strSplit[2][i]);
				} else if (constraintType.equals("")){
					strSplit[1] = CmnUtils.split(sbIxCnts.toString(), lineSeparator);
					for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[2].println(strSplit[1][i]);
				}
				strSplit[3] = CmnUtils.split(sbIx3Cnts.toString(), lineSeparator);
				for(int i=0;i<strSplit[3].length;i++)if(!strSplit[3][i].trim().equals(""))pw[5].println(strSplit[3][i]);
			}

			//Close Buffer
			for(int i=0;i<6;i++)pw[i].close();
			for(int i=0;i<6;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Index Contents end

			// View Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[TYPE_VIEW] + "_" + database + "." + cp.fileExtension));
			subFolder = new File(folder + "/VIEWS");
			subFolder.mkdir();
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_VIEW]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_VIEW]))));
			while((strLine=br[0].readLine()) != null){
				strSplit[0] = CmnUtils.split(strLine, cp.delimiter);
				CmnUtils.debugPrint("'" + strSplit[0][0] + "'");
				pw[1].println(cp.SQL_PREFIX[cp.dbType] + "VIEWS/" + strSplit[0][0] + ".sql");
				pw[2].println("DROP VIEW " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				if (strSplit[0].length>1)CmnUtils.debugPrint("'" + strSplit[0][1] + "'");
				pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + strSplit[0][0] + ".sql"))));
				
				stmt = dao.prepareSql(sql_view_column_and_comment[cp.dbType]);
				stmt.setString(1,strSplit[0][0]);
				dao.executeSql();
				alData = dao.getArrayList();
				columnCount = dao.getColumnCount();
				if (cp.dbType == cp.DB_TYPE_ORACLE){
					pw[0].println("/* " + strSplit[0][0] + " */");
					pw[0].println("CREATE OR REPLACE VIEW " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][0] + DB_SQL_QUOTED_E[cp.dbType]);
					pw[0].println("(");
					for(int i=0;i<alData.size();i++){
						if ((i+1) % columnCount == 1){
							if (i == 0){
								if (!alData.get(i+1).trim().equals("")){
									pw[0].println("    " + DB_SQL_QUOTED_S[cp.dbType]+ alData.get(i) + DB_SQL_QUOTED_E[cp.dbType]+ "    -- " + alData.get(i+1));
								} else {
									pw[0].println("    " + DB_SQL_QUOTED_S[cp.dbType]+ alData.get(i) + DB_SQL_QUOTED_E[cp.dbType]);
								}
							} else {
								if (!alData.get(i+1).trim().equals("")){
									pw[0].println("    ," + DB_SQL_QUOTED_S[cp.dbType]+ alData.get(i) + DB_SQL_QUOTED_E[cp.dbType]+ "    -- " + alData.get(i+1));
								} else {
									pw[0].println("    ," + DB_SQL_QUOTED_S[cp.dbType]+ alData.get(i) + DB_SQL_QUOTED_E[cp.dbType]);
								}
							}
						}
					}
					pw[0].println(")");
					pw[0].println("AS");
				}
				stmt = dao.prepareSql(sql_view_text[cp.dbType]);
				stmt.setString(1,strSplit[0][0]);
				dao.executeSql();
				alData2 = dao.getArrayList();
				strContents = alData2.get(0).trim();
				strSplit[1] = CmnUtils.split(strContents, lineSeparator);
				for(int i=0;i<strSplit[1].length;i++)if(!strSplit[1][i].trim().equals(""))pw[0].println(strSplit[1][i].replaceAll("\"\"","\"").replaceAll(Pattern.quote(cp.user.toUpperCase() + "."),"").replaceAll(Pattern.quote(cp.user.toLowerCase() + "."),""));
				pw[0].println(cp.SQL_TERMINATOR[cp.dbType]);

				if (!strSplit[0][1].trim().equals(""))pw[0].println(commentOnTable(cp, strSplit[0][0], strSplit[0][1], TYPE_VIEW));
				for(int i=0;i<alData.size();i++){
					if ((i+1) % columnCount == 0){
						if (!alData.get(i).trim().equals(""))pw[0].println(commentOnColumn(cp, strSplit[0][0], alData.get(i-1), alData.get(i), TYPE_VIEW));
					}
				}
				pw[0].close();
				pw[0] = null;
				CmnUtils.infoPrint(String.format("%1$-30s",strSplit[0][0]) + " ^f[^A[h܂B");
			}
			for(int i=1;i<3;i++)pw[i].close();
			for(int i=1;i<3;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// View Contents end

			// Procedure Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[TYPE_PROCEDURE] + "_" + database + "." + cp.fileExtension));
			subFolder = new File(folder + "/PROCEDURES");
			subFolder.mkdir();
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PROCEDURE]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_PROCEDURE]))));
			while((strLine=br[0].readLine()) != null){
				strSplit[0] = CmnUtils.split(strLine, cp.delimiter);
				CmnUtils.debugPrint("'" + strSplit[0][0] + "'");
				pw[1].println(cp.SQL_PREFIX[cp.dbType] + "PROCEDURES/" + strSplit[0][0] + ".sql");
				pw[2].println("DROP " + strSplit[0][1] + " " + strSplit[0][0] + cp.SQL_TERMINATOR[cp.dbType]);
				if (strSplit[0].length>1)CmnUtils.debugPrint("'" + strSplit[0][1] + "'");
				pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + strSplit[0][0] + ".sql"))));
				if (cp.dbType == cp.DB_TYPE_ORACLE){
					pw[0].println("/* " + strSplit[0][0] + " */");
					pw[0].print("CREATE OR REPLACE ");
				}
				stmt = dao.prepareSql(sql_proc[cp.dbType]);
				stmt.setString(1,strSplit[0][1]);
				stmt.setString(2,strSplit[0][0]);
				dao.executeSql();
				alData = dao.getArrayList();
				for(int i=0;i<alData.size();i++){
					strContents = alData.get(i);
					if(!strContents.equals(""))pw[0].println(strContents.replaceAll("\"\"","\"").replaceAll(Pattern.quote(cp.user.toUpperCase() + "."),"").replaceAll(Pattern.quote(cp.user.toLowerCase() + "."),""));
				}
				
				if (cp.dbType == cp.DB_TYPE_SQLSERVER){
					pw[0].println(cp.SQL_TERMINATOR[cp.dbType]);
					//pw[0].println("/");
				}
				pw[0].close();
				pw[0] = null;
				CmnUtils.infoPrint(String.format("%1$-30s",strSplit[0][0]) + " ^f[^A[h܂B");
			}
			for(int i=1;i<3;i++)pw[i].close();
			for(int i=1;i<3;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Procedure Contents end

			// Sequence Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[TYPE_SEQ] + "_" + database + "." + cp.fileExtension));
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_SEQUENCE]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_SEQUENCE]))));

			while((strLine=br[0].readLine()) != null){
				strSplit[0] = CmnUtils.split(strLine, cp.delimiter);
				seqName = strSplit[0][0];
				minVal = strSplit[0][1];
				maxVal = strSplit[0][2];
				incSz = strSplit[0][3];
				cycFg = strSplit[0][4];
				odFg = strSplit[0][5];
				cacheSz = strSplit[0][6];
				if(cacheSz.equals("0"))cacheSz="10";
				lstNo = strSplit[0][7];
				pw[1].print("CREATE SEQUENCE " + DB_SQL_QUOTED_S[cp.dbType]+ seqName + DB_SQL_QUOTED_E[cp.dbType]+ " MINVALUE " + minVal + " MAXVALUE " + maxVal + " INCREMENT BY " + incSz + " START WITH " + lstNo);
				if (cp.dbType == cp.DB_TYPE_ORACLE){
					pw[1].print(" CACHE " + cacheSz);
					if (odFg.equals("N")){
						pw[1].print(" NOORDER");
					} else {
						pw[1].print(" ORDER");
					}
					if (cycFg.equals("N")){
						pw[1].print(" NOCYCLE");
					} else {
						pw[1].print(" CYCLE");
					}
				} else if (cp.dbType == cp.DB_TYPE_SQLSERVER){
					if (cacheSz.equals("")){
						pw[1].print(" NO CACHE");
					} else {
						pw[1].print(" CACHE " + cacheSz);
					}
					if (cycFg.equals("N")){
						pw[1].print(" NO CYCLE");
					} else {
						pw[1].print(" CYCLE");
					}
				}
				pw[1].println(cp.SQL_TERMINATOR[cp.dbType]);
				pw[2].println("DROP SEQUENCE " + DB_SQL_QUOTED_S[cp.dbType]+ seqName + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				for(int i=0;i<strSplit[0].length;i++)CmnUtils.debugPrint("'" + strSplit[0][i] + "'");
			}
			for(int i=1;i<3;i++)pw[i].close();
			for(int i=1;i<3;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Sequence Contents end

			// Synonym Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[TYPE_SYNONYM] + "_" + database + "." + cp.fileExtension));
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_SYNONYM]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_SYNONYM]))));

			while((strLine=br[0].readLine()) != null){
				strSplit[0] = CmnUtils.split(strLine, cp.delimiter);
				synmName = strSplit[0][0];
				tbOwner = strSplit[0][1];
				tbName = strSplit[0][2];
				dbLnk = strSplit[0][3];
				
				pw[1].print("CREATE SYNONYM " + DB_SQL_QUOTED_S[cp.dbType]+ synmName + DB_SQL_QUOTED_E[cp.dbType]+ " FOR ");
				if(cp.dbType == cp.DB_TYPE_ORACLE){
					if(!dbLnk.equals("")){
						pw[1].print(DB_SQL_QUOTED_S[cp.dbType]+ tbName + DB_SQL_QUOTED_E[cp.dbType]+ "@" + DB_SQL_QUOTED_S[cp.dbType]+ dbLnk + DB_SQL_QUOTED_S[cp.dbType]);
					} else {
						pw[1].print(DB_SQL_QUOTED_S[cp.dbType]+ tbOwner + DB_SQL_QUOTED_E[cp.dbType]+ "." + DB_SQL_QUOTED_S[cp.dbType]+ tbName + DB_SQL_QUOTED_E[cp.dbType]);
					}
				} else if(cp.dbType == cp.DB_TYPE_SQLSERVER){
					pw[1].print(tbName);
				}
				pw[1].println(cp.SQL_TERMINATOR[cp.dbType]);
				pw[2].println("DROP SYNONYM " + DB_SQL_QUOTED_S[cp.dbType]+ synmName + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				for(int i=0;i<strSplit[0].length;i++)CmnUtils.debugPrint("'" + strSplit[0][i] + "'");
			}
			for(int i=1;i<3;i++)pw[i].close();
			for(int i=1;i<3;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Synonym Contents end

			// Fk Contents start
			File tsvFile = new File(folder + "/" + FILE_NAME[TYPE_FK] + "_" + database + "." + cp.fileExtension);
			if (tsvFile.length() > 0) {
				br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[TYPE_FK] + "_" + database + "." + cp.fileExtension));
				pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_FK]))));
				pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_FK]))));
				tbName = "";
				fkName = "";
				fkCol = "";
				fkColPos = "";
				rtbName = "";
				rfkCol = "";
				rfkColPos = "";
				
				while((strLine=br[0].readLine()) != null){
					strSplit[0] = CmnUtils.split(strLine, cp.delimiter);
					if(!fkName.equals(strSplit[0][1]) && !fkName.equals("")){
						pw[1].println("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ tbName + DB_SQL_QUOTED_E[cp.dbType]+ " ADD CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ fkName + DB_SQL_QUOTED_E[cp.dbType]+ " FOREIGN KEY (" + DB_SQL_QUOTED_S[cp.dbType]+ fkCol + DB_SQL_QUOTED_E[cp.dbType]+ ") REFERENCES " + DB_SQL_QUOTED_S[cp.dbType]+ rtbName + DB_SQL_QUOTED_E[cp.dbType]+ " (" + DB_SQL_QUOTED_S[cp.dbType]+ rfkCol + DB_SQL_QUOTED_E[cp.dbType]+ ")" + cp.SQL_TERMINATOR[cp.dbType]);
						pw[2].println("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ tbName + DB_SQL_QUOTED_E[cp.dbType]+ " DROP CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ fkName + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
						for(int i=0;i<strSplit[0].length;i++)CmnUtils.debugPrint("'" + strSplit[0][i] + "'");
						tbName = strSplit[0][0];
						fkName = strSplit[0][1];
						fkCol = strSplit[0][2];
						fkColPos = strSplit[0][3];
						rtbName = strSplit[0][4];
						rfkCol = strSplit[0][5];
						rfkColPos = strSplit[0][6];
					} else {
						if(fkName.equals("")){
							tbName = strSplit[0][0];
							fkName = strSplit[0][1];
							fkCol = strSplit[0][2];
							fkColPos = strSplit[0][3];
							rtbName = strSplit[0][4];
							rfkCol = strSplit[0][5];
							rfkColPos = strSplit[0][6];
						} else {
							if (
								(cp.dbType == cp.DB_TYPE_ORACLE && strSplit[0][3].equals(strSplit[0][6])) ||
								 cp.dbType != cp.DB_TYPE_ORACLE
							) {
								fkCol = fkCol + DB_SQL_QUOTED_E[cp.dbType]+ ", " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][2];
								rfkCol = rfkCol + DB_SQL_QUOTED_E[cp.dbType]+ ", " + DB_SQL_QUOTED_S[cp.dbType]+ strSplit[0][5];
							}
						}
					}
					
				}
				pw[1].println("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ tbName + DB_SQL_QUOTED_E[cp.dbType]+ " ADD CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ fkName + DB_SQL_QUOTED_E[cp.dbType]+ " FOREIGN KEY (" + DB_SQL_QUOTED_S[cp.dbType]+ fkCol + DB_SQL_QUOTED_E[cp.dbType]+ ") REFERENCES " + DB_SQL_QUOTED_S[cp.dbType]+ rtbName + DB_SQL_QUOTED_E[cp.dbType]+ " (" + DB_SQL_QUOTED_S[cp.dbType]+ rfkCol + DB_SQL_QUOTED_E[cp.dbType]+ ")" + cp.SQL_TERMINATOR[cp.dbType]);
				pw[2].println("ALTER TABLE " + DB_SQL_QUOTED_S[cp.dbType]+ tbName + DB_SQL_QUOTED_E[cp.dbType]+ " DROP CONSTRAINT " + DB_SQL_QUOTED_S[cp.dbType]+ fkName + DB_SQL_QUOTED_E[cp.dbType]+ cp.SQL_TERMINATOR[cp.dbType]);
				for(int i=1;i<3;i++)pw[i].close();
				for(int i=1;i<3;i++)pw[i]=null;
				br[0].close();
				br[0] = null;
			}
			// Fk Contents end

			// Rhysical Contents start
			if(cp.isPhysical && cp.dbType == cp.DB_TYPE_ORACLE){
				// physical index setting
				br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[TYPE_OBJ] + "_" + database + "." + cp.fileExtension));
				br[1] = new BufferedReader(new FileReader(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY]));
				br[2] = new BufferedReader(new FileReader(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY]));
				br[3] = new BufferedReader(new FileReader(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX]));
				pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY] + "." + phyfileExtension))));
				pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY] + "." + phyfileExtension))));
				pw[3] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX] + "." + phyfileExtension))));
				alData = new ArrayList<String>();
				int rowNo;
				String [] rowData;
				while((strLine=br[0].readLine()) != null){
					strSplit[0] = CmnUtils.split(strLine, cp.delimiter);
					for(int i=0;i<strSplit[0].length;i++)alData.add(strSplit[0][i]);
				}
				while((strLine=br[1].readLine()) != null){
					strSplit[0] = CmnUtils.splitSpace(strLine);
					rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, strSplit[0][5].replaceAll("\"",""));
					if (rowNo != -1){
						rowData = rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
						CmnUtils.debugPrint(strSplit[0][5] + ":" + rowNo);
						for(int i=0;i<rowData.length;i++)CmnUtils.debugPrint(rowData[i]);
						tbName = rowData[0];
						objName = rowData[1];
						objTyp = rowData[2];
						pctFree = rowData[3];
						pctUsed = rowData[4];
						iniTrns = rowData[5];
						freeLst = rowData[6];
						flstGrp = rowData[7];
						bufPool = rowData[8];
						tblSpace = rowData[9];
						logging = rowData[10];
						segByts = rowData[11];
						pw[1].print(strLine.replace(';',' '));
						pw[1].print("USING INDEX PCTFREE " + pctFree);
						pw[1].print(" INITRANS " + iniTrns + " STORAGE(");
						if(!freeLst.equals(""))pw[1].print(" FREELISTS " + freeLst);
						if(!flstGrp.equals(""))pw[1].print(" FREELIST GROUPS " + flstGrp);
						pw[1].print(" BUFFER_POOL " + bufPool + ")");
						pw[1].print(" TABLESPACE " + DB_SQL_QUOTED_S[cp.dbType]+ tblSpace + DB_SQL_QUOTED_E[cp.dbType]);
						if(logging.equals("NO")){
							pw[1].println(" NOLOGGING" + cp.SQL_TERMINATOR[cp.dbType]);
						} else {
							pw[1].println(cp.SQL_TERMINATOR[cp.dbType]);
						}
					} else {
						pw[1].println(strLine);
						CmnUtils.errorPrint(strSplit[0][5] + ",UNUSABLE INDEX");
					}
				}
				while((strLine=br[2].readLine()) != null){
					strSplit[0] = CmnUtils.splitSpace(strLine);
					rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, strSplit[0][5].replaceAll("\"",""));
					if (rowNo != -1){
						rowData = rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
						CmnUtils.debugPrint(strSplit[0][5] + ":" + rowNo);
						for(int i=0;i<rowData.length;i++)CmnUtils.debugPrint(rowData[i]);
						tbName = rowData[0];
						objName = rowData[1];
						objTyp = rowData[2];
						pctFree = rowData[3];
						pctUsed = rowData[4];
						iniTrns = rowData[5];
						freeLst = rowData[6];
						flstGrp = rowData[7];
						bufPool = rowData[8];
						tblSpace = rowData[9];
						logging = rowData[10];
						segByts = rowData[11];
						pw[2].print(strLine.replace(';',' '));
						pw[2].print("USING INDEX PCTFREE " + pctFree);
						pw[2].print(" INITRANS " + iniTrns + " STORAGE(");
						if(!freeLst.equals(""))pw[2].print(" FREELISTS " + freeLst);
						if(!flstGrp.equals(""))pw[2].print(" FREELIST GROUPS " + flstGrp);
						pw[2].print(" BUFFER_POOL " + bufPool + ")");
						pw[2].print(" TABLESPACE " + DB_SQL_QUOTED_S[cp.dbType]+ tblSpace + DB_SQL_QUOTED_E[cp.dbType]);
						if(logging.equals("NO")){
							pw[2].println(" NOLOGGING" + cp.SQL_TERMINATOR[cp.dbType]);
						} else {
							pw[2].println(cp.SQL_TERMINATOR[cp.dbType]);
						}
					} else {
						pw[2].println(strLine);
						CmnUtils.errorPrint(strSplit[0][5] + ",UNUSABLE INDEX");
					}
				}
				while((strLine=br[3].readLine()) != null){
					strSplit[0] = CmnUtils.splitSpace(strLine);
					rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, strSplit[0][2].replaceAll("\"",""));
					CmnUtils.debugPrint("rowNo=" + rowNo);
					if (rowNo != -1){
						rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
						for(int i=0;i<rowData.length;i++)CmnUtils.debugPrint(rowData[i]);
						tbName = rowData[0];
						objName = rowData[1];
						objTyp = rowData[2];
						pctFree = rowData[3];
						pctUsed = rowData[4];
						iniTrns = rowData[5];
						freeLst = rowData[6];
						flstGrp = rowData[7];
						bufPool = rowData[8];
						tblSpace = rowData[9];
						logging = rowData[10];
						segByts = rowData[11];
						pw[3].print(strLine.replace(';',' '));
						pw[3].print("PCTFREE " + pctFree);
						pw[3].print(" INITRANS " + iniTrns + " STORAGE(");
						if(!freeLst.equals(""))pw[3].print(" FREELISTS " + freeLst);
						if(!flstGrp.equals(""))pw[3].print(" FREELIST GROUPS " + flstGrp);
						pw[3].print(" BUFFER_POOL " + bufPool + ")");
						pw[3].print(" TABLESPACE " + DB_SQL_QUOTED_S[cp.dbType]+ tblSpace + DB_SQL_QUOTED_E[cp.dbType]);
						if(logging.equals("NO")){
							pw[3].println(" NOLOGGING" + cp.SQL_TERMINATOR[cp.dbType]);
						} else {
							pw[3].println(cp.SQL_TERMINATOR[cp.dbType]);
						}
					} else {
						pw[3].println(strLine);
						CmnUtils.errorPrint(strSplit[0][2] + ",UNUSABLE INDEX");
					}
				}
				for(int i=1;i<4;i++)pw[i].close();
				for(int i=1;i<4;i++)pw[i]=null;
				for(int i=0;i<4;i++)br[i].close();
				for(int i=0;i<4;i++)br[i]=null;
				
				File [] fmFl = new File[6];
				File [] toFl = new File[6];
				
				fmFl[0] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY] + "." + phyfileExtension);
				fmFl[1] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY] + "." + phyfileExtension);
				fmFl[2] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX] + "." + phyfileExtension);
				toFl[0] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY]);
				toFl[1] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY]);
				toFl[2] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX]);
				for(int i=0;i<3;i++){
					CmnUtils.debugPrint(fmFl[i].toString() + ">" + toFl[i].toString());
					toFl[i].delete();
					fmFl[i].renameTo(toFl[i]);
				}
				
				// physical table setting
				File tbDir = new File(folder + "/TABLES");
				File [] tbFiles = tbDir.listFiles();
				File tb = null;
				File oTb = null;
				for(int i=0;i<tbFiles.length;i++){
					tb = tbFiles[i];
					tbName = tb.getName().replaceAll(".sql","");
					oTb = new File(tb + "." + phyfileExtension);
					CmnUtils.debugPrint(tbName);
					br[0] = new BufferedReader(new FileReader(tb));
					pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(oTb)));
					while((strLine=br[0].readLine()) != null){
						if(strLine.equals(")" + cp.SQL_TERMINATOR[cp.dbType])){
							rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, tbName);
							if (rowNo != -1){
								rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
								CmnUtils.debugPrint(tbName + ":" + rowNo);
								//for(int j=0;j<rowData.length;i++)CmnUtils.debugPrint(rowData[j]);
								tbName = rowData[0];
								objName = rowData[1];
								objTyp = rowData[2];
								pctFree = rowData[3];
								pctUsed = rowData[4];
								iniTrns = rowData[5];
								freeLst = rowData[6];
								flstGrp = rowData[7];
								bufPool = rowData[8];
								tblSpace = rowData[9];
								logging = rowData[10];
								segByts = rowData[11];
								pw[0].print(") PCTFREE " + pctFree);
								if(!pctUsed.equals(""))pw[0].print(" PCTUSED " + pctUsed);
								pw[0].print(" INITRANS " + iniTrns + " STORAGE(");
								if(!freeLst.equals(""))pw[0].print(" FREELISTS " + freeLst);
								if(!flstGrp.equals(""))pw[0].print(" FREELIST GROUPS " + flstGrp);
								pw[0].print(" BUFFER_POOL " + bufPool + ")");
								pw[0].print(" TABLESPACE " + DB_SQL_QUOTED_S[cp.dbType]+ tblSpace + DB_SQL_QUOTED_E[cp.dbType]);
								if(logging.equals("NO")){
									pw[0].println(" NOLOGGING" + cp.SQL_TERMINATOR[cp.dbType]);
								} else {
									pw[0].println(cp.SQL_TERMINATOR[cp.dbType]);
								}
							} else {
								pw[0].println(")" + cp.SQL_TERMINATOR[cp.dbType]);
							}
						} else {
							pw[0].println(strLine);
						}
					}
					pw[0].close();
					pw[0]=null;
					br[0].close();
					br[0]=null;
					tb.delete();
					oTb.renameTo(tb);
				}
			}
			// Rhysical Contents end

			// Remove work file
			File fl= null;
			for(int i=0;i<sql[cp.dbType].length;i++){
				fl= new File(folder + "/" + FILE_NAME[i] + "_" + database + "." + cp.fileExtension);
				CmnUtils.debugPrint(fl.toString());
				fl.delete();
			}

			// disconnect database
			dao.disconnect();
			CmnUtils.infoPrint("^f[^A[hI܂B");

		} catch(SQLException se) {
			try{
				CmnUtils.errorPrint(se.toString());
				se.printStackTrace();
				se = se.getNextException();
				if(se != null) {
					System.out.println(se.getMessage());
				}
				dao.rollback();
			} catch (Exception see) {}
		} catch (Exception e) {			
			try{
				CmnUtils.errorPrint(e.toString());
				e.printStackTrace();
				dao.rollback();
			} catch (Exception ee) {}
		} finally{
			try{
				for(int i=0;i<6;i++){
					if(pw[i]!=null){
						pw[i].close();
						pw[i]=null;
					}
				}
				for(int i=0;i<4;i++){
					if(br[i]!=null){
						br[i].close();
						br[i]=null;
					}
				}
			} catch (Exception e) {}
		}
	}
	
	private String commentOnTable(CmnProps _cp, String _tableName, String _tableCmnt, int _type) throws Exception{
		String retVal = "";
		if(!_tableCmnt.equals("")){
			switch (_cp.dbType) {
			  case DB_TYPE_ORACLE:
				retVal = "COMMENT ON TABLE " + DB_SQL_QUOTED_S[_cp.dbType]+ _tableName + DB_SQL_QUOTED_E[_cp.dbType]+ " IS '" + _tableCmnt.replaceAll("'","''") + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
			    break;
			  case DB_TYPE_SQLSERVER:
				if(_type == TYPE_TABLE){
					retVal = "exec sys.sp_addextendedproperty @name=N'MS_Description',@value=N'" + _tableCmnt.replaceAll("'","''") + "',@level0type=N'schema',@level0name=N'dbo',@level1type=N'table',@level1name=N'" + _tableName + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
				} else if(_type == TYPE_VIEW){
					retVal = "exec sys.sp_addextendedproperty @name=N'MS_Description',@value=N'" + _tableCmnt.replaceAll("'","''") + "',@level0type=N'schema',@level0name=N'dbo',@level1type=N'view',@level1name=N'" + _tableName + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
				}
				break;
			  default :
			}
		}
		return retVal;
	}
	private String commentOnColumn(CmnProps _cp, String _tableName, String _colName, String _colCmnt, int _type) throws Exception{
		String retVal = "";
		if(!_colCmnt.equals("")){
			switch (_cp.dbType) {
			  case DB_TYPE_ORACLE:
				retVal = "COMMENT ON COLUMN " + DB_SQL_QUOTED_S[_cp.dbType]+ _tableName + DB_SQL_QUOTED_E[_cp.dbType]+ "." + DB_SQL_QUOTED_S[_cp.dbType]+ _colName + DB_SQL_QUOTED_E[_cp.dbType]+ " IS '" + _colCmnt.replaceAll("'","''") + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
			    break;
			  case DB_TYPE_SQLSERVER:
				if(_type == TYPE_TABLE){
					retVal = "exec sys.sp_addextendedproperty @name=N'MS_Description',@value=N'" + _colCmnt.replaceAll("'","''") + "',@level0type=N'schema',@level0name=N'dbo',@level1type=N'table',@level1name=N'" + _tableName + "',@level2type=N'column',@level2name=N'" + _colName + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
				} else if(_type == TYPE_VIEW){
					retVal = "exec sys.sp_addextendedproperty @name=N'MS_Description',@value=N'" + _colCmnt.replaceAll("'","''") + "',@level0type=N'schema',@level0name=N'dbo',@level1type=N'view',@level1name=N'" + _tableName + "',@level2type=N'column',@level2name=N'" + _colName + "'" + _cp.SQL_TERMINATOR[_cp.dbType];
				}
			    break;
			  default :
			}
		}
		return retVal;
	}
}

