package com.rapide_act;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.sql.Blob;
import java.sql.Clob;

public class RapideMetaUnloader{

	private static final int FL_TABLE = 0;
	private static final int FL_INDEX = 1;
	private static final int FL_VIEW = 2;
	private static final int FL_PROCEDURE = 3;
	private static final int FL_SEQ = 4;
	private static final int FL_SYNONYM = 5;
	private static final int FL_OBJ = 6;
	private static final int FL_FK = 7;
	private static final String [] FILE_NAME = {
		"TABLEDEF",
		"INDEXDEF",
		"VIEWDEF",
		"PROCDEF",
		"SEQDEF",
		"SYNMDEF",
		"OBJDEF",
		"FKDEF"
	};
	private static final String [] sql = {
	"select "
	     + "a.table_name as table_name,"
	     + "replace(replace(b.comments, chr(13), ''), chr(10), '') as table_comments,"
	     + "c.column_name as column_name, "
	     + "replace(replace(d.comments, chr(13), ''), chr(10), '') as column_comments, "
	     + "decode(c.data_type, 'TIMESTAMP(6)', 'TIMESTAMP',c.data_type) as data_type,"
	     + "decode(c.data_type, 'NUMBER', c.data_precision, 'TIMESTAMP(6)', null, c.data_length) as data_length,"
	     + "c.data_scale as data_scale,"
	     + "decode(c.nullable, 'N', '', null) as nullable,"
	     + "c.data_default as data_default "
	     + "from user_tables a "
	     + "inner join user_tab_comments b "
	     + "on a.table_name = b.table_name "
	     + "inner join user_tab_columns c "
	     + "on a.table_name = c.table_name "
	     + "inner join user_col_comments d "
	     + "on c.table_name = d.table_name "
	     + " and c.column_name = d.column_name "
	     + "order by a.table_name,c.column_id",
	"select "
	     + " a.table_name,"
	     + " a.index_name,"
	     + " a.index_type,"
	     + " c.constraint_type,"
	     + " b.column_name,"
	     + " b.column_position "
	     + " from"
	     + " user_indexes a,"
	     + " user_ind_columns b,"
	     + " user_constraints c "
	     + " where"
	     + "  a.table_name = b.table_name and"
	     + "  a.index_name = b.index_name and"
	     + "  a.table_name = c.table_name(+) and"
	     + "  a.index_name = c.constraint_name(+) "
	     + " order by"
	     + " a.table_name,"
	     + " a.index_name,"
	     + " b.column_position",
	"select "
	     + " a.view_name, "
	     + " replace(replace(c.comments, chr(13), ''), chr(10), '') as comments "
	     + " from"
	     + " user_views a, "
	     + " user_tab_comments c "
	     + " where"
		+ "  a.view_name = c.table_name(+) "
	     + " order by"
	     + " a.view_name",
	"select "
	     + " object_name, "
	     + " object_type "
	     + "from"
	     + " user_objects"
	     + " where object_type in('PACKAGE','PROCEDURE','FUNCTION','TRIGGER','TYPE')"
	     + " group by object_name,object_type"
	     + " order by object_name,object_type",
	"select "
	     + "  sequence_name,"
	     + "  to_char(min_value) as min_value,"
	     + "  to_char(max_value) as max_value,"
	     + "  to_char(increment_by) as increment_by,"
	     + "  cycle_flag,"
	     + "  order_flag,"
	     + "  to_char(cache_size) as cache_size,"
	     + "  to_char(last_number) as last_number "
	     + " from user_sequences "
	     + " order by sequence_name",
	"select "
	     + "  synonym_name,"
	     + "  table_owner,"
	     + "  table_name,"
	     + "  db_link "
	     + "from user_synonyms "
	     + "order by synonym_name,table_owner,table_name",
	"select "
	     + " a.table_name,"
	     + " a.object_name,"
	     + " a.object_type,"
	     + " a.pct_free,"
	     + " a.pct_used,"
	     + " a.ini_trans,"
	     + " a.freelists,"
	     + " a.freelist_groups,"
	     + " a.buffer_pool,"
	     + " a.tablespace_name, "
	     + " a.logging, "
	     + " b.bytes "
	     + "from "
	     + "(select "
	     + " table_name,"
	     + " table_name as object_name,"
	     + " 'TABLE' as object_type,"
	     + " pct_free,"
	     + " pct_used,"
	     + " ini_trans,"
	     + " freelists,"
	     + " freelist_groups,"
	     + " buffer_pool,"
	     + " tablespace_name, "
	     + " logging "
	     + "from "
	     + " user_tables "
	     + " union select "
	     + " table_name,"
	     + " index_name as object_name,"
	     + " 'INDEX' as object_type,"
	     + " pct_free,"
	     + " null as pct_used,"
	     + " ini_trans,"
	     + " freelists,"
	     + " freelist_groups,"
	     + " buffer_pool,"
	     + " tablespace_name, "
	     + " logging "
	     + " from "
	     + " user_indexes "
	     + ") a, "
	     + "(select "
	     + " segment_name,"
	     + " segment_type,"
	     + " bytes "
	     + " from "
	     + " user_segments "
	     + ") b "
	     + " where a.object_name = b.segment_name "
	     + " and a.object_type = b.segment_type "
	     + " order by"
	     + " a.table_name,"
	     + " a.object_name",
	"select "
	     + " a.table_name as table_name, "
	     + " a.constraint_name as constraint_name, "
	     + " b.column_name as column_name, "
	     + " b.position as position,"
	     + " c.table_name as r_table_name, "
	     + " c.constraint_name as r_constraint_name, "
	     + " d.column_name as r_column_name, "
	     + " d.position as r_position "
	     + " from "
	     + "   user_constraints a, "
	     + "   user_cons_columns b,"
	     + "   user_constraints c, "
	     + "   user_cons_columns d "
	     + " where "
	     + "   a.constraint_type = 'R'"
	     + "   and a.owner = b.owner"
	     + "   and a.table_name = b.table_name"
	     + "   and a.constraint_name = b.constraint_name"
	     + "   and c.constraint_type in('P','U')"
	     + "   and c.owner = b.owner"
	     + "   and c.table_name = d.table_name"
	     + "   and c.constraint_name = d.constraint_name"
	     + "   and a.r_owner = c.owner"
	     + "   and a.r_constraint_name = c.constraint_name"
	     + " order by"
	     + "   a.table_name,a.constraint_name,b.position,d.position"
	};
	private static String sql_view_text = "select text from user_views where view_name = ?";
	private static String sql_view_column_and_comment = "select "
	     + " b.column_name,"
	     + " replace(replace(d.comments, chr(13), ''), chr(10), '') as comments "
	     + " from"
	     + " user_tab_columns b,"
	     + " user_col_comments d "
	     + " where"
	     + "  b.table_name = ? and"
	     + "  b.table_name = d.table_name(+) and"
	     + "  b.column_name = d.column_name(+) "
	     + " order by"
	     + " b.column_id";
	private static String sql_proc = "select text from user_source where name = ? order by line";

	private String database = null;

	public static void main(String args[]){
		try {
			if (args.length > 0){
				RapideMetaUnloader RapideMetaUnloader = new RapideMetaUnloader(args[0]);
				RapideMetaUnloader.metaUnload();
			} else {
				RapideMetaUnloader RapideMetaUnloader = new RapideMetaUnloader(null);
				RapideMetaUnloader.metaUnload();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	RapideMetaUnloader(String _database) {
		super();
		database = _database;
	}


	private void metaUnload(){
		Connection conn = null;
		PreparedStatement stmt = null;
		BufferedReader [] br = new BufferedReader[4];
		PrintWriter [] pw = new PrintWriter[6];
		File folder = null;
		File subFolder = null;
		String strLine = null;
		String strLine2 = null;
		String [] strSplit = null;
		String [] strSplit2 = null;
		String [] strSplit3 = null;
		String [] strSplit4 = null;
		String strContents = null;
		ArrayList<String> alData = null;
		ArrayList<String> alData2 = null;
		int columnCount = 0;
		String tableName = null;
		String tableCmnt = null;
		String colName = null;
		String colCmnt = null;
		String colType = null;
		String colLen = null;
		String colDec = null;
		String colNoN = null;
		String colDflt = null;
		String indexName = null;
		String indexType = null;
		String constraintType = null;
		String colPos = null;
		String seqName = null;
		String minVal = null;
		String maxVal = null;
		String incSz = null;
		String cycFg = null;
		String odFg = null;
		String cacheSz = null;
		String lstNo = null;
		String synmOwner = null;
		String synmName = null;
		String tbOwner = null;
		String tbName = null;
		String dbLnk = null;
		String userName = null;
		String passWord = null;
		String host = null;
		String created = null;
		String acStat = null;
		String defTbsp = null;
		String tmpTbsp = null;
		String grntee = null;
		String grntor = null;
		String grntrl = null;
		String prvs = null;
		String grntabl = null;
		String hrchy = null;

		String objName = null;
		String objTyp = null;
		String pctFree = null;
		String pctUsed = null;
		String iniTrns = null;
		String freeLst = null;
		String flstGrp = null;
		String bufPool = null;
		String tblSpace = null;
		String logging = null;
		String segByts = null;

		String fkName = null;
		String fkCol = null;
		String fkColPos = null;
		String rtbName = null;
		String rfkName = null;
		String rfkCol = null;
		String rfkColPos = null;

		CmnProperty cp = null;
		DataAccessObjects dao = null;
		
		try {
			cp = new CmnProperty();
			cp.setProperty(database);
			
			if (cp.dbType != cp.DB_TYPE_ORACLE){
				throw new Exception("f[^x[XΏۊOłB[" + cp.DB_TYPE_NAME[cp.dbType] + "]");
			}
			if(cp.outFolder != null){
				folder = new File(cp.outFolder);
			} else {
				if(database != null){
					folder = new File(cp.DEFAULT_OUT_FOLDER + "/DDL_" + database.toUpperCase() + "_" + CmnUtils.getYmdhm());
				} else {
					folder = new File(cp.DEFAULT_OUT_FOLDER + "/DDL_" + cp.DB_TYPE_NAME[cp.dbType].toUpperCase() + "_" + CmnUtils.getYmdhm());
				}
				folder.mkdir();
			}

			CmnUtils.infoPrint("-->o͐tH_='" + folder + "'");
			CmnUtils.infoPrint("^f[^A[hJn܂B");

			// Connect
			dao = new DataAccessObjects(cp);
			conn = dao.connect();
			// Def Csv Writing start
			for(int i=0;i<sql.length;i++){
				dao.select(sql[i]);
				CmnUtils.writeCsv(folder + "/" + FILE_NAME[i] + "_" + database +".csv", dao.getColumnCount(), dao.getArrayList());
			}
			// Def Csv Writing end

			// Table Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[FL_TABLE] + "_" + database +".csv"));
			subFolder = new File(folder + "/TABLES");
			subFolder.mkdir();
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_TABLE]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_TABLE]))));
			pw[3] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.TRUNCATE_TABLE]))));

			tableName = "";
			tableCmnt = "";
			colName = "";
			colCmnt = "";
			colType = "";
			colLen = "";
			colDec = "";
			colNoN = "";
			colDflt = "";

			StringBuffer sbTbCnts = new StringBuffer();
			StringBuffer sbTbCmnt = new StringBuffer();
			while((strLine=br[0].readLine()) != null){
				if(!strLine.equals("")){
					strSplit = CmnUtils.splitCsv(strLine);
					if (!tableName.equals("")){
						sbTbCnts.append("    " + cp.sqlQuoted + colName + cp.sqlQuoted);
						sbTbCnts.append(" " + colType);
						if(!colCmnt.equals(""))sbTbCmnt.append("COMMENT ON COLUMN " + cp.sqlQuoted + tableName + cp.sqlQuoted + "." + cp.sqlQuoted + colName + cp.sqlQuoted + " IS '" + colCmnt + "';");
						if(!colCmnt.equals(""))sbTbCmnt.append(cp.lineSeparator);
						if (!colType.equals("BLOB") && !colType.equals("CLOB") && !colType.equals("TIMESTAMP") && !colType.equals("DATE") && !colType.equals("LONG") && !colType.equals("LONG RAW")){
							if (!colLen.equals(""))sbTbCnts.append("(" + colLen);
							if (!colLen.equals("") && !colDec.equals(""))sbTbCnts.append("," + colDec);
							if (!colLen.equals(""))sbTbCnts.append(")");
						}
						if (!colDflt.equals(""))sbTbCnts.append(" DEFAULT " + colDflt.trim());
						if (colNoN.equals(""))sbTbCnts.append(" NOT NULL");
						if (!strSplit[0].equals(tableName)){
							pw[1].println("@TABLES/" + tableName + ".sql");
							pw[2].println("DROP TABLE " + cp.sqlQuoted + tableName + cp.sqlQuoted + " PURGE;");
							pw[3].println("TRUNCATE TABLE " + cp.sqlQuoted + tableName + cp.sqlQuoted + ";");
							sbTbCnts.append(cp.lineSeparator);
							sbTbCnts.append(");");
							sbTbCnts.append(cp.lineSeparator);
							pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + tableName + ".sql"))));
							strSplit2 = CmnUtils.splitCrLf(sbTbCnts.toString());
							for(int i=0;i<strSplit2.length;i++)if(!strSplit2[i].trim().equals(""))pw[0].println(strSplit2[i]);
							strSplit3 = CmnUtils.splitCrLf(sbTbCmnt.toString());
							for(int i=0;i<strSplit3.length;i++)if(!strSplit3[i].trim().equals(""))pw[0].println(strSplit3[i]);
							pw[0].close();
							pw[0] = null;
							sbTbCnts = new StringBuffer();
							sbTbCmnt = new StringBuffer();
							sbTbCnts.append("CREATE TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted);
							sbTbCnts.append(cp.lineSeparator);
							sbTbCnts.append("(");
							sbTbCnts.append(cp.lineSeparator);
							if(!strSplit[1].equals(""))sbTbCmnt.append("COMMENT ON TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " IS '" + strSplit[1] +"';");
							if(!strSplit[1].equals(""))sbTbCmnt.append(cp.lineSeparator);
						} else {
							sbTbCnts.append(",");
							sbTbCnts.append(cp.lineSeparator);
						}
					}
					else {
						sbTbCnts.append("CREATE TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted);
						sbTbCnts.append(cp.lineSeparator);
						sbTbCnts.append("(");
						sbTbCnts.append(cp.lineSeparator);
						if(!strSplit[1].equals(""))sbTbCmnt.append("COMMENT ON TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " IS '" + strSplit[1] +"';");
						if(!strSplit[1].equals(""))sbTbCmnt.append(cp.lineSeparator);
					}
					for(int i=0;i<strSplit.length;i++)CmnUtils.debugPrint("'" + strSplit[i] + "'");

					tableName = strSplit[0];
					tableCmnt = strSplit[1];
					colName = strSplit[2];
					colCmnt = strSplit[3];
					colType = strSplit[4];
					colLen = strSplit[5];
					colDec = strSplit[6];
					colNoN = strSplit[7];
					colDflt = strSplit[8];
				}
			}

			if (!tableName.equals("")){
				sbTbCnts.append("    " + cp.sqlQuoted + colName + cp.sqlQuoted);
				sbTbCnts.append(" " + colType);
				if(!colCmnt.equals(""))sbTbCmnt.append("COMMENT ON COLUMN " + cp.sqlQuoted + tableName + cp.sqlQuoted + "." + cp.sqlQuoted + colName + cp.sqlQuoted + " IS '" + colCmnt + "';");
				if(!colCmnt.equals(""))sbTbCmnt.append(cp.lineSeparator);
				if (!colType.equals("BLOB") && !colType.equals("TIMESTAMP") && !colType.equals("DATE") && !colType.equals("LONG") && !colType.equals("LONG RAW")){
					if (!colLen.equals(""))sbTbCnts.append("(" + colLen);
					if (!colDec.equals(""))sbTbCnts.append("," + colDec);
					if (!colLen.equals(""))sbTbCnts.append(")");
				}
				if (!colDflt.equals(""))sbTbCnts.append(" DEFAULT " + colDflt.trim());
				if (colNoN.equals(""))sbTbCnts.append(" NOT NULL");
				pw[1].println("@TABLES/" + tableName + ".sql");
				pw[2].println("DROP TABLE " + cp.sqlQuoted + tableName + cp.sqlQuoted + " PURGE;");
				pw[3].println("TRUNCATE TABLE " + cp.sqlQuoted + tableName + cp.sqlQuoted + ";");
				sbTbCnts.append(cp.lineSeparator);
				sbTbCnts.append(");");
				sbTbCnts.append(cp.lineSeparator);
				pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + tableName + ".sql"))));
				strSplit2 = CmnUtils.splitCrLf(sbTbCnts.toString());
				for(int i=0;i<strSplit2.length;i++)if(!strSplit2[i].trim().equals(""))pw[0].println(strSplit2[i]);
				strSplit3 = CmnUtils.splitCrLf(sbTbCmnt.toString());
				for(int i=0;i<strSplit3.length;i++)if(!strSplit3[i].trim().equals(""))pw[0].println(strSplit3[i]);
				pw[0].close();
				pw[0] = null;
			}
			for(int i=1;i<4;i++)pw[i].close();
			for(int i=1;i<4;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Table Contents end

			// Index Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[FL_INDEX] + "_" + database +".csv"));
			pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY]))));
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX]))));
			pw[3] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_PKEY]))));
			pw[4] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_UKEY]))));
			pw[5] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_INDEX]))));

			//Initial Process
			tableName = "";
			indexName = "";
			indexType = "";
			constraintType = "";
			colName = "";
			colPos = "";
			StringBuffer sbIxCnts = new StringBuffer();
			StringBuffer sbIx2Cnts = new StringBuffer();
			StringBuffer sbIx3Cnts = new StringBuffer();

			//Loop Process
			while((strLine=br[0].readLine()) != null){
				if(!strLine.equals("")){
					strSplit = CmnUtils.splitCsv(strLine);
					//Not 1st Line Process
					if (!indexName.equals("")){
						if (!strSplit[1].equals(indexName)){
							//Post Process
							if (colPos.equals("1")){
								sbIxCnts.append(cp.sqlQuoted + colName + cp.sqlQuoted);
								if (constraintType.equals("U"))sbIx2Cnts.append(cp.sqlQuoted + colName + cp.sqlQuoted);
							} else {
								sbIxCnts.append(", " + cp.sqlQuoted + colName + cp.sqlQuoted);
								if (constraintType.equals("U"))sbIx2Cnts.append(", " + cp.sqlQuoted + colName + cp.sqlQuoted);
							}
							sbIxCnts.append(");");
							sbIxCnts.append(cp.lineSeparator);
							if (constraintType.equals("U"))sbIx2Cnts.append(");");
							sbIx2Cnts.append(cp.lineSeparator);
							sbIx3Cnts.append(cp.lineSeparator);

							//Write Buffer
							if (constraintType.equals("P")){
								strSplit2 = CmnUtils.splitCrLf(sbIxCnts.toString());
								for(int i=0;i<strSplit2.length;i++)if(!strSplit2[i].trim().equals(""))pw[0].println(strSplit2[i]);
								strSplit3 = CmnUtils.splitCrLf(sbIx2Cnts.toString());
								for(int i=0;i<strSplit3.length;i++)if(!strSplit3[i].trim().equals(""))pw[3].println(strSplit3[i]);
							} else if (constraintType.equals("U")){
								strSplit2 = CmnUtils.splitCrLf(sbIxCnts.toString());
								for(int i=0;i<strSplit2.length;i++)if(!strSplit2[i].trim().equals(""))pw[1].println(strSplit2[i]);
								strSplit3 = CmnUtils.splitCrLf(sbIx2Cnts.toString());
								for(int i=0;i<strSplit3.length;i++)if(!strSplit3[i].trim().equals(""))pw[4].println(strSplit3[i]);
							} else if (constraintType.equals("")){
								strSplit2 = CmnUtils.splitCrLf(sbIxCnts.toString());
								for(int i=0;i<strSplit2.length;i++)if(!strSplit2[i].trim().equals(""))pw[2].println(strSplit2[i]);
							}
							strSplit4 = CmnUtils.splitCrLf(sbIx3Cnts.toString());
							for(int i=0;i<strSplit4.length;i++)if(!strSplit4[i].trim().equals(""))pw[5].println(strSplit4[i]);

							//Initial Process
							sbIxCnts = new StringBuffer();
							sbIx2Cnts = new StringBuffer();
							sbIx3Cnts = new StringBuffer();

							//Index Changed Process
							if (strSplit[3].equals("P")){
								sbIxCnts.append("ALTER TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " ADD CONSTRAINT " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + " PRIMARY KEY(");
								sbIx2Cnts.append("ALTER TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " DROP CONSTRAINT " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + ";");
							} else if (strSplit[3].equals("U")){
								sbIxCnts.append("ALTER TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " ADD CONSTRAINT " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + " UNIQUE(");
								sbIx2Cnts.append("ALTER TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " DROP UNIQUE(");
							} else if (strSplit[3].equals("")){
								sbIxCnts.append("CREATE INDEX " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + " ON " + strSplit[0] + "(");
							}
							sbIx3Cnts.append("DROP INDEX " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + ";");
						} else if (strSplit[1].equals(indexName)){
							if (colPos.equals("1")){
								sbIxCnts.append(cp.sqlQuoted + colName + cp.sqlQuoted);
								if (constraintType.equals("U"))sbIx2Cnts.append(cp.sqlQuoted + colName + cp.sqlQuoted);
							} else {
								sbIxCnts.append(", " + cp.sqlQuoted + colName + cp.sqlQuoted);
								if (constraintType.equals("U"))sbIx2Cnts.append(", " + cp.sqlQuoted + colName + cp.sqlQuoted);
							}
						}
					}

					//1st Line Process
					else {
						if (strSplit[3].equals("P")){
							sbIxCnts.append("ALTER TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " ADD CONSTRAINT " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + " PRIMARY KEY(");
							sbIx2Cnts.append("ALTER TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " DROP CONSTRAINT " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + ";");
						} else if (strSplit[3].equals("U")){
							sbIxCnts.append("ALTER TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " ADD CONSTRAINT " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + " UNIQUE(");
							sbIx2Cnts.append("ALTER TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " DROP UNIQUE(");
						} else if (strSplit[3].equals("")){
							sbIxCnts.append("CREATE INDEX " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + " ON " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + "(");
						}
						sbIx3Cnts.append("DROP INDEX " + cp.sqlQuoted + strSplit[1] + cp.sqlQuoted + ";");
					}
					for(int i=0;i<strSplit.length;i++)CmnUtils.debugPrint("'" + strSplit[i] + "'");

					tableName = strSplit[0];
					indexName = strSplit[1];
					indexType = strSplit[2];
					constraintType = strSplit[3];
					colName = strSplit[4];
					colPos = strSplit[5];
				}
			}
			if (!indexName.equals("")){
				//Post Process
				if (colPos.equals("1")){
					sbIxCnts.append(cp.sqlQuoted + colName + cp.sqlQuoted);
					if (constraintType.equals("U"))sbIx2Cnts.append(cp.sqlQuoted + colName + cp.sqlQuoted);
				} else {
					sbIxCnts.append(", " + cp.sqlQuoted + colName + cp.sqlQuoted);
					if (constraintType.equals("U"))sbIx2Cnts.append(", " + cp.sqlQuoted + colName + cp.sqlQuoted);
				}
				sbIxCnts.append(");");
				sbIxCnts.append(cp.lineSeparator);
				if (constraintType.equals("U"))sbIx2Cnts.append(");");
				sbIx2Cnts.append(cp.lineSeparator);
				sbIx3Cnts.append(cp.lineSeparator);

				//Write Buffer
				if (constraintType.equals("P")){
					strSplit2 = CmnUtils.splitCrLf(sbIxCnts.toString());
					for(int i=0;i<strSplit2.length;i++)if(!strSplit2[i].trim().equals(""))pw[0].println(strSplit2[i]);
					strSplit3 = CmnUtils.splitCrLf(sbIx2Cnts.toString());
					for(int i=0;i<strSplit3.length;i++)if(!strSplit3[i].trim().equals(""))pw[3].println(strSplit3[i]);
				} else if (constraintType.equals("U")){
					strSplit2 = CmnUtils.splitCrLf(sbIxCnts.toString());
					for(int i=0;i<strSplit2.length;i++)if(!strSplit2[i].trim().equals(""))pw[1].println(strSplit2[i]);
					strSplit3 = CmnUtils.splitCrLf(sbIx2Cnts.toString());
					for(int i=0;i<strSplit3.length;i++)if(!strSplit3[i].trim().equals(""))pw[4].println(strSplit3[i]);
				} else if (constraintType.equals("")){
					strSplit2 = CmnUtils.splitCrLf(sbIxCnts.toString());
					for(int i=0;i<strSplit2.length;i++)if(!strSplit2[i].trim().equals(""))pw[2].println(strSplit2[i]);
				}
				strSplit4 = CmnUtils.splitCrLf(sbIx3Cnts.toString());
				for(int i=0;i<strSplit4.length;i++)if(!strSplit4[i].trim().equals(""))pw[5].println(strSplit4[i]);
			}

			//Close Buffer
			for(int i=0;i<6;i++)pw[i].close();
			for(int i=0;i<6;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Index Contents end

			// View Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[FL_VIEW] + "_" + database +".csv"));
			subFolder = new File(folder + "/VIEWS");
			subFolder.mkdir();
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_VIEW]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_VIEW]))));
			while((strLine=br[0].readLine()) != null){
				strSplit = CmnUtils.splitCsv(strLine);
				CmnUtils.debugPrint("'" + strSplit[0] + "'");
				pw[1].println("@VIEWS/" + strSplit[0] + ".sql");
				pw[2].println("DROP VIEW \"" + strSplit[0] + "\";");
				if (strSplit.length>1)CmnUtils.debugPrint("'" + strSplit[1] + "'");
				pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + strSplit[0] + ".sql"))));
				stmt = dao.prepareSql(sql_view_column_and_comment);
				stmt.setString(1,strSplit[0]);
				dao.executeSql();
				alData = dao.getArrayList();
				columnCount = dao.getColumnCount();
				pw[0].println("/* " + strSplit[0] + " */");
				pw[0].println("CREATE OR REPLACE VIEW " + strSplit[0]);
				pw[0].println("(");
				for(int i=0;i<alData.size();i++){
					if ((i+1) % columnCount == 1){
						if (i == 0){
							if (!alData.get(i+1).equals("")){
								pw[0].println("    " + alData.get(i) + "    -- " + alData.get(i+1));
							} else {
								pw[0].println("    " + alData.get(i));
							}
						} else {
							if (!alData.get(i+1).equals("")){
								pw[0].println("    ," + alData.get(i) + "    -- " + alData.get(i+1));
							} else {
								pw[0].println("    ," + alData.get(i));
							}
						}
					}
				}
				pw[0].println(")");
				pw[0].println("AS");
				stmt = dao.prepareSql(sql_view_text);
				stmt.setString(1,strSplit[0]);
				dao.executeSql();
				alData2 = dao.getArrayList();
				strContents = alData2.get(0).trim().replaceAll("\n",cp.lineSeparator);
				strSplit2 = CmnUtils.splitCrLf(strContents);
				for(int i=0;i<strSplit2.length;i++)if(!strSplit2[i].trim().equals(""))pw[0].println(strSplit2[i]);
				pw[0].println(";");
				if (!strSplit[1].equals(""))pw[0].println("COMMENT ON TABLE " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + " IS '" + strSplit[1] + "';");
				for(int i=0;i<alData.size();i++){
					if ((i+1) % columnCount == 0){
						if (!alData.get(i).equals(""))pw[0].println("COMMENT ON COLUMN " + cp.sqlQuoted + strSplit[0] + cp.sqlQuoted + "." + alData.get(i-1) + " IS '" + alData.get(i) + "';");
					}
				}
				pw[0].close();
				pw[0] = null;
			}
			for(int i=1;i<3;i++)pw[i].close();
			for(int i=1;i<3;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// View Contents end

			// Procedure Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[FL_PROCEDURE] + "_" + database +".csv"));
			subFolder = new File(folder + "/PROCEDURES");
			subFolder.mkdir();
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PROCEDURE]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_PROCEDURE]))));
			while((strLine=br[0].readLine()) != null){
				strSplit = CmnUtils.splitCsv(strLine);
				CmnUtils.debugPrint("'" + strSplit[0] + "'");
				pw[1].println("@PROCEDURES/" + strSplit[0] + ".sql");
				pw[2].println("DROP " + strSplit[1] + " " + strSplit[0] + ";");
				if (strSplit.length>1)CmnUtils.debugPrint("'" + strSplit[1] + "'");
				pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(new File(subFolder + "/" + strSplit[0] + ".sql"))));
				pw[0].println("/* " + strSplit[0] + " */");
				pw[0].print("CREATE OR REPLACE ");
				stmt = dao.prepareSql(sql_proc);
				stmt.setString(1,strSplit[0]);
				dao.executeSql();
				alData = dao.getArrayList();
				for(int i=0;i<alData.size();i++){
					strContents = alData.get(i).replaceAll("\n","");
					if(!strContents.equals(""))pw[0].println(strContents);
				}
				pw[0].println("/");
				pw[0].close();
				pw[0] = null;
			}
			for(int i=1;i<3;i++)pw[i].close();
			for(int i=1;i<3;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Procedure Contents end

			// Sequence Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[FL_SEQ] + "_" + database +".csv"));
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_SEQUENCE]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_SEQUENCE]))));

			while((strLine=br[0].readLine()) != null){
				strSplit = CmnUtils.splitCsv(strLine);
				seqName = strSplit[0];
				minVal = strSplit[1];
				maxVal = strSplit[2];
				incSz = strSplit[3];
				cycFg = strSplit[4];
				odFg = strSplit[5];
				cacheSz = strSplit[6];
				lstNo = strSplit[7];
				pw[1].print("CREATE SEQUENCE \"" + cp.sqlQuoted + seqName + cp.sqlQuoted + "\" MINVALUE " + minVal + " MAXVALUE " + maxVal + " INCREMENT BY " + incSz + " START WITH " + lstNo + " CACHE " + cacheSz);
				if (odFg.equals("N")){
					pw[1].print(" NOORDER");
				} else {
					pw[1].print(" ORDER");
				}
				if (cycFg.equals("N")){
					pw[1].print(" NOCYCLE");
				} else {
					pw[1].print(" CYCLE");
				}
				pw[1].println(";");
				pw[2].println("DROP SEQUENCE \"" + cp.sqlQuoted + seqName + cp.sqlQuoted + "\";");
				for(int i=0;i<strSplit.length;i++)CmnUtils.debugPrint("'" + strSplit[i] + "'");
			}
			for(int i=1;i<3;i++)pw[i].close();
			for(int i=1;i<3;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Sequence Contents end

			// Synonym Contents start
			br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[FL_SYNONYM] + "_" + database +".csv"));
			pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_SYNONYM]))));
			pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_SYNONYM]))));

			while((strLine=br[0].readLine()) != null){
				strSplit = CmnUtils.splitCsv(strLine);
				synmName = strSplit[0];
				tbOwner = strSplit[1];
				tbName = strSplit[2];
				dbLnk = strSplit[3];
				
				pw[1].print("CREATE SYNONYM " + cp.sqlQuoted + synmName + cp.sqlQuoted + " FOR ");
				if(dbLnk.equals("")){
					pw[1].print(cp.sqlQuoted + tbOwner + cp.sqlQuoted + "." + cp.sqlQuoted + tbName + cp.sqlQuoted );
				} else {
					pw[1].print(cp.sqlQuoted + tbName + cp.sqlQuoted + "@" + cp.sqlQuoted + dbLnk + cp.sqlQuoted );
				}
				pw[1].println(";");
				pw[2].println("DROP SYNONYM " + cp.sqlQuoted + synmName + cp.sqlQuoted + ";");
				for(int i=0;i<strSplit.length;i++)CmnUtils.debugPrint("'" + strSplit[i] + "'");
			}
			for(int i=1;i<3;i++)pw[i].close();
			for(int i=1;i<3;i++)pw[i]=null;
			br[0].close();
			br[0] = null;
			// Synonym Contents end

			// Fk Contents start
			File csvFile = new File(folder + "/" + FILE_NAME[FL_FK] + "_" + database +".csv");
			if (csvFile.length() > 0) {
				br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[FL_FK] + "_" + database +".csv"));
				pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_FK]))));
				pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.DROP_FK]))));
				tbName = "";
				fkName = "";
				fkCol = "";
				fkColPos = "";
				rtbName = "";
				rfkName = "";
				rfkCol = "";
				rfkColPos = "";
				
				while((strLine=br[0].readLine()) != null){
					strSplit = CmnUtils.splitCsv(strLine);
					if(!fkName.equals(strSplit[1]) && !fkName.equals("")){
						pw[1].println("ALTER TABLE " + cp.sqlQuoted + tbName + cp.sqlQuoted + " ADD CONSTRAINT " + cp.sqlQuoted + fkName + " FOREIGN KEY (" + cp.sqlQuoted + fkCol + cp.sqlQuoted + ") REFERENCES " + cp.sqlQuoted + rtbName + cp.sqlQuoted + " (" + cp.sqlQuoted + rfkCol + cp.sqlQuoted + ");");
						pw[2].println("ALTER TABLE " + cp.sqlQuoted + tbName + cp.sqlQuoted + " DROP CONSTRAINT " + cp.sqlQuoted + fkName + ";");
						for(int i=0;i<strSplit.length;i++)CmnUtils.debugPrint("'" + strSplit[i] + "'");
						tbName = strSplit[0];
						fkName = strSplit[1];
						fkCol = strSplit[2];
						fkColPos = strSplit[3];
						rtbName = strSplit[4];
						rfkName = strSplit[5];
						rfkCol = strSplit[6];
						rfkColPos = strSplit[7];
					} else {
						if(fkName.equals("")){
							tbName = strSplit[0];
							fkName = strSplit[1];
							fkCol = strSplit[2];
							fkColPos = strSplit[3];
							rtbName = strSplit[4];
							rfkName = strSplit[5];
							rfkCol = strSplit[6];
							rfkColPos = strSplit[7];
						} else {
							if (strSplit[3].equals(strSplit[7])) {
								fkCol = fkCol + cp.sqlQuoted + ", " + cp.sqlQuoted + strSplit[2] + cp.sqlQuoted;
								rfkCol = rfkCol + ", " + cp.sqlQuoted + strSplit[6] + cp.sqlQuoted;
							}
						}
					}
					
				}
				pw[1].println("ALTER TABLE " + cp.sqlQuoted + tbName + cp.sqlQuoted + " ADD CONSTRAINT " + cp.sqlQuoted + fkName + cp.sqlQuoted + " FOREIGN KEY (" + cp.sqlQuoted + fkCol + cp.sqlQuoted + ") REFERENCES " + cp.sqlQuoted + rtbName + cp.sqlQuoted + " (" + cp.sqlQuoted + rfkCol + cp.sqlQuoted + ");");
				pw[2].println("ALTER TABLE " + cp.sqlQuoted + cp.sqlQuoted + tbName + cp.sqlQuoted + " DROP CONSTRAINT " + cp.sqlQuoted + fkName + cp.sqlQuoted + ";");
				for(int i=1;i<3;i++)pw[i].close();
				for(int i=1;i<3;i++)pw[i]=null;
				br[0].close();
				br[0] = null;
			}
			// Fk Contents end

			// Rhysical Contents start
			if(cp.isPhysical){
				// physical index setting
				br[0] = new BufferedReader(new FileReader(folder + "/" + FILE_NAME[FL_OBJ] + "_" + database +".csv"));
				br[1] = new BufferedReader(new FileReader(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY]));
				br[2] = new BufferedReader(new FileReader(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY]));
				br[3] = new BufferedReader(new FileReader(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX]));
				pw[1] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY] + ".phy"))));
				pw[2] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY] + ".phy"))));
				pw[3] = new PrintWriter(new BufferedWriter(new FileWriter(new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX] + ".phy"))));
				alData = new ArrayList<String>();
				int rowNo;
				String [] rowData;
				while((strLine=br[0].readLine()) != null){
					strSplit = CmnUtils.splitCsv(strLine);
					for(int i=0;i<strSplit.length;i++)alData.add(strSplit[i]);
				}
				while((strLine=br[1].readLine()) != null){
					strSplit = CmnUtils.splitSpace(strLine);
					rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, strSplit[5].replaceAll(cp.sqlQuoted,""));
					if (rowNo != -1){
						rowData = rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
						CmnUtils.debugPrint(strSplit[5] + ":" + rowNo);
						for(int i=0;i<rowData.length;i++)CmnUtils.debugPrint(rowData[i]);
						tbName = rowData[0];
						objName = rowData[1];
						objTyp = rowData[2];
						pctFree = rowData[3];
						pctUsed = rowData[4];
						iniTrns = rowData[5];
						freeLst = rowData[6];
						flstGrp = rowData[7];
						bufPool = rowData[8];
						tblSpace = rowData[9];
						logging = rowData[10];
						segByts = rowData[11];
						pw[1].print(strLine.replace(';',' '));
						pw[1].print("USING INDEX PCTFREE " + pctFree);
						pw[1].print(" INITRANS " + iniTrns + " STORAGE(");
						if(!freeLst.equals(""))pw[1].print(" FREELISTS " + freeLst);
						if(!flstGrp.equals(""))pw[1].print(" FREELIST GROUPS " + flstGrp);
						pw[1].print(" BUFFER_POOL " + bufPool + ")");
						pw[1].print(" TABLESPACE " + cp.sqlQuoted + tblSpace + cp.sqlQuoted);
						if(logging.equals("NO")){
							pw[1].println(" NOLOGGING;");
						} else {
							pw[1].println(";");
						}
					} else {
						pw[1].println(strLine);
						CmnUtils.errorPrint(strSplit[5] + ",UNUSABLE INDEX");
					}
				}
				while((strLine=br[2].readLine()) != null){
					strSplit = CmnUtils.splitSpace(strLine);
					rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, strSplit[5].replaceAll(cp.sqlQuoted,""));
					if (rowNo != -1){
						rowData = rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
						CmnUtils.debugPrint(strSplit[5] + ":" + rowNo);
						for(int i=0;i<rowData.length;i++)CmnUtils.debugPrint(rowData[i]);
						tbName = rowData[0];
						objName = rowData[1];
						objTyp = rowData[2];
						pctFree = rowData[3];
						pctUsed = rowData[4];
						iniTrns = rowData[5];
						freeLst = rowData[6];
						flstGrp = rowData[7];
						bufPool = rowData[8];
						tblSpace = rowData[9];
						logging = rowData[10];
						segByts = rowData[11];
						pw[2].print(strLine.replace(';',' '));
						pw[2].print("USING INDEX PCTFREE " + pctFree);
						pw[2].print(" INITRANS " + iniTrns + " STORAGE(");
						if(!freeLst.equals(""))pw[2].print(" FREELISTS " + freeLst);
						if(!flstGrp.equals(""))pw[2].print(" FREELIST GROUPS " + flstGrp);
						pw[2].print(" BUFFER_POOL " + bufPool + ")");
						pw[2].print(" TABLESPACE " + cp.sqlQuoted + tblSpace + cp.sqlQuoted);
						if(logging.equals("NO")){
							pw[2].println(" NOLOGGING;");
						} else {
							pw[2].println(";");
						}
					} else {
						pw[2].println(strLine);
						CmnUtils.errorPrint(strSplit[5] + ",UNUSABLE INDEX");
					}
				}
				while((strLine=br[3].readLine()) != null){
					strSplit = CmnUtils.splitSpace(strLine);
					rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, strSplit[2].replaceAll(cp.sqlQuoted,""));
					CmnUtils.debugPrint("rowNo=" + rowNo);
					if (rowNo != -1){
						rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
						for(int i=0;i<rowData.length;i++)CmnUtils.debugPrint(rowData[i]);
						tbName = rowData[0];
						objName = rowData[1];
						objTyp = rowData[2];
						pctFree = rowData[3];
						pctUsed = rowData[4];
						iniTrns = rowData[5];
						freeLst = rowData[6];
						flstGrp = rowData[7];
						bufPool = rowData[8];
						tblSpace = rowData[9];
						logging = rowData[10];
						segByts = rowData[11];
						pw[3].print(strLine.replace(';',' '));
						pw[3].print("PCTFREE " + pctFree);
						pw[3].print(" INITRANS " + iniTrns + " STORAGE(");
						if(!freeLst.equals(""))pw[3].print(" FREELISTS " + freeLst);
						if(!flstGrp.equals(""))pw[3].print(" FREELIST GROUPS " + flstGrp);
						pw[3].print(" BUFFER_POOL " + bufPool + ")");
						pw[3].print(" TABLESPACE " + cp.sqlQuoted + tblSpace + cp.sqlQuoted);
						if(logging.equals("NO")){
							pw[3].println(" NOLOGGING;");
						} else {
							pw[3].println(";");
						}
					} else {
						pw[3].println(strLine);
						CmnUtils.errorPrint(strSplit[2] + ",UNUSABLE INDEX");
					}
				}
				for(int i=1;i<4;i++)pw[i].close();
				for(int i=1;i<4;i++)pw[i]=null;
				for(int i=0;i<4;i++)br[i].close();
				for(int i=0;i<4;i++)br[i]=null;
				
				File [] fmFl = new File[6];
				File [] toFl = new File[6];
				
				fmFl[0] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY] + ".phy");
				fmFl[1] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY] + ".phy");
				fmFl[2] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX] + ".phy");
				toFl[0] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_PKEY]);
				toFl[1] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_UKEY]);
				toFl[2] = new File(folder + "/" + cp.SQL_FILE_NAME[cp.CREATE_INDEX]);
				for(int i=0;i<3;i++){
					CmnUtils.debugPrint(fmFl[i].toString() + ">" + toFl[i].toString());
					toFl[i].delete();
					fmFl[i].renameTo(toFl[i]);
				}
				
				// physical table setting
				File tbDir = new File(folder + "/TABLES");
				File [] tbFiles = tbDir.listFiles();
				File tb = null;
				File oTb = null;
				for(int i=0;i<tbFiles.length;i++){
					tb = tbFiles[i];
					tbName = tb.getName().replaceAll(".sql","");
					oTb = new File(tb + ".phy");
					CmnUtils.debugPrint(tbName);
					br[0] = new BufferedReader(new FileReader(tb));
					pw[0] = new PrintWriter(new BufferedWriter(new FileWriter(oTb)));
					while((strLine=br[0].readLine()) != null){
						if(strLine.equals(");")){
							rowNo = CmnUtils.getArrayRowNo(alData, 12, 1, tbName);
							if (rowNo != -1){
								rowData = CmnUtils.getArrayRowData(alData, 12, rowNo);
								CmnUtils.debugPrint(tbName + ":" + rowNo);
								//for(int j=0;j<rowData.length;i++)CmnUtils.debugPrint(rowData[j]);
								tbName = rowData[0];
								objName = rowData[1];
								objTyp = rowData[2];
								pctFree = rowData[3];
								pctUsed = rowData[4];
								iniTrns = rowData[5];
								freeLst = rowData[6];
								flstGrp = rowData[7];
								bufPool = rowData[8];
								tblSpace = rowData[9];
								logging = rowData[10];
								segByts = rowData[11];
								pw[0].print(") PCTFREE " + pctFree);
								if(!pctUsed.equals(""))pw[0].print(" PCTUSED " + pctUsed);
								pw[0].print(" INITRANS " + iniTrns + " STORAGE(");
								if(!freeLst.equals(""))pw[0].print(" FREELISTS " + freeLst);
								if(!flstGrp.equals(""))pw[0].print(" FREELIST GROUPS " + flstGrp);
								pw[0].print(" BUFFER_POOL " + bufPool + ")");
								pw[0].print(" TABLESPACE " + cp.sqlQuoted + tblSpace + cp.sqlQuoted);
								if(logging.equals("NO")){
									pw[0].println(" NOLOGGING;");
								} else {
									pw[0].println(";");
								}
							} else {
								pw[0].println(");");
							}
						} else {
							pw[0].println(strLine);
						}
					}
					pw[0].close();
					pw[0]=null;
					br[0].close();
					br[0]=null;
					tb.delete();
					oTb.renameTo(tb);
				}
			}
			// Rhysical Contents end

			// Remove work file
			File fl= null;
			for(int i=0;i<sql.length;i++){
				fl= new File(folder + "/" + FILE_NAME[i] + "_" + database +".csv");
				CmnUtils.debugPrint(fl.toString());
				fl.delete();
			}

			// disconnect database
			dao.disconnect();
			CmnUtils.infoPrint("^f[^A[hI܂B");

		} catch(SQLException se) {
			try{
				CmnUtils.errorPrint(se.toString());
				se.printStackTrace();
				se = se.getNextException();
				if(se != null) {
					System.out.println(se.getMessage());
				}
				dao.rollback();
			} catch (Exception see) {}
		} catch (Exception e) {			
			try{
				CmnUtils.errorPrint(e.toString());
				e.printStackTrace();
				dao.rollback();
			} catch (Exception ee) {}
		} finally{
			try{
				for(int i=0;i<6;i++){
					if(pw[i]!=null){
						pw[i].close();
						pw[i]=null;
					}
				}
				for(int i=0;i<4;i++){
					if(br[i]!=null){
						br[i].close();
						br[i]=null;
					}
				}
			} catch (Exception e) {}
		}
	}
	

}

