package com.rapide_act;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;

public class RapideUnloader{
	
	private String database = null;

	public static void main(String args[]){
		try {
			if (args.length > 0){
				RapideUnloader rapideUnloader = new RapideUnloader(args[0]);
				rapideUnloader.unload();
			} else {
				RapideUnloader rapideUnloader = new RapideUnloader(null);
				rapideUnloader.unload();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	RapideUnloader(String _database) {
		super();
		database = _database;

	}


	private void unload() {
		Connection conn 				= null;
		PreparedStatement stmt 			= null;
		ResultSet rst 					= null;
		String sql_unload 				= null;
		String sql_insert 				= null;
		String order_columns 			= "";
		int orders 						= 0;

		PrintWriter pw 					= null;
		File folder 						= null;
		ArrayList<String>  alColName 	= null;
		ArrayList<String>  alColTypeName = null;
		ArrayList<Integer> alIsNullable = null;
		ArrayList<Boolean> alColMask 	= null;
		ArrayList<Boolean> alColIncl 	= null;
		ArrayList<String>  alData 		= null;
		int tb_count 					= 0;
		int tb_col_count 				= 0;
		CmnProperty cp = null;
		DataAccessObjects dao = null;

		try {
			cp = new CmnProperty();
			cp.setProperty(database);
			
			if(cp.outFolder != null){
				folder = new File(cp.outFolder);
			} else {
				if(database != null){
					folder = new File(cp.DEFAULT_OUT_FOLDER + "/" + database.toUpperCase() + "_" + CmnUtils.getYmdhm());
				} else {
					folder = new File(cp.DEFAULT_OUT_FOLDER + "/" + cp.DB_TYPE_NAME[cp.dbType].toUpperCase() + "_" + CmnUtils.getYmdhm());
				}
				folder.mkdir();
			}
			
			CmnUtils.infoPrint("-->o͐tH_='" + folder + "'");
			CmnUtils.infoPrint("f[^A[hJn܂B");
			dao = new DataAccessObjects(cp);
			conn = dao.connect();
			dao.select(cp.tkSql);
			alData = dao.getArrayList();
			tb_count = dao.getColumnCount();
			orders = 0;
			order_columns = "";
			CmnUtils.debugPrint("tables=" + alData.size());
			for(int i=0;i<alData.size();i++){
				if ((i+1) % tb_count == 1){
					if ((i + 2 <alData.size()) && (!alData.get(i).equals(alData.get(i+2))) || (i + 2 == alData.size())) {
						if(cp.isInclTables && !CmnUtils.isMatch(cp.inclTablesArray,alData.get(i).toUpperCase())){
							CmnUtils.debugPrint("cp.inclTables=" + cp.inclTables);
							CmnUtils.debugPrint("table=" + alData.get(i) + "," +CmnUtils.isMatch(cp.inclTablesArray,alData.get(i).toUpperCase()));
							orders = 0;
							order_columns = "";
							continue;
						}
						if(cp.isExclTables && CmnUtils.isMatch(cp.exclTablesArray,alData.get(i).toUpperCase())){
							CmnUtils.debugPrint("cp.exclTables=" + cp.exclTables);
							CmnUtils.debugPrint("table=" + alData.get(i) + "," +CmnUtils.isMatch(cp.exclTablesArray,alData.get(i).toUpperCase()));
							orders = 0;
							order_columns = "";
							continue;
						}
						if (!alData.get(i+1).equals("")){
							if(cp.isOrder){
								if (orders == 0){
									if (!alData.get(i+1).equals(""))order_columns = alData.get(i+1);
								} else {
									order_columns += "," + alData.get(i+1);
								}
								orders++;
							}
						}							
						if(cp.isOrder){
							if(!order_columns.equals("")){
								sql_unload = "select * from " + alData.get(i) + " order by " + order_columns;
							} else {
								sql_unload = "select * from " + alData.get(i);
							}
						} else {
							sql_unload = "select * from " + alData.get(i);
						}
						CmnUtils.debugPrint("i=" + i);
						CmnUtils.debugPrint(sql_unload);
						stmt = dao.prepareSql(sql_unload);
						dao.executeSql(stmt);
						alColName = dao.getArrayColumnNameList();
						alColTypeName = dao.getArrayColumnTypeNameList();
						alColMask = new ArrayList<Boolean>();
						alColIncl = new ArrayList<Boolean>();
						tb_col_count = dao.getColumnCount();
						for(int j=0;j<alColName.size();j++){
							if(CmnUtils.isColString(alColTypeName.get(j))){
								if(cp.isMask){
									if(
										(cp.isInclColsMask && 
										 !cp.isExclColsMask &&
										 CmnUtils.isMatch(cp.inclColsMaskArray,alData.get(i).toUpperCase(),alColName.get(j).toUpperCase())
										) ||
										(cp.isInclColsMask && 
										 cp.isExclColsMask &&
										 CmnUtils.isMatch(cp.inclColsMaskArray,alData.get(i).toUpperCase(),alColName.get(j).toUpperCase()) &&
										 !CmnUtils.isMatch(cp.exclColsMaskArray,alData.get(i).toUpperCase(),alColName.get(j).toUpperCase())
										) ||
										(!cp.isInclColsMask && 
										 cp.isExclColsMask &&
										 !CmnUtils.isMatch(cp.exclColsMaskArray,alData.get(i).toUpperCase(),alColName.get(j).toUpperCase())
										) 
									){
										CmnUtils.debugPrint("Mask Column=" + alColName.get(j).toUpperCase());
										alColMask.add(true);
									} else {
										alColMask.add(false);
									}
								} else {
									alColMask.add(false);
								}
							} else {
								alColMask.add(false);
							}
							if(cp.isInclCols || cp.isExclCols){
								if(
									(cp.isInclCols && 
									 !cp.isExclCols &&
									 CmnUtils.isMatch(cp.inclColsArray,alData.get(i).toUpperCase(), alColName.get(j).toUpperCase())
									) ||
									(cp.isInclCols && 
									 cp.isExclCols &&
									 CmnUtils.isMatch(cp.inclColsArray,alData.get(i).toUpperCase(), alColName.get(j).toUpperCase()) &&
									 !CmnUtils.isMatch(cp.exclColsArray,alData.get(i).toUpperCase(),alColName.get(j).toUpperCase())
									) ||
									(!cp.isInclCols && 
									 cp.isExclCols &&
									 !CmnUtils.isMatch(cp.exclColsArray,alData.get(i).toUpperCase(),alColName.get(j).toUpperCase())
									)
								){
									CmnUtils.debugPrint("column=" + alColName.get(j).toUpperCase());
									alColIncl.add(true);
								} else {
									alColIncl.add(false);
								}
							} else {
								alColIncl.add(true);
							}
						}
						Boolean [] colIncl = (Boolean[])alColIncl.toArray(new Boolean[0]);
						int firstCol;
						int lastCol;
						for(firstCol=0;firstCol<colIncl.length-1;firstCol++){
							if(colIncl[firstCol]){
								break;
							}
						}
						for(lastCol=colIncl.length-1;lastCol >= 0;lastCol--){
							if(colIncl[lastCol]){
								break;
							}
						}
						CmnUtils.debugPrint("firstCol=" + firstCol);
						CmnUtils.debugPrint("lastCol=" + lastCol);
						
						dao.setTableName(alData.get(i));
						dao.setArrayColumnInclList(alColIncl);
						dao.setArrayColumnMaskList(alColMask);
						
						if (lastCol >= 0){
							pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(folder + "/" + alData.get(i) + "." + cp.fileExtension), cp.fileEncoding)));
							CmnUtils.infoPrinting(String.format("%1$-30s",alData.get(i)));

							for(int j=0;j<alColName.size();j++){
								if(j==firstCol){
									if(cp.isQuotation){
										pw.print("\"" + alColName.get(j));
									} else {
										pw.print(alColName.get(j));
									}
								} else {
									if(colIncl[j])pw.print(alColName.get(j));
								}
								if (firstCol == lastCol){
									if(cp.isQuotation){
										pw.print("\"" + cp.lineSeparator);
									} else {
										pw.print("" + cp.lineSeparator);
									}
								} else {
									if (j==lastCol){
										if(cp.isQuotation){
											pw.print("\"" + cp.lineSeparator);
										} else {
											pw.print("" + cp.lineSeparator);
										}
									} else {
										if(colIncl[j]){
											if(cp.isQuotation){
												pw.print("\"" + cp.delimiter + "\"");
											} else {
												pw.print(cp.delimiter);
											}
										}
									}
								}
							}
							dao.getRecordToPrint(pw,firstCol,lastCol);
							dao.closeRecordSet();
							pw.close();
							pw = null;
							System.out.println(String.format("%1$10d",dao.getRecCount()) + " s A[h܂B");
						}
						orders = 0;
						order_columns = "";
					} else {
						if (!alData.get(i+1).equals("")){
							if(cp.isOrder){
								if (orders == 0){
									if (!alData.get(i+1).equals(""))order_columns = alData.get(i+1);
								} else {
									order_columns += "," + alData.get(i+1);
								}
								orders++;
							}
						}
						continue;
					}
				} else {
				}
			}

			CmnUtils.infoPrint("f[^A[hI܂B");

		} catch(SQLException se) {
			try{
				CmnUtils.errorPrint(se.toString());
				se.printStackTrace();
				//while (se != null) {
				//  System.out.println(se.getMessage());
				//  se = se.getNextException();
				//}
				dao.rollback();
			} catch (Exception see) {}
		} catch (Exception e) {			
			try{
				CmnUtils.errorPrint(e.toString());
				e.printStackTrace();
				dao.rollback();
			} catch (Exception ee) {}
		} finally{
			try{
				dao.disconnect();
				if(stmt != null){
					stmt.close();
					stmt=null;
				}
				if(pw!=null){
					pw.close();
					pw=null;
				}
			} catch (Exception e) {}
		}
	}


}

