/*
 * Decompiled with CFR 0.152.
 */
package com.rapide_act;

import com.rapide_act.CmnUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class CmnProperty {
    protected String database = null;
    protected static final int DB_TYPE_ORACLE = 0;
    protected static final int DB_TYPE_SQLSERVER = 1;
    protected static final int DB_TYPE_MYSQL = 2;
    protected static final int DB_TYPE_DB2 = 3;
    protected static final int DB_TYPE_POSTGRESQL = 4;
    protected static final int DB_TYPE_UNKNOWN = -1;
    protected static final String[] DB_TYPE_NAME = new String[]{"ORACLE", "SQLSERVER", "MYSQL", "DB2", "POSTGRESQL"};
    protected static final String[] DB_SQL_QUOTED = new String[]{"\"", "\"", "`", "\"", "\""};
    protected static final int MASK_PTN_ALL = 0;
    protected static final int MASK_PTN_ALT = 1;
    protected static final int MASK_PTN_EDGE = 2;
    protected static final int D_USER = 0;
    protected static final int D_PASS = 1;
    protected static final int D_URL = 2;
    protected static final int D_DRIVER = 3;
    protected static final int D_OUTPUT = 4;
    protected static final int D_INPUT = 5;
    protected static final int D_LINESEP = 6;
    protected static final int D_INLINESEP = 7;
    protected static final int D_FILENCODE = 8;
    protected static final int D_NULLMARK = 9;
    protected static final int D_DELIMITER = 10;
    protected static final int D_TBLSQL = 11;
    protected static final int D_TBLKEYSQL = 12;
    protected static final int D_ORDER = 13;
    protected static final int D_QUOTATION = 14;
    protected static final int D_BATCOUNT = 15;
    protected static final int D_INCLTAB = 16;
    protected static final int D_EXCLTAB = 17;
    protected static final int D_INCLCOL = 18;
    protected static final int D_EXCLCOL = 19;
    protected static final int D_INCLCOLMASK = 20;
    protected static final int D_EXCLCOLMASK = 21;
    protected static final int D_SBYTEMASKCHR = 22;
    protected static final int D_DBYTEMASKCHR = 23;
    protected static final int D_MASKPTN = 24;
    protected static final int D_PROPFILE = 25;
    protected static final int D_SPCPADDING = 26;
    protected static final int D_FILEEXT = 27;
    protected static final int D_SQLQUOTED = 28;
    protected static final int KEYS = 29;
    protected static final String[] PROP_KEY = new String[]{"us", "pw", "url", "dr", "out", "in", "ls", "ils", "fe", "nm", "dm", "ts", "tks", "od", "qt", "bc", "it", "et", "ic", "ec", "icm", "ecm", "smc", "dmc", "mp", "pf", "sp", "ext", "sq"};
    protected String[] prop_val = new String[29];
    protected static final String[] MASK_PTN = new String[]{"ALL", "ALT", "EDGE"};
    protected static final String DEFAULT_IN_FOLDER = "input";
    protected static final String DEFAULT_OUT_FOLDER = "output";
    protected static final String DEFAULT_PROP_FILE = "RapideAct.properties";
    protected static final String[] T_SQL_ARRAY = new String[]{"select  table_name  from user_tables  order by table_name", "select  name as table_name  from sys.tables  order by name", "select  table_name  from information_schema.TABLES  where TABLE_TYPE = 'BASE TABLE' and TABLE_SCHEMA = database()  order by table_name", "select  tabname  from syscat.tables  where tabschema = CURRENT_SCHEMA and ownertype = 'U' and type = 'T'  order by tabname", "select  table_name  from information_schema.TABLES  where TABLE_TYPE = 'BASE TABLE' and TABLE_SCHEMA = current_schema()  order by table_name"};
    protected static final String[] TK_SQL_ARRAY = new String[]{"select a.table_name,d.column_name  from user_tables a, (select b.table_name,    c.column_name,    c.position   from user_constraints b,        user_cons_columns c   where b.CONSTRAINT_TYPE = 'P' and         b.TABLE_NAME = c.TABLE_NAME and         b.CONSTRAINT_NAME = c.CONSTRAINT_NAME   ) d where a.table_name = d.table_name(+) order by a.table_name, d.position", "SELECT  A.name AS table_name,  D.name AS col_name FROM sys.tables AS A LEFT OUTER JOIN sys.key_constraints AS B ON A.object_id = B.parent_object_id  AND B.type = 'PK' LEFT OUTER JOIN sys.index_columns AS C ON B.parent_object_id = C.object_id  AND B.unique_index_id = C.index_id LEFT OUTER JOIN sys.columns AS D ON C.object_id = D.object_id  AND C.column_id = D.column_id order by A.name,C.key_ordinal", "SELECT  a.TABLE_NAME,  b.COLUMN_NAME  from  (  select  TABLE_SCHEMA,  TABLE_NAME  from  information_schema.TABLES  where TABLE_TYPE = 'BASE TABLE' and TABLE_SCHEMA = database() ) a  left outer join information_schema.KEY_COLUMN_USAGE b  on a.TABLE_SCHEMA = b.TABLE_SCHEMA   and a.TABLE_NAME = b.TABLE_NAME   and b.CONSTRAINT_NAME = 'PRIMARY'  order by   a.table_name,b.ORDINAL_POSITION", "select a.tabname, b.colname from (  select    tabschema,    tabname   from    syscat.tables  where    tabschema = CURRENT_SCHEMA    and ownertype = 'U'    and type = 'T'  ) a  left outer join   (  select    c.tabschema,    c.tabname,    c.colname,    c.colseq  from    syscat.keycoluse c,    syscat.tabconst d  where    c.tabschema = CURRENT_SCHEMA    and c.tabschema = d.tabschema    and c.constname = d.constname    and d.type = 'P'  group by c.tabschema,c.tabname,c.colname,c.colseq  ) b  on a.tabschema = b.tabschema and a.tabname = b.tabname order by a.tabname,b.colseq", "select  a.table_name,  b.column_name  from  (  select  table_schema,  table_name  from  information_schema.tables a where table_type = 'BASE TABLE' and table_schema = current_schema() ) a  left outer join  (\tselect\t\tb1.table_schema,\t\tb1.table_name,\t\tb2.column_name,\t\tb2.ordinal_position\tfrom\t\tinformation_schema.table_constraints b1,\t\tinformation_schema.key_column_usage b2\twhere\t    b1.table_schema = current_schema() and\t\tb1.table_catalog = current_database() and\t\tb1.constraint_type = 'PRIMARY KEY' and\t\tb1.table_catalog = b2.table_catalog and\t\tb1.table_schema = b2.table_schema and\t\tb1.table_name = b2.table_name and\t\tb1.constraint_name = b2.constraint_name ) b on a.TABLE_SCHEMA = b.TABLE_SCHEMA   and a.TABLE_NAME = b.TABLE_NAME  order by   a.table_name,b.ordinal_position"};
    protected String user = null;
    protected String pass = null;
    protected String url = null;
    protected String driver = null;
    protected String outFolder = null;
    protected String inFolder = null;
    protected String lineSeparator = System.getProperty("line.separator");
    protected String inColLineSeparator = System.getProperty("line.separator");
    protected String fileEncoding = System.getProperty("file.encoding");
    protected String nullMark = "";
    protected String delimiter = "\t";
    protected String fileExtension = "tsv";
    protected boolean isSpcPadding = false;
    protected String sqlQuoted = null;
    protected String tSql = null;
    protected String tkSql = null;
    protected boolean isOrder = false;
    protected boolean isQuotation = true;
    protected int batchCount = 1000;
    protected String inclTables = null;
    protected String exclTables = null;
    protected String inclCols = null;
    protected String exclCols = null;
    protected String inclColsMask = null;
    protected String exclColsMask = null;
    protected char singleByteMaskChar = (char)42;
    protected char doubleByteMaskChar = (char)9632;
    protected String maskPattern = "ALT";
    protected String[] inclTablesArray = null;
    protected String[] exclTablesArray = null;
    protected String[] inclColsArray = null;
    protected String[] exclColsArray = null;
    protected String[] inclColsMaskArray = null;
    protected String[] exclColsMaskArray = null;
    protected boolean isInclTables = false;
    protected boolean isExclTables = false;
    protected boolean isInclCols = false;
    protected boolean isExclCols = false;
    protected boolean isMask = false;
    protected boolean isInclColsMask = false;
    protected boolean isExclColsMask = false;
    protected int dbType = -1;

    protected void getProperties(String string) throws Exception {
        BufferedReader bufferedReader = null;
        Properties properties = null;
        try {
            properties = new Properties();
            bufferedReader = new BufferedReader(new InputStreamReader(CmnProperty.class.getClassLoader().getResourceAsStream(string), "UTF-8"));
            properties.load(bufferedReader);
            for (int i = 0; i < 29; ++i) {
                this.prop_val[i] = properties.getProperty(this.database + "." + PROP_KEY[i]);
            }
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + string + "]");
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
                bufferedReader = null;
            }
        }
    }

    CmnProperty() {
    }

    protected void setProperty(String string) throws Exception {
        int n;
        this.database = string;
        if (this.database != null) {
            if (!CmnUtils.isEmpty(this.prop_val[25])) {
                this.getProperties(System.getProperty(this.prop_val[25]));
            } else {
                this.getProperties(DEFAULT_PROP_FILE);
            }
        }
        for (n = 0; n < 29; ++n) {
            if (System.getProperty(PROP_KEY[n]) != null) {
                this.prop_val[n] = System.getProperty(PROP_KEY[n]);
            }
            CmnUtils.debugPrint(PROP_KEY[n] + "=" + this.prop_val[n]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[0])) {
            this.user = this.prop_val[0];
        }
        if (!CmnUtils.isEmpty(this.prop_val[1])) {
            this.pass = this.prop_val[1];
        }
        if (!CmnUtils.isEmpty(this.prop_val[2])) {
            this.url = this.prop_val[2];
        }
        if (!CmnUtils.isEmpty(this.prop_val[3])) {
            this.driver = this.prop_val[3];
        }
        if (!CmnUtils.isEmpty(this.prop_val[4])) {
            this.outFolder = this.prop_val[4];
        }
        if (!CmnUtils.isEmpty(this.prop_val[5])) {
            this.inFolder = this.prop_val[5];
        }
        if (!CmnUtils.isEmpty(this.prop_val[6])) {
            this.lineSeparator = CmnUtils.getLineSeparator(this.prop_val[6]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[7])) {
            this.inColLineSeparator = CmnUtils.getLineSeparator(this.prop_val[7]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[8])) {
            this.fileEncoding = this.prop_val[8];
        }
        if (!CmnUtils.isEmpty(this.prop_val[9])) {
            this.nullMark = this.prop_val[9];
        }
        if (!CmnUtils.isEmpty(this.prop_val[10])) {
            this.delimiter = CmnUtils.getDelimiter(this.prop_val[10]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[11])) {
            this.tSql = this.prop_val[11];
        }
        if (!CmnUtils.isEmpty(this.prop_val[12])) {
            this.tkSql = this.prop_val[12];
        }
        if (!CmnUtils.isEmpty(this.prop_val[13]) && this.prop_val[13].toUpperCase().equals("Y")) {
            this.isOrder = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[14]) && this.prop_val[14].toUpperCase().equals("N")) {
            this.isQuotation = false;
        }
        if (!CmnUtils.isEmpty(this.prop_val[15]) && CmnUtils.isNumeric(this.prop_val[15])) {
            this.batchCount = Integer.parseInt(this.prop_val[15]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[16])) {
            this.isInclTables = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[17])) {
            this.isExclTables = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[18])) {
            this.isInclCols = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[19])) {
            this.isExclCols = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[20])) {
            this.isInclColsMask = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[21])) {
            this.isExclColsMask = true;
        }
        if (this.isInclColsMask || this.isExclColsMask) {
            this.isMask = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[16])) {
            this.inclTables = this.prop_val[16].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[17])) {
            this.exclTables = this.prop_val[17].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[18])) {
            this.inclCols = this.prop_val[18].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[19])) {
            this.exclCols = this.prop_val[19].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[20])) {
            this.inclColsMask = this.prop_val[20].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[21])) {
            this.exclColsMask = this.prop_val[21].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[16])) {
            this.inclTablesArray = CmnUtils.splitCsv(this.prop_val[16].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[17])) {
            this.exclTablesArray = CmnUtils.splitCsv(this.prop_val[17].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[18])) {
            this.inclColsArray = CmnUtils.splitCsv(this.prop_val[18].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[19])) {
            this.exclColsArray = CmnUtils.splitCsv(this.prop_val[19].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[20])) {
            this.inclColsMaskArray = CmnUtils.splitCsv(this.prop_val[20].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[21])) {
            this.exclColsMaskArray = CmnUtils.splitCsv(this.prop_val[21].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[22])) {
            this.singleByteMaskChar = this.prop_val[22].charAt(0);
        }
        if (!CmnUtils.isEmpty(this.prop_val[23])) {
            this.doubleByteMaskChar = this.prop_val[23].charAt(0);
        }
        if (!CmnUtils.isEmpty(this.prop_val[24])) {
            this.maskPattern = this.prop_val[24];
        }
        if (!CmnUtils.isEmpty(this.prop_val[26]) && this.prop_val[26].toUpperCase().equals("Y")) {
            this.isSpcPadding = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[27])) {
            this.fileExtension = this.prop_val[27];
        }
        if (CmnUtils.isEmpty(this.user)) {
            throw new Exception("us(\u30e6\u30fc\u30b6ID)\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
        }
        if (CmnUtils.isEmpty(this.pass)) {
            throw new Exception("pw(\u30d1\u30b9\u30ef\u30fc\u30c9)\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
        }
        if (CmnUtils.isEmpty(this.url)) {
            throw new Exception("url(\u63a5\u7d9a\u60c5\u5831)\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
        }
        if (CmnUtils.isEmpty(this.driver)) {
            throw new Exception("dr(\u30c9\u30e9\u30a4\u30d0)\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
        }
        for (n = 0; n < DB_TYPE_NAME.length; ++n) {
            if (!this.url.toUpperCase().contains(DB_TYPE_NAME[n])) continue;
            this.dbType = n;
            break;
        }
        if (this.dbType != -1) {
            this.tSql = !CmnUtils.isEmpty(this.prop_val[11]) ? this.prop_val[11] : T_SQL_ARRAY[this.dbType];
            this.tkSql = !CmnUtils.isEmpty(this.prop_val[12]) ? this.prop_val[12] : TK_SQL_ARRAY[this.dbType];
            this.sqlQuoted = !CmnUtils.isEmpty(this.prop_val[28]) ? this.prop_val[28] : DB_SQL_QUOTED[this.dbType];
        } else {
            throw new Exception("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u88fd\u54c1\u304c\u8b58\u5225\u3067\u304d\u307e\u305b\u3093\u3002[" + this.url + "]");
        }
        if (this.database != null) {
            CmnUtils.infoPrint("-->\u5bfe\u8c61\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9='" + this.database.toUpperCase() + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[27])) {
            CmnUtils.infoPrint("-->\u30d5\u30a1\u30a4\u30eb\u62e1\u5f35\u5b50='" + this.prop_val[27] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[10])) {
            CmnUtils.infoPrint("-->\u533a\u5207\u308a\u6587\u5b57='" + this.prop_val[10] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[6])) {
            CmnUtils.infoPrint("-->\u6539\u884c\u30b3\u30fc\u30c9='" + this.prop_val[6] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[7])) {
            CmnUtils.infoPrint("-->\u30ab\u30e9\u30e0\u5185\u6539\u884c\u30b3\u30fc\u30c9='" + this.prop_val[7] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[8])) {
            CmnUtils.infoPrint("-->\u6587\u5b57\u30b3\u30fc\u30c9='" + this.prop_val[8] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[14])) {
            CmnUtils.infoPrint("-->\u5f15\u7528\u53e5=" + CmnUtils.getYesNo(this.isQuotation));
        }
        if (!CmnUtils.isEmpty(this.prop_val[28])) {
            CmnUtils.infoPrint("-->SQL\u5f15\u7528\u7b26='" + this.sqlQuoted + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[13])) {
            CmnUtils.infoPrint("-->\u30bd\u30fc\u30c8=" + CmnUtils.getYesNo(this.isOrder));
        }
        if (!CmnUtils.isEmpty(this.prop_val[15])) {
            CmnUtils.infoPrint("-->\u30d0\u30c3\u30c1\u51e6\u7406\u6570=" + this.batchCount);
        }
        if (this.isSpcPadding) {
            CmnUtils.infoPrint("-->\u7a7a\u767d\u57cb\u3081=" + CmnUtils.getYesNo(this.isSpcPadding));
        }
        if (this.isInclTables) {
            CmnUtils.infoPrint("-->\u5bfe\u8c61\u30c6\u30fc\u30d6\u30eb='" + this.inclTables.toUpperCase() + "'");
        }
        if (this.isExclTables) {
            CmnUtils.infoPrint("-->\u9664\u5916\u30c6\u30fc\u30d6\u30eb='" + this.exclTables.toUpperCase() + "'");
        }
        if (this.isInclCols) {
            CmnUtils.infoPrint("-->\u5bfe\u8c61\u30ab\u30e9\u30e0='" + this.inclCols.toUpperCase() + "'");
        }
        if (this.isExclCols) {
            CmnUtils.infoPrint("-->\u9664\u5916\u30ab\u30e9\u30e0='" + this.exclCols.toUpperCase() + "'");
        }
        if (this.isMask) {
            CmnUtils.infoPrint("-->\u30de\u30b9\u30ad\u30f3\u30b0=" + CmnUtils.getYesNo(this.isMask));
            CmnUtils.infoPrint("-->\u30de\u30b9\u30af\u30ad\u30f3\u30b0\u30d1\u30bf\u30fc\u30f3=" + this.maskPattern.toUpperCase());
            CmnUtils.infoPrint("-->\u534a\u89d2\u30de\u30b9\u30af\u6587\u5b57='" + this.singleByteMaskChar + "'");
            CmnUtils.infoPrint("-->\u5168\u89d2\u30de\u30b9\u30af\u6587\u5b57='" + this.doubleByteMaskChar + "'");
            if (this.isInclColsMask) {
                CmnUtils.infoPrint("-->\u30de\u30b9\u30af\u5bfe\u8c61\u30ab\u30e9\u30e0='" + this.inclColsMask.toUpperCase() + "'");
            }
            if (this.isExclColsMask) {
                CmnUtils.infoPrint("-->\u30de\u30b9\u30af\u9664\u5916\u30ab\u30e9\u30e0='" + this.exclColsMask.toUpperCase() + "'");
            }
        }
    }
}

