/*
 * Decompiled with CFR 0.152.
 */
package com.rapide_act;

import com.rapide_act.CmnProperty;
import com.rapide_act.CmnUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

public class DataAccessObjects {
    private String driver = null;
    private String user = null;
    private String pass = null;
    private String url = null;
    private Connection conn = null;
    private PreparedStatement stmt = null;
    private ResultSet rst = null;
    private ResultSetMetaData rsmd = null;
    private int ColumnCount = 0;
    private ArrayList<String> alColName = null;
    private ArrayList<String> alColTypeName = null;
    private ArrayList<Integer> alIsNullable = null;
    private ArrayList<Boolean> alColMask = null;
    private ArrayList<Boolean> alColIncl = null;
    private ArrayList<String> alData = null;
    private static String sql = "select sysdate from dual";
    private String[] colTypeName = null;
    private String[] colName = null;
    private Integer[] isNullable = null;
    private Boolean[] colMask = null;
    private Boolean[] colIncl = null;
    private String colString = null;
    private BigDecimal colBigDecimal = null;
    private Integer colInt = null;
    private Long colLong = null;
    private Short colShort = null;
    private Float colFloat = null;
    private Double colDouble = null;
    private Timestamp colTimestamp = null;
    private Time colTime = null;
    private Date colDate = null;
    private Date colYear = null;
    private byte[] colBytes = null;
    private Blob colBlob = null;
    private Clob colClob = null;
    private String tbName = null;
    private int recCount = 0;
    private CmnProperty cp = null;

    DataAccessObjects(String string, String string2, String string3, String string4) {
        this.user = string;
        this.pass = string2;
        this.url = string3;
        this.driver = string4;
    }

    DataAccessObjects(CmnProperty cmnProperty) {
        this.cp = cmnProperty;
        this.user = this.cp.user;
        this.pass = this.cp.pass;
        this.url = this.cp.url;
        this.driver = this.cp.driver;
    }

    public Connection connect() throws Exception {
        try {
            CmnUtils.debugPrint("Start Driver class loading");
            Class.forName(this.driver);
            CmnUtils.debugPrint("End Driver class loading");
            CmnUtils.debugPrint("Start Connect Database>" + this.url + "," + this.user);
            this.conn = DriverManager.getConnection(this.url, this.user, this.pass);
            CmnUtils.debugPrint("End Connect Database");
            return this.conn;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public PreparedStatement prepareSql(String string) throws Exception {
        try {
            CmnUtils.debugPrint("Start prepared Statement");
            CmnUtils.debugPrint(string);
            this.stmt = this.conn.prepareStatement(string);
            CmnUtils.debugPrint("End prepared Statement");
            return this.stmt;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public void executeSql() throws Exception {
        try {
            this.executeSql(this.stmt);
            CmnUtils.debugPrint("Start get RecordSet");
            while (this.rst.next()) {
                for (int i = 0; i < this.ColumnCount; ++i) {
                    this.colString = this.getColString(this.rst, i + 1, this.colTypeName[i], this.isNullable[i], false);
                    if (this.colString != null) {
                        this.alData.add(this.colString);
                        continue;
                    }
                    this.alData.add("");
                }
            }
            CmnUtils.debugPrint("End get RecordSet");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (this.rst != null) {
                this.rst.close();
                this.rst = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }
    }

    public void executeSql(PreparedStatement preparedStatement) throws Exception {
        try {
            CmnUtils.debugPrint("Start execute Query");
            this.rst = preparedStatement.executeQuery();
            CmnUtils.debugPrint("End execute Query");
            CmnUtils.debugPrint("Start get MetaData");
            this.rsmd = this.rst.getMetaData();
            CmnUtils.debugPrint("End get MetaData");
            CmnUtils.debugPrint("Start get ColumnCount");
            this.ColumnCount = this.rsmd.getColumnCount();
            CmnUtils.debugPrint("End get ColumnCount," + this.ColumnCount);
            this.alColTypeName = new ArrayList();
            this.alColName = new ArrayList();
            this.alIsNullable = new ArrayList();
            this.alData = new ArrayList();
            for (int i = 0; i < this.ColumnCount; ++i) {
                this.alColTypeName.add(this.rsmd.getColumnTypeName(i + 1));
                this.alColName.add(this.rsmd.getColumnName(i + 1));
                this.alIsNullable.add(this.rsmd.isNullable(i + 1));
            }
            this.colTypeName = this.alColTypeName.toArray(new String[0]);
            this.colName = this.alColName.toArray(new String[0]);
            this.isNullable = this.alIsNullable.toArray(new Integer[0]);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public void commit() throws Exception {
        CmnUtils.debugPrint("Start commit");
        this.conn.commit();
        CmnUtils.debugPrint("End commit");
    }

    public void rollback() throws Exception {
        CmnUtils.debugPrint("Start rollback");
        this.conn.rollback();
        CmnUtils.debugPrint("End rollback");
    }

    public void closeRecordSet() throws Exception {
        if (this.rst != null) {
            this.rst.close();
            this.rst = null;
        }
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
    }

    public void select(String string) throws Exception {
        PreparedStatement preparedStatement = this.prepareSql(string);
        this.executeSql(preparedStatement);
        this.getRecordToArray();
        this.closeRecordSet();
    }

    public int getColumnCount() throws Exception {
        return this.ColumnCount;
    }

    public int getRecCount() throws Exception {
        return this.recCount;
    }

    public ArrayList<String> getArrayList() throws Exception {
        return this.alData;
    }

    public ArrayList<String> getArrayColumnNameList() throws Exception {
        return this.alColName;
    }

    public ArrayList<String> getArrayColumnTypeNameList() throws Exception {
        return this.alColTypeName;
    }

    public ArrayList<Integer> getArrayIsNullableList() throws Exception {
        return this.alIsNullable;
    }

    public void setArrayColumnMaskList(ArrayList<Boolean> arrayList) throws Exception {
        this.alColMask = arrayList;
        this.colMask = this.alColMask.toArray(new Boolean[0]);
    }

    public void setArrayColumnInclList(ArrayList<Boolean> arrayList) throws Exception {
        this.alColIncl = arrayList;
        this.colIncl = this.alColIncl.toArray(new Boolean[0]);
    }

    public void setTableName(String string) throws Exception {
        this.tbName = string;
    }

    public ResultSet getResultSet() throws Exception {
        return this.rst;
    }

    public void getRecordToArray() throws Exception {
        try {
            CmnUtils.debugPrint("Start get RecordSet to Array");
            while (this.rst.next()) {
                this.colString = null;
                for (int i = 0; i < this.ColumnCount; ++i) {
                    this.colString = this.getColString(this.rst, i + 1, this.colTypeName[i], this.isNullable[i], false);
                    CmnUtils.debugPrint("col=" + this.colString);
                    if (this.colString != null) {
                        this.alData.add(this.colString);
                        continue;
                    }
                    this.alData.add("");
                }
            }
            CmnUtils.debugPrint("End get RecordSet to Array");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public void getRecordToPrint(PrintWriter printWriter, int n, int n2) throws Exception {
        try {
            CmnUtils.debugPrint("Start get Record to Print");
            this.recCount = 0;
            while (this.rst.next()) {
                this.colString = null;
                for (int i = 0; i < this.ColumnCount; ++i) {
                    if (!this.colIncl[i].booleanValue()) continue;
                    this.colString = this.getColString(this.rst, i + 1, this.colTypeName[i], this.isNullable[i], this.colMask[i]);
                    if (this.colString != null) {
                        if (i == n) {
                            if (this.cp.isQuotation) {
                                if (n == n2) {
                                    printWriter.print("\"" + this.colString + "\"" + this.cp.lineSeparator);
                                    continue;
                                }
                                printWriter.print("\"" + this.colString);
                                continue;
                            }
                            if (n == n2) {
                                printWriter.print(this.colString + this.cp.lineSeparator);
                                continue;
                            }
                            printWriter.print(this.colString);
                            continue;
                        }
                        if (i == n2) {
                            if (this.cp.isQuotation) {
                                printWriter.print("\"" + this.cp.delimiter + "\"" + this.colString + "\"" + this.cp.lineSeparator);
                                continue;
                            }
                            printWriter.print(this.cp.delimiter + this.colString + this.cp.lineSeparator);
                            continue;
                        }
                        if (this.cp.isQuotation) {
                            printWriter.print("\"" + this.cp.delimiter + "\"" + this.colString);
                            continue;
                        }
                        printWriter.print(this.cp.delimiter + this.colString);
                        continue;
                    }
                    if (i == n) {
                        if (this.cp.isQuotation) {
                            if (n == n2) {
                                printWriter.print("\"" + this.cp.nullMark + "\"" + this.cp.lineSeparator);
                                continue;
                            }
                            printWriter.print("\"" + this.cp.nullMark);
                            continue;
                        }
                        if (n == n2) {
                            printWriter.print(this.cp.nullMark + this.cp.lineSeparator);
                            continue;
                        }
                        printWriter.print(this.cp.nullMark);
                        continue;
                    }
                    if (i == n2) {
                        if (this.cp.isQuotation) {
                            printWriter.print("\"" + this.cp.delimiter + "\"" + this.cp.nullMark + "\"" + this.cp.lineSeparator);
                            continue;
                        }
                        printWriter.print(this.cp.delimiter + this.cp.nullMark + this.cp.lineSeparator);
                        continue;
                    }
                    if (this.cp.isQuotation) {
                        printWriter.print("\"" + this.cp.delimiter + "\"" + this.cp.nullMark);
                        continue;
                    }
                    printWriter.print(this.cp.delimiter + this.cp.nullMark);
                }
                ++this.recCount;
            }
            CmnUtils.debugPrint("End get Record to Print");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    private String getColString(ResultSet resultSet, int n, String string, Integer n2, Boolean bl) throws Exception {
        block49: {
            InputStream inputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            block48: {
                block50: {
                    this.colString = null;
                    this.colTimestamp = null;
                    this.colTime = null;
                    this.colDate = null;
                    this.colYear = null;
                    this.colBigDecimal = null;
                    this.colInt = null;
                    this.colLong = null;
                    this.colShort = null;
                    this.colFloat = null;
                    this.colDouble = null;
                    this.colBytes = null;
                    this.colBlob = null;
                    this.colClob = null;
                    byteArrayOutputStream = null;
                    inputStream = null;
                    if (!CmnUtils.isColString(string)) break block48;
                    this.colString = resultSet.getString(n);
                    if (this.colString == null) break block49;
                    this.colString = this.cp.isQuotation ? this.colString.trim().replaceAll("\u0000", "").replaceAll("\"", "\"\"") : this.colString.trim().replaceAll("\u0000", "");
                    if (!this.cp.isMask || !bl.booleanValue()) break block50;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < this.colString.length(); ++i) {
                        block52: {
                            block51: {
                                if (this.cp.maskPattern.toUpperCase().equals(CmnProperty.MASK_PTN[1]) && i % 2 == 1) break block51;
                                if (this.cp.maskPattern.toUpperCase().equals(CmnProperty.MASK_PTN[2]) && i != 0 && i != this.colString.length() - 1) break block51;
                                if (!this.cp.maskPattern.toUpperCase().equals(CmnProperty.MASK_PTN[0])) break block52;
                            }
                            if (CmnUtils.isHankaku(this.colString.charAt(i))) {
                                stringBuffer.append(this.cp.singleByteMaskChar);
                                continue;
                            }
                            stringBuffer.append(this.cp.doubleByteMaskChar);
                            continue;
                        }
                        stringBuffer.append(this.colString.charAt(i));
                    }
                    this.colString = stringBuffer.toString();
                }
                if (this.colString.equals("")) {
                    this.colString = " ";
                }
                break block49;
            }
            if (CmnUtils.isColDate(string)) {
                this.colDate = resultSet.getDate(n);
                if (this.colDate != null) {
                    this.colString = this.colDate.toString();
                }
            } else if (CmnUtils.isColYear(string)) {
                this.colYear = resultSet.getDate(n);
                if (this.colYear != null) {
                    this.colString = this.colYear.toString().substring(0, 4);
                }
            } else if (CmnUtils.isColTimestamp(string)) {
                this.colTimestamp = resultSet.getTimestamp(n);
                if (this.colTimestamp != null) {
                    this.colString = this.colTimestamp.toString();
                }
            } else if (CmnUtils.isColTime(string)) {
                this.colTime = resultSet.getTime(n);
                if (this.colTime != null) {
                    this.colString = this.colTime.toString();
                }
            } else if (CmnUtils.isColBigDecimal(string)) {
                this.colBigDecimal = resultSet.getBigDecimal(n);
                if (this.colBigDecimal != null) {
                    this.colString = this.colBigDecimal.toString();
                }
            } else if (CmnUtils.isColShort(string)) {
                this.colShort = resultSet.getShort(n);
                if (this.colShort != null) {
                    this.colString = this.colShort.toString();
                }
            } else if (CmnUtils.isColInt(string)) {
                this.colInt = resultSet.getInt(n);
                if (this.colInt != null) {
                    this.colString = this.colInt.toString();
                }
            } else if (CmnUtils.isColLong(string)) {
                this.colLong = resultSet.getLong(n);
                if (this.colLong != null) {
                    this.colString = this.colLong.toString();
                }
            } else if (CmnUtils.isColFloat(string)) {
                this.colFloat = Float.valueOf(resultSet.getFloat(n));
                if (this.colFloat != null) {
                    this.colString = this.colFloat.toString();
                }
            } else if (CmnUtils.isColDouble(string)) {
                this.colDouble = resultSet.getDouble(n);
                if (this.colDouble != null) {
                    this.colString = this.colDouble.toString();
                }
            } else if (CmnUtils.isColBytes(string)) {
                this.colBytes = resultSet.getBytes(n);
                if (this.colBytes != null) {
                    this.colString = CmnUtils.bytesToBase64(this.colBytes);
                }
            } else if (CmnUtils.isColBlob(string)) {
                this.colBlob = resultSet.getBlob(n);
                if (this.colBlob != null) {
                    inputStream = this.colBlob.getBinaryStream();
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    int n3 = -1;
                    this.colBytes = new byte[8192];
                    while ((n3 = inputStream.read(this.colBytes)) != -1) {
                        byteArrayOutputStream.write(this.colBytes, 0, n3);
                    }
                    this.colBytes = byteArrayOutputStream.toByteArray();
                    this.colString = CmnUtils.bytesToBase64(this.colBytes);
                    inputStream.close();
                    byteArrayOutputStream.close();
                    inputStream = null;
                    byteArrayOutputStream = null;
                }
            } else if (CmnUtils.isColClob(string)) {
                this.colClob = resultSet.getClob(n);
                if (this.colClob != null) {
                    this.colString = CmnUtils.clobToString(this.colClob);
                }
            } else {
                throw new Exception("unmatch column type=" + string);
            }
        }
        return this.colString;
    }

    public void disconnect() throws Exception {
        try {
            CmnUtils.debugPrint("Start disconnect database");
            this.conn.close();
            CmnUtils.debugPrint("End disconnect database");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
    }
}

