using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Text;
using System.IO;
using System.Reflection;
using System.Net.Sockets;


namespace RenameWatcher_winService_
{
    public partial class Service1 : ServiceBase
    {
        public Service1()
        {
            InitializeComponent();
        }

        //フィールド定義
        List<FileSystemWatcher> watcher = new List<FileSystemWatcher>();
        public List<string> folders = new List<string>();
        public List<string> types = new List<string>();
        parameter parameter1;
        string version;
        FileStream stm;
        StreamWriter w;

        //開始
        protected override void OnStart(string[] args)
        {
            //ログファイル
            if (Properties.Settings.Default.logFile.ToLower().Contains("n"))
            {
                stm = new FileStream(Path.Combine( Properties.Settings.Default.parameterPath , "Renamelog.txt"), FileMode.Append);
                w = new StreamWriter(stm);
            }
            //パラメータ入手
            parameter1 = new parameter(this);
            parameter1.パラメータ入手();
            //バージョン
            AssemblyName AssemblyName = Assembly.GetExecutingAssembly().GetName();
            version = AssemblyName.Version.ToString();
            for (int i = 0; i < folders.Count; i++)
            {
                watcher.Add(new FileSystemWatcher());
                try
                {
                    watcher[i].Path = folders[i];
                    watcher[i].IncludeSubdirectories = true;
                    watcher[i].NotifyFilter = NotifyFilters.DirectoryName;//   | NotifyFilters.FileName ;
                    watcher[i].Renamed += new RenamedEventHandler(Renamedevent);
                    watcher[i].EnableRaisingEvents = true;
                }
                catch (System.ArgumentException ex)
                {
                    log("エラー：" + ex.Message + "(これは監視対象から外れます)\r\n");
                    continue;
                }
                log("Event登録 {0}  {1}", DateTime.Now.ToString("MM/dd HH:mm:ss"), watcher[i].Path);
            }
            log(String.Format("リネイム監視開始 {0}", DateTime.Now.ToString("MM/dd HH:mm:ss")));
            sendTo("putLog", "starting of RenameWatcher");


        }

        //リネイムイベント処理
        private void Renamedevent(object source, RenamedEventArgs e)
        {
            try
            {
                string ename = e.Name.ToUpper();
                string eoldname = e.OldName.ToUpper();
                string doctype = types[watcher.IndexOf((FileSystemWatcher)source)];
                if (eoldname.Contains("\\"))
                {
                    eoldname = eoldname.Substring(eoldname.LastIndexOf('\\') + 1);
                }
                if (ename.Contains("\\"))
                {
                    ename = ename.Substring(ename.LastIndexOf('\\') + 1);
                }
                log("名前変更通知 {0}  {1}  {2}  【旧名： {3}】", DateTime.Now.ToString("MM/dd HH:mm:ss"), doctype, ename, eoldname);
                sendTo("chgdocumentname", folders[types.IndexOf(doctype)], eoldname, ename);
            }
            catch(Exception ex)
            {
                log("ERROR! : 名前変更時のイベント処理でエラー発生" + Environment.NewLine + ex.Message);
                List<string> TOs = new List<string>();
                TOs.Add( Properties.Settings.Default.mailRecieverAdr);
                string from = Properties.Settings.Default.malSenderAdr;
                string mailserver = Properties.Settings.Default.mailServer;
                int mailPort = Properties.Settings.Default.mailPort;
                string body = ex.Message + "\r\r" + ex.StackTrace;
                kensaku.メール.send(TOs, "名前変更時のイベント処理でエラー発生！", body, mailserver,from, mailPort);
            }
        }

        
        //終了
        protected override void OnStop()
        {
            foreach (FileSystemWatcher we in watcher)
            {
                we.EnableRaisingEvents = false;
                log("Event解除 {0}  {1}", DateTime.Now.ToString("MM/dd HH:mm:ss"), we.Path);
            }
            log("リネイム監視終了 {0}", DateTime.Now.ToString("MM/dd HH:mm:ss"));
            sendTo("putLog", "RenameWatcher fin");
        }

        //送信
        void sendTo(params string[] text)  
        {
            byte[] bytes = Encoding.UTF8.GetBytes(DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + "FileServer" + "|" + "RENAME" + "|" + version + "|" + string.Join("|", text));
            if (Properties.Settings.Default.protocol.ToLower().Contains("web"))
            {
                //WEBservice
                if (remote == null)
                {
                    remote = new DocWebService.Service();
                }
                remote.http2udp(bytes, bytes.Length);
            }
            else if (Properties.Settings.Default.protocol.ToLower().Contains("udp"))
            {
                //UDP
                udp.Send(bytes, bytes.Length, server, serverPort);
            }
            else if (Properties.Settings.Default.protocol.ToLower().Contains("abort"))
            {
                throw new Exception("エラーメールテストのためにabortを与えたもの");
            }
        }
        RenameWatcher_winService_.DocWebService.Service remote;
        string server = Properties.Settings.Default.server;
        public int serverPort = Properties.Settings.Default.serverPort;
        const int selfPort = 0;
        public UdpClient udp = new UdpClient(selfPort);


        //ログ出力
        public void log(string editstring, params object[] editvalue)
        {
            if (w != null)
            {
                w.WriteLine(editstring, editvalue);
                w.Flush();
            }
        }
    }
}
