//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "window.h"
#include "sound.h"
#include "wave_stream.h"

/*
 *	RXgN^
 */
CWaveStream::CWaveStream(){
	m_hEvent = NULL;
	m_pBuf = NULL;
	m_pNotify = NULL;
}

/*
 *	fXgN^
 */
CWaveStream::~CWaveStream(){
	End();
}

/*
 *	Xg[~OJn
 *
 *	format	: EF[utH[}bg
 *	size		: Xg[obt@̂PubÑTCY
 *	count		: ubN
 *
 *	DirectMusicƕpꍇ́AFreeMusic()ŃptH[}X邱ƁB
 */
BOOL CWaveStream::Begin(LPWAVEFORMATEX format, DWORD size, int count){
	if(!svs.pDS) return FALSE;
	End();	//	sȂI

	//	TEhobt@̍쐬
	DSBUFFERDESC dsbdesc;

	memset(&dsbdesc, 0, sizeof(DSBUFFERDESC));
	m_size = size*count;
	dsbdesc.dwSize = sizeof(DSBUFFERDESC);
	dsbdesc.dwBufferBytes = m_size;
	dsbdesc.lpwfxFormat = format;
	dsbdesc.dwFlags = DSBCAPS_LOCDEFER
							| DSBCAPS_CTRLPOSITIONNOTIFY
							| DSBCAPS_GETCURRENTPOSITION2;

	HRESULT hr;
	hr = svs.pDS->CreateSoundBuffer(&dsbdesc, &m_pBuf, NULL);

	if(FAILED(hr)){
		Debug("CWaveStream::CreateSoundBuffer\n");
		return FALSE;
	}
	//	TEhobt@̏
	LPBYTE	pBuf1, pBuf2;
	DWORD	size1, size2;

	hr = m_pBuf->Lock(
		0, m_size,
		(void **)&pBuf1, &size1,
		(void **)&pBuf2, &size2, 0);
	if(FAILED(hr)) return FALSE;

	ZeroMemory(pBuf1, size1);

	if(pBuf2!=NULL)
		ZeroMemory(pBuf2, size2);

	m_pBuf->Unlock(pBuf1, size1, pBuf2, size2);

	//	ʒmIuWFNg̍쐬
	m_pBuf->QueryInterface(IID_IDirectSoundNotify, (LPVOID *)&m_pNotify);

	if(FAILED(hr)){
		Debug("IDirectSoundNotify\n");
		return FALSE;
	}
	//	ʒmCxg̍쐬
	m_hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

	DSBPOSITIONNOTIFY *pn = new DSBPOSITIONNOTIFY[count];

	for(int i = 0; i<count; i++){
		pn[i].dwOffset = (size*i)+size-1;	//	size*i_H
		pn[i].hEventNotify = m_hEvent;
	}
	hr = m_pNotify->SetNotificationPositions(count, pn);
	delete [] pn;

	if(FAILED(hr)){
		Debug("SetNotificationPositions\n");
		return FALSE;
	}
	//	obt@Oobt@Ƃ݂Ȃă[vĐ
	m_wpos = 0;
	m_pBuf->Play(0, 0, DSBPLAY_LOOPING);

	return TRUE;
}

/*
 *	Xg[~OI
 */
void CWaveStream::End(){
	if(m_pBuf) m_pBuf->Stop();

	RELEASE(m_pBuf);
	RELEASE(m_pNotify);

	if(m_hEvent){
		CloseHandle(m_hEvent);
		m_hEvent = NULL;
	}
}

/*
 *	Xg[obt@Ƀf[^[
 *
 *	pData	: f[^
 *	size	: f[^TCYiBegin()Ŏw肵lƓj
 *
 *	Xg[obt@̍Đɓ܂B
 */
BOOL CWaveStream::Enqueue(LPBYTE pData, DWORD size){
	//	ʒmCxg҂
	DWORD ret = WaitForSingleObject(m_hEvent, STREAM_TIMEOUT);

	if(ret==WAIT_TIMEOUT){
		Debug("time out CWaveStream::Enqueue\n");
		return FALSE;
	}
	//	݃J[\̈SȈʒuɏC
	DWORD ppos, wpos;

	m_pBuf->GetCurrentPosition(&ppos, &wpos);

	if((ppos<wpos && (m_wpos>ppos && m_wpos<wpos))	//	 |ooPxxxWoo|
	|| (ppos>wpos && (m_wpos>ppos || m_wpos<wpos)))	//	 |xxWoooPxx|
		m_wpos = wpos;

	//	obt@bN
	LPBYTE	pBuf1, pBuf2;
	DWORD	size1, size2;
	HRESULT hr;

	hr = m_pBuf->Lock(
		m_wpos, size,
		(void **)&pBuf1, &size1,
		(void **)&pBuf2, &size2, 0);
	if(hr==DSERR_BUFFERLOST)	m_pBuf->Restore();
	else if(FAILED(hr))		return FALSE;

	//	f[^Rs[
	CopyMemory(pBuf1, pData, size1);

	if(pBuf2)
		CopyMemory(pBuf2, pData+size1, size2);

	//	obt@AbN
	m_pBuf->Unlock(pBuf1, size1, pBuf2, size2);

	//	݈ʒuXV
	m_wpos += size1;
	m_wpos %= m_size;	//	obt@TCY𒴂

	return TRUE;
}
