/**
 * @file comm.cpp
 * @brief UDX extension : Comm ̎
 */


#include "headers.h"
#include "debug.h"
#include "comm.h"

// Comm Ŏg֐
static BOOL InitPeer();
static BOOL InitDeviceAddress(DWORD dwPort);
static BOOL InitHostAddress(LPCTSTR lpszIP, DWORD dwPort);
static void ReceiveFunc(RECEIVE_DATA* pData, DWORD dwSize, LPARAM lParam);
static HRESULT CALLBACK DirectPlayMessageHandler(PVOID pvUserContext, DWORD dwMessageType, PVOID pMessage);


/**
 * @brief UDXp : DirectPlay ̏
 * @return Ƃ TRUECsƂ FALSE
 */
BOOL InitDirectPlay()
{
	DebugHL();
	Debug("InitDirectPlay\n");

	// DirectPlay ̏
	FAILED_ASSERT(
		"DirectPlay ł܂ł.",
		CoCreateInstance(
			CLSID_DirectPlay8Peer,
			NULL,
			CLSCTX_INPROC_SERVER,
			IID_IDirectPlay8Peer,
			(LPVOID*)&svc.pDP)
	);

	svc.pReceiveFunc = &ReceiveFunc;

	return TRUE;
}

BOOL InitPeer()
{
	// DirectPlay IuWFNg̏
	FAILED_ASSERT(
		"DirectPlay IuWFNg̏Ɏs܂D",
		svc.pDP->Initialize(NULL, &DirectPlayMessageHandler, 0)
	);
	return TRUE;
}

/**
 * @brief UDXp : DirectPlay ̉
 */
void FreeDirectPlay()
{
	if(!svc.pDP) return;

	DebugHL();
	Debug("FreeDirectPlay\n");
	
	svc.pDP->Close(0);			  // ZbVI
	RELEASE(svc.pHostAddress);
	RELEASE(svc.pDeviceAddress);
	RELEASE(svc.pDP);
}

/**
 * @brief foCXAhX̏
 * @param dwPort foCX̃|[g
 * @return Ƃ TRUECsƂ FALSE
 */
static BOOL InitDeviceAddress(DWORD dwPort)
{
	// foCXAhX̐
	FAILED_ASSERT(
		"foCXAhX̐Ɏs܂D",
		CoCreateInstance(
			CLSID_DirectPlay8Address,
			NULL,
			CLSCTX_INPROC_SERVER,
			IID_IDirectPlay8Address,
			(void**)&svc.pDeviceAddress)
	);

	// T[rXvoC_̐ݒ
	svc.pDeviceAddress->SetSP(&CLSID_DP8SP_TCPIP);

	// |[g̐ݒ
	if(dwPort) svc.pDeviceAddress->AddComponent(DPNA_KEY_PORT, &dwPort, sizeof(dwPort), DPNA_DATATYPE_DWORD);

	return TRUE;
}

/**
 * @brief zXgAhX̏
 * @param lpszIP zXg IP
 * @param dwPort zXg |[g
 * @return Ƃ TRUECsƂ FALSE
 */
static BOOL InitHostAddress(LPCTSTR lpszIP, DWORD dwPort)
{
	// zXgAhX̐
	FAILED_ASSERT(
		"zXgAhX̐Ɏs܂",
		CoCreateInstance(
			CLSID_DirectPlay8Address,
			NULL,
			CLSCTX_INPROC_SERVER,
			IID_IDirectPlay8Address,
			(void**)&svc.pHostAddress)
	);

	// T[rXvoC_̐ݒ
	svc.pHostAddress->SetSP(&CLSID_DP8SP_TCPIP);

	// zXg IP ̐ݒ
	if(lstrlen(lpszIP) > 0) svc.pHostAddress->AddComponent(DPNA_KEY_HOSTNAME, lpszIP, lstrlen(lpszIP)+1, DPNA_DATATYPE_STRING_ANSI);

	// zXg |[g ̐ݒ
	if(dwPort) svc.pHostAddress->AddComponent(DPNA_KEY_PORT, &dwPort, sizeof(dwPort), DPNA_DATATYPE_DWORD);

	return TRUE;
}

/**
 * @brief f[^MɌĂ΂M֐ݒ
 *
 * f[^MƂɌĂ΂M֐ݒ肷D
 * M֐ #PFN_RECEIVE ^ƓƖ߂ľ`֐łKvD
 * @param pReceiveFunc M֐ւ̃|C^
 * @param lParam M֐ɓn32bitlD
 */
void SetReceiveFunc(PFN_RECEIVE pReceiveFunc, LPARAM lParam)
{
	svc.pReceiveFunc = pReceiveFunc;
	svc.lReceiveParam = lParam;
}

/**
 * @brief ZbV쐬
 * @param pguidApp AvP[V GUID ւ̃|C^
 * @param lpszSessionName ZbV
 * @param dwPort gp|[gԍ
 * @return Ƃ TRUECsƂ FALSE
 */
BOOL CreateSession(const GUID* pguidApp, LPCTSTR lpszSessionName, DWORD dwPort)
{
 	InitPeer();

	svc.bHost = TRUE;

   // foCXAhX̏
	if(FAILED(InitDeviceAddress(dwPort))) return FALSE;

	// ZbV̐ݒ
	DPN_APPLICATION_DESC dpnAppDesc;
	ZeroMemory(&dpnAppDesc, sizeof(DPN_APPLICATION_DESC));
	WCHAR wszSessionName[MAX_SESSIONNAME];
	mbstowcs(wszSessionName, lpszSessionName, MAX_SESSIONNAME);
	dpnAppDesc.dwSize		   = sizeof(DPN_APPLICATION_DESC);
	dpnAppDesc.dwFlags		  = 0;//DPNSESSION_MIGRATE_HOST;
	dpnAppDesc.guidApplication  = *pguidApp;
	dpnAppDesc.pwszSessionName  = wszSessionName;

	// ZbV̍쐬
	if(FAILED(svc.pDP->Host(
		&dpnAppDesc,
		&svc.pDeviceAddress,
		1,
		NULL,
		NULL,
		NULL,
		DPNHOST_OKTOQUERYFORADDRESSING))
	) return FALSE;

	return TRUE;
}

/**
 * @brief ZbVɎQ
 * @param pguidApp AvP[V GUID ւ̃|C^
 * @param lpszHostIP zXg IP
 * @param dwHostPort zXg̃|[g
 * @param dwLocalPort [JfoCX̃|[g
 * @return ZbVɎQ邱ƂłƂ TRUECłȂƂ FALSE
 */
BOOL JoinSession(const GUID* pguidApp, LPCTSTR lpszHostIP, DWORD dwHostPort, DWORD dwLocalPort)
{
	InitPeer();

	svc.bHost = FALSE;

	// foCXAhX̏
	if(FAILED(InitDeviceAddress(dwLocalPort))) return FALSE;

	// zXgAhX̏
	if(FAILED(InitHostAddress(lpszHostIP, dwHostPort))) return FALSE;

	// ZbV
	DPN_APPLICATION_DESC dpnAppDesc;
	ZeroMemory(&dpnAppDesc, sizeof(DPN_APPLICATION_DESC));
	dpnAppDesc.dwSize		   = sizeof(DPN_APPLICATION_DESC);
	dpnAppDesc.guidApplication  = *pguidApp;

	// ėpp[^̐ݒ
	DPN_CAPS dpnCaps;
	ZeroMemory(&dpnCaps, sizeof(DPN_CAPS));
	dpnCaps.dwSize				  = sizeof(DPN_CAPS);
	dpnCaps.dwConnectTimeout		= 1000;	 //ڑvđM܂ł̎ԁimsbj
	dpnCaps.dwConnectRetries		= 1;		//ڑv𑗂
	dpnCaps.dwTimeoutUntilKeepAlive = 0;
	svc.pDP->SetCaps(&dpnCaps, 0);

	// ZbV̎Q
	if(FAILED(svc.pDP->Connect(
		&dpnAppDesc,
		svc.pHostAddress,
		svc.pDeviceAddress,
		NULL, NULL, NULL, 0, NULL, NULL, NULL,
		DPNCONNECT_OKTOQUERYFORADDRESSING | DPNCONNECT_SYNC))
	) return FALSE;

	return TRUE;
}

BOOL CloseSession()
{
	if(svc.pDP->Close(0)!=S_OK) return FALSE;
	return TRUE;
}

/**
 * @brief zXg񋓂ij
 * @param pguidApp AvP[V GUID ւ̃|C^
 * @param lpszHostIP zXg IP
 * @return Ƃ TRUECsƂ FALSE
 */
BOOL EnumHosts(const GUID* pguidApp, LPCTSTR lpszIP)
{
	// foCXAhX̏
	if(FAILED(InitDeviceAddress(NULL))) return FALSE;

	// zXgAhX̏
	if(FAILED(InitHostAddress(lpszIP, NULL))) return FALSE;

	// ZbV
	DPN_APPLICATION_DESC dpnAppDesc;
	ZeroMemory(&dpnAppDesc, sizeof(DPN_APPLICATION_DESC));
	dpnAppDesc.dwSize = sizeof(DPN_APPLICATION_DESC);
	dpnAppDesc.guidApplication = *pguidApp;

	// zXg̗
	FAILED_ASSERT(
		"zXg̗񋓂Ɏs܂D",
		svc.pDP->EnumHosts(
			&dpnAppDesc,							// application description
			svc.pHostAddress,					   // host address
			svc.pDeviceAddress,					 // device address
			NULL,								   // pointer to user data
			0,									  // user data size
			0,									  // retry count (0=default)
			0,									  // retry interval (0=default)
			0,									  // time out (0=default)
			NULL,								   // user context
			NULL,								   // async handle
			DPNENUMHOSTS_OKTOQUERYFORADDRESSING | DPNENUMHOSTS_SYNC)  // flags
	);

	return TRUE;
}

/**
 * @brief ZbVɎQĂSɃf[^𑗐M
 * @param pData Mf[^ւ̃|C^
 * @param dwSize Mf[^̃TCYiPʁFBytej
 * @return MɐƂ TRUECsƂ FALSE Ԃ
 */
BOOL SendToAll(const PVOID pData, DWORD dwSize)
{
	return SendTo(DPNID_ALL_PLAYERS_GROUP, pData, dwSize);
}

/**
 * @brief ZbV̓̑Ƀf[^𑗐M
 * @param dest M ID
 * @param pData Mf[^ւ̃|C^
 * @param dwSize Mf[^̃TCYiPʁFBytej
 * @return MɐƂ TRUECsƂ FALSE Ԃ
 */
BOOL SendTo(DPNID dest, const PVOID pData, DWORD dwSize)
{
	DPN_BUFFER_DESC dpnBuffer;

	dpnBuffer.pBufferData = (BYTE*)pData;
	dpnBuffer.dwBufferSize = dwSize;

	FAILED_ASSERT(
		"f[^̑MɎs܂D",
		svc.pDP->SendTo(dest, &dpnBuffer, 1, 0, NULL, NULL, DPNSEND_SYNC|DPNSEND_GUARANTEED)
	);

	return TRUE;
}

/**
 * @brief  ID 擾
 * @return  ID
 */
DPNID GetLocalPlayerID()
{
	return svc.idLocalPlayer;
}

/**
 * @brief zXgł邩ǂ𒲂ׂ
 * @return zXĝƂ TRUECzXgł͂ȂƂ FALSE
 */
BOOL IsHost()
{
	return svc.bHost;
}

/** 
 * @brief ftHg̎M֐
 *
 * ̊֐̓v[Xz_łCAvP[VœƎ #PFN_RECEIVE ^̊֐`C
 * SetReceiveFunc() ɂM֐ƂĐݒ肷KvD
 * @param pData Mf[^ւ̃|C^
 * @param dwSize Mf[^̃TCYiPʁFBytej
 * @param lParam SetReceiveFunc ֐ɂݒ肳ꂽ 32bitl
 */
void ReceiveFunc(RECEIVE_DATA* pData, DWORD dwSize, LPARAM lParam)
{
	// Ȃ
	Debug("ReceiveFunc()\n");
}

/**
 * bZ[W
 * @param pvUserContext
 * @param dwMessageType
 * @param pMessage
 * @return ɃbZ[WƂ S_OK Ԃ
 */
static HRESULT CALLBACK DirectPlayMessageHandler(PVOID pvUserContext, DWORD dwMessageType, PVOID pMessage)
{

	switch(dwMessageType){

	case DPN_MSGID_CREATE_PLAYER:
		{
			PDPNMSG_CREATE_PLAYER pCreatePlayerMsg;
			PDPN_PLAYER_INFO pdpnPlayerInfo = NULL;
			DWORD dwSize = 0;

			pCreatePlayerMsg = (PDPNMSG_CREATE_PLAYER)pMessage;

			// DPN_PLAYER_INFO ̃TCY擾
			HRESULT hr;
			hr = svc.pDP->GetPeerInfo(pCreatePlayerMsg->dpnidPlayer, pdpnPlayerInfo, &dwSize, 0);
			if(hr != DPNERR_BUFFERTOOSMALL) return FALSE;
			pdpnPlayerInfo = (DPN_PLAYER_INFO*) new BYTE[dwSize];
			ZeroMemory(pdpnPlayerInfo, dwSize);
			pdpnPlayerInfo->dwSize = sizeof(DPN_PLAYER_INFO);

			// DPN_PLAYER_INFO 擾
			FAILED_ASSERT(
				"vC̎擾Ɏs܂D",
				svc.pDP->GetPeerInfo(pCreatePlayerMsg->dpnidPlayer, pdpnPlayerInfo, &dwSize, 0)
			);

			// 쐬ꂽvCfobOo
			Debug("PlayerInfo: dpnidPlayer = %x, dwPlayerFlags = %d\n",
				pCreatePlayerMsg->dpnidPlayer, pdpnPlayerInfo->dwPlayerFlags);

			// vC[̏擾
			if(pdpnPlayerInfo->dwPlayerFlags & DPNPLAYER_LOCAL){
				//  DPNID 擾
				svc.idLocalPlayer = pCreatePlayerMsg->dpnidPlayer;
				if(pdpnPlayerInfo->dwPlayerFlags & DPNPLAYER_HOST){
					// zXĝƂ
					svc.bHost = TRUE;
				}
			}
		}

	case DPN_MSGID_DESTROY_PLAYER:
		break;

		/*
	case DPN_MSGID_HOST_MIGRATE:
		{
			PDPNMSG_HOST_MIGRATE pHostMigrateMsg;
			pHostMigrateMsg = (PDPNMSG_HOST_MIGRATE)pMessage;

			if(pHostMigrateMsg->dpnidNewHost == svc.idLocalPlayer){
				// VzXg ID Ǝ ID Ƃ
				svc.bHost = TRUE;
			}

			break;
		}
		*/

	case DPN_MSGID_ENUM_HOSTS_RESPONSE:
		{
			// 

			//PDPNMSG_ENUM_HOSTS_RESPONSE pEnumHostsResponseMsg;
			//pEnumHostsResponseMsg = (PDPNMSG_ENUM_HOSTS_RESPONSE)pMessage;
			break;
		}

	case DPN_MSGID_RECEIVE:
		{
			PDPNMSG_RECEIVE pReceiveMsg;
			pReceiveMsg = (PDPNMSG_RECEIVE)pMessage;

			// M֐ɎMf[^n
			svc.pReceiveFunc(
				pReceiveMsg->pReceiveData,
				pReceiveMsg->dwReceiveDataSize,
				svc.lReceiveParam
			);

		}

	}

	return S_OK;
}
